/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.chromattic.api.query.Ordering;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.api.query.QueryResult;
import org.chromattic.core.query.QueryImpl;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.chromattic.entity.IdentityEntity;
import org.exoplatform.social.core.chromattic.entity.ProfileEntity;
import org.exoplatform.social.core.chromattic.entity.RelationshipEntity;
import org.exoplatform.social.core.chromattic.entity.RelationshipListEntity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.profile.ProfileLoader;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.IdentityStorageException;
import org.exoplatform.social.core.storage.RelationshipStorageException;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.api.ActivityStreamStorage;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.RelationshipStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStreamStorage;
import org.exoplatform.social.core.storage.exception.NodeNotFoundException;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.impl.StorageUtils;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.query.WhereExpression;
import org.exoplatform.social.core.storage.streams.StreamInvocationHelper;

public class RelationshipStorageImpl
extends AbstractStorage
implements RelationshipStorage {
    private static final Log LOG = ExoLogger.getLogger(RelationshipStorage.class);
    private final IdentityStorage identityStorage;
    private RelationshipManager relationshipManager;
    private RelationshipStorage relationshipStorage;
    private CachedActivityStorage cachedActivityStorage;
    private CachedActivityStreamStorage streamStorage;

    public RelationshipStorageImpl(IdentityStorage identityStorage) {
        this.identityStorage = identityStorage;
    }

    private RelationshipManager getRelationshipManager() {
        if (this.relationshipManager == null) {
            PortalContainer container = PortalContainer.getInstance();
            this.relationshipManager = (RelationshipManager)container.getComponentInstanceOfType(RelationshipManager.class);
        }
        return this.relationshipManager;
    }

    private CachedActivityStorage getCachedActivityStorage() {
        if (this.cachedActivityStorage == null) {
            PortalContainer container = PortalContainer.getInstance();
            this.cachedActivityStorage = (CachedActivityStorage)container.getComponentInstanceOfType(ActivityStorage.class);
        }
        return this.cachedActivityStorage;
    }

    private CachedActivityStreamStorage getCachedActivityStreamStorage() {
        if (this.streamStorage == null) {
            PortalContainer container = PortalContainer.getInstance();
            this.streamStorage = (CachedActivityStreamStorage)container.getComponentInstanceOfType(ActivityStreamStorage.class);
        }
        return this.streamStorage;
    }

    private void putRelationshipToList(List<Relationship> relationships, RelationshipListEntity list) {
        if (list != null) {
            for (Map.Entry<String, RelationshipEntity> entry : list.getRelationships().entrySet()) {
                Relationship relationship = new Relationship(entry.getValue().getId());
                RelationshipEntity relationshipEntity = entry.getValue();
                IdentityEntity senderEntity = relationshipEntity.getFrom();
                IdentityEntity receiverEntity = relationshipEntity.getTo();
                Identity sender = new Identity(senderEntity.getId());
                sender.setRemoteId(senderEntity.getRemoteId());
                sender.setProviderId(senderEntity.getProviderId());
                ProfileEntity senderProfileEntity = senderEntity.getProfile();
                if (senderProfileEntity != null) {
                    this.loadProfile(sender);
                }
                Identity receiver = new Identity(receiverEntity.getId());
                receiver.setRemoteId(receiverEntity.getRemoteId());
                receiver.setProviderId(receiverEntity.getProviderId());
                ProfileEntity receiverProfileEntity = receiverEntity.getProfile();
                if (receiverProfileEntity != null) {
                    this.loadProfile(receiver);
                }
                relationship.setSender(sender);
                relationship.setReceiver(receiver);
                if ("sender".equals(entry.getValue().getParent().getName()) || "receiver".equals(entry.getValue().getParent().getName())) {
                    relationship.setStatus(Relationship.Type.PENDING);
                } else {
                    relationship.setStatus(Relationship.Type.CONFIRMED);
                }
                relationships.add(relationship);
            }
        }
    }

    private void putReceiverRelationshipToList(List<Relationship> relationships, RelationshipListEntity list, Identity receiver) {
        if (list != null) {
            for (Map.Entry<String, RelationshipEntity> entry : list.getRelationships().entrySet()) {
                Relationship relationship = new Relationship(entry.getValue().getId());
                RelationshipEntity relationshipEntity = entry.getValue();
                IdentityEntity senderEntity = relationshipEntity.getFrom();
                if (senderEntity.getId().equals(receiver.getId())) {
                    senderEntity = relationshipEntity.getTo();
                }
                Identity sender = new Identity(senderEntity.getId());
                sender.setRemoteId(senderEntity.getRemoteId());
                sender.setProviderId(senderEntity.getProviderId());
                ProfileEntity senderProfileEntity = senderEntity.getProfile();
                if (senderProfileEntity != null) {
                    this.loadProfile(sender);
                }
                if (receiver.getProfile() != null) {
                    this.loadProfile(receiver);
                }
                relationship.setSender(sender);
                relationship.setReceiver(receiver);
                relationship.setStatus(Relationship.Type.PENDING);
                relationships.add(relationship);
            }
        }
    }

    private void loadProfile(final Identity identity) {
        ProfileLoader loader = new ProfileLoader(){

            @Override
            public Profile load() throws IdentityStorageException {
                Profile profile = new Profile(identity);
                return RelationshipStorageImpl.this.identityStorage.loadProfile(profile);
            }
        };
        identity.setProfileLoader(loader);
    }

    private List<Identity> getIdentitiesFromRelationship(Iterator<RelationshipEntity> it, Origin origin, long offset, long limit) {
        LinkedHashSet<Identity> identities = new LinkedHashSet<Identity>();
        int i = 0;
        this._skip(it, offset);
        Identity identity = null;
        while (it.hasNext()) {
            RelationshipEntity relationshipEntity = it.next();
            switch (origin) {
                case FROM: {
                    identity = this.createIdentityFromEntity(relationshipEntity.getFrom());
                    identities.add(identity);
                    break;
                }
                case TO: {
                    identity = this.createIdentityFromEntity(relationshipEntity.getTo());
                    identities.add(identity);
                }
            }
            if (limit == -1L || limit <= 0L || (long)(++i) < limit) continue;
            break;
        }
        return new ArrayList<Identity>(identities);
    }

    private List<Identity> getIdentitiesFromRelationship(Iterator<RelationshipEntity> it, Identity current, long offset, long limit) {
        LinkedHashSet<Identity> identities = new LinkedHashSet<Identity>();
        int i = 0;
        this._skip(it, offset);
        Identity identity = null;
        while (it.hasNext()) {
            RelationshipEntity relationshipEntity = it.next();
            IdentityEntity entity = relationshipEntity.getFrom();
            if (entity.getId().equals(current.getId())) {
                entity = relationshipEntity.getTo();
            }
            identity = this.createIdentityFromEntity(entity);
            identities.add(identity);
            if (limit == -1L || limit <= 0L || (long)(++i) < limit) continue;
            break;
        }
        return new ArrayList<Identity>(identities);
    }

    private Identity createIdentityFromEntity(IdentityEntity entity) {
        Identity identity = this.identityStorage.findIdentityById(entity.getId());
        this.loadProfile(identity);
        return identity;
    }

    private List<Identity> getIdentitiesRelationsByFilter(List<Identity> relations, ProfileFilter filter, long offset, long limit) {
        if (relations.isEmpty()) {
            return new ArrayList<Identity>();
        }
        ArrayList<Identity> found = new ArrayList<Identity>();
        if (relations.isEmpty()) {
            return found;
        }
        QueryBuilder builder = this.getSession().createQueryBuilder(ProfileEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        StorageUtils.applyWhereFromIdentity(whereExpression, relations);
        StorageUtils.applyFilter(whereExpression, filter);
        builder.where(whereExpression.toString()).orderBy(ProfileEntity.fullName.getName(), Ordering.ASC);
        QueryImpl queryImpl = (QueryImpl)builder.get();
        ((org.exoplatform.services.jcr.impl.core.query.QueryImpl)queryImpl.getNativeQuery()).setCaseInsensitiveOrder(true);
        QueryResult result = queryImpl.objects(Long.valueOf(offset), Long.valueOf(limit));
        while (result.hasNext()) {
            IdentityEntity current = ((ProfileEntity)result.next()).getIdentity();
            Identity i = new Identity(current.getProviderId(), current.getRemoteId());
            i.setId(current.getId());
            found.add(i);
        }
        return found;
    }

    private int getIdentitiesRelationsByFilterCount(List<Identity> relations, ProfileFilter filter) {
        if (relations.size() == 0) {
            return 0;
        }
        QueryBuilder builder = this.getSession().createQueryBuilder(ProfileEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        StorageUtils.applyWhereFromIdentity(whereExpression, relations);
        StorageUtils.applyFilter(whereExpression, filter);
        return builder.where(whereExpression.toString()).get().objects().size();
    }

    private RelationshipStorage getStorage() {
        return this.relationshipStorage != null ? this.relationshipStorage : this;
    }

    protected RelationshipEntity _createRelationship(Relationship relationship) throws NodeNotFoundException {
        String identityId1 = relationship.getSender().getId();
        String identityId2 = relationship.getReceiver().getId();
        IdentityEntity identity1 = this._findById(IdentityEntity.class, identityId1);
        IdentityEntity identity2 = this._findById(IdentityEntity.class, identityId2);
        RelationshipEntity createdRelationship = identity1.createRelationship();
        RelationshipEntity symmetricalRelationship = identity2.createRelationship();
        switch (relationship.getStatus()) {
            case PENDING: {
                identity1.getSender().getRelationships().put(identity2.getRemoteId(), createdRelationship);
                identity2.getReceiver().getRelationships().put(identity1.getRemoteId(), symmetricalRelationship);
                createdRelationship.setFrom(identity1);
                createdRelationship.setTo(identity2);
                symmetricalRelationship.setFrom(identity1);
                symmetricalRelationship.setTo(identity2);
                break;
            }
            case CONFIRMED: {
                identity1.getRelationship().getRelationships().put(identity2.getRemoteId(), createdRelationship);
                identity2.getRelationship().getRelationships().put(identity1.getRemoteId(), symmetricalRelationship);
                createdRelationship.setFrom(identity1);
                createdRelationship.setTo(identity2);
                symmetricalRelationship.setFrom(identity2);
                symmetricalRelationship.setTo(identity1);
                break;
            }
            case IGNORED: {
                identity1.getIgnore().getRelationships().put(identity2.getRemoteId(), createdRelationship);
                identity2.getIgnored().getRelationships().put(identity1.getRemoteId(), symmetricalRelationship);
                createdRelationship.setFrom(identity1);
                createdRelationship.setTo(identity2);
                symmetricalRelationship.setFrom(identity1);
                symmetricalRelationship.setTo(identity2);
            }
        }
        long createdTimeStamp = System.currentTimeMillis();
        createdRelationship.setReciprocal(symmetricalRelationship);
        createdRelationship.setStatus(relationship.getStatus().toString());
        createdRelationship.setCreatedTime(createdTimeStamp);
        symmetricalRelationship.setReciprocal(createdRelationship);
        symmetricalRelationship.setStatus(relationship.getStatus().toString());
        symmetricalRelationship.setCreatedTime(createdTimeStamp);
        relationship.setId(createdRelationship.getId());
        this.getSession().save();
        LOG.debug((Object)String.format("Relationship from %s:%s to %s:%s created (%s)", createdRelationship.getFrom().getProviderId(), createdRelationship.getFrom().getRemoteId(), createdRelationship.getTo().getProviderId(), createdRelationship.getTo().getRemoteId(), createdRelationship.getPath()));
        LOG.debug((Object)String.format("Symmetrical relationship from %s:%s to %s:%s created (%s)", symmetricalRelationship.getFrom().getProviderId(), symmetricalRelationship.getFrom().getRemoteId(), symmetricalRelationship.getTo().getProviderId(), symmetricalRelationship.getTo().getRemoteId(), symmetricalRelationship.getPath()));
        return createdRelationship;
    }

    protected RelationshipEntity _saveRelationship(Relationship relationship) throws NodeNotFoundException {
        RelationshipEntity savedRelationship = this._findById(RelationshipEntity.class, relationship.getId());
        RelationshipEntity symmetricalRelationship = savedRelationship.getReciprocal();
        IdentityEntity sender = this._findById(IdentityEntity.class, relationship.getSender().getId());
        IdentityEntity receiver = this._findById(IdentityEntity.class, relationship.getReceiver().getId());
        savedRelationship.setStatus(relationship.getStatus().toString());
        symmetricalRelationship.setStatus(relationship.getStatus().toString());
        switch (relationship.getStatus()) {
            case PENDING: {
                savedRelationship.getParent().getParent().getSender().getRelationships().put(savedRelationship.getName(), savedRelationship);
                symmetricalRelationship.getParent().getParent().getReceiver().getRelationships().put(symmetricalRelationship.getName(), symmetricalRelationship);
                break;
            }
            case CONFIRMED: {
                savedRelationship.setFrom(sender);
                savedRelationship.setTo(receiver);
                symmetricalRelationship.setFrom(receiver);
                symmetricalRelationship.setTo(sender);
                savedRelationship.getParent().getParent().getRelationship().getRelationships().put(savedRelationship.getName(), savedRelationship);
                symmetricalRelationship.getParent().getParent().getRelationship().getRelationships().put(symmetricalRelationship.getName(), symmetricalRelationship);
                StreamInvocationHelper.connect(relationship.getSender(), relationship.getReceiver());
            }
        }
        LOG.debug((Object)String.format("Relationship from %s:%s to %s:%s saved (%s)", savedRelationship.getFrom().getProviderId(), savedRelationship.getFrom().getRemoteId(), savedRelationship.getTo().getProviderId(), savedRelationship.getTo().getRemoteId(), savedRelationship.getPath()));
        LOG.debug((Object)String.format("Symmetrical relationship from %s:%s to %s:%s saved (%s)", symmetricalRelationship.getFrom().getProviderId(), symmetricalRelationship.getFrom().getRemoteId(), symmetricalRelationship.getTo().getProviderId(), symmetricalRelationship.getTo().getRemoteId(), symmetricalRelationship.getPath()));
        return savedRelationship;
    }

    protected List<Relationship> _getSenderRelationships(Identity sender, Relationship.Type type, List<Identity> listCheckIdentity) throws NodeNotFoundException {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        IdentityEntity senderEntity = this._findById(IdentityEntity.class, sender.getId());
        if (type == null) {
            this.putRelationshipToList(relationships, senderEntity.getRelationship());
            this.putRelationshipToList(relationships, senderEntity.getSender());
        } else {
            switch (type) {
                case CONFIRMED: {
                    this.putRelationshipToList(relationships, senderEntity.getRelationship());
                    break;
                }
                case PENDING: {
                    this.putRelationshipToList(relationships, senderEntity.getSender());
                }
            }
        }
        return relationships;
    }

    protected List<Relationship> _getReceiverRelationships(Identity receiver, Relationship.Type type, List<Identity> listCheckIdentity) throws NodeNotFoundException {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        IdentityEntity receiverEntity = this._findById(IdentityEntity.class, receiver.getId());
        if (type == null) {
            this.putRelationshipToList(relationships, receiverEntity.getRelationship());
            this.putRelationshipToList(relationships, receiverEntity.getReceiver());
        } else {
            switch (type) {
                case CONFIRMED: {
                    this.putRelationshipToList(relationships, receiverEntity.getRelationship());
                    break;
                }
                case PENDING: {
                    this.putReceiverRelationshipToList(relationships, receiverEntity.getReceiver(), receiver);
                }
            }
        }
        return relationships;
    }

    protected Relationship _getRelationship(String uuid) throws NodeNotFoundException {
        RelationshipEntity relationshipEntity = this._findById(RelationshipEntity.class, uuid);
        IdentityEntity receiverEntity = relationshipEntity.getTo();
        IdentityEntity senderEntity = relationshipEntity.getFrom();
        Identity receiver = this.identityStorage.findIdentityById(receiverEntity.getId());
        Identity sender = this.identityStorage.findIdentityById(senderEntity.getId());
        Relationship relationship = new Relationship(uuid);
        if (relationshipEntity.isReceiver()) {
            relationship.setSender(receiver);
            relationship.setReceiver(sender);
        } else {
            relationship.setSender(sender);
            relationship.setReceiver(receiver);
        }
        if ("sender".equals(relationshipEntity.getParent().getName()) || "receiver".equals(relationshipEntity.getParent().getName())) {
            relationship.setStatus(Relationship.Type.PENDING);
        } else {
            relationship.setStatus(Relationship.Type.CONFIRMED);
        }
        return relationship;
    }

    protected Relationship _getRelationship(Identity identity1, Identity identity2) throws RelationshipStorageException, NodeNotFoundException {
        IdentityEntity identityEntity1 = this._findById(IdentityEntity.class, identity1.getId());
        IdentityEntity identityEntity2 = this._findById(IdentityEntity.class, identity2.getId());
        RelationshipEntity got = identityEntity1.getRelationship().getRelationships().get(identityEntity2.getName());
        if (got == null) {
            got = identityEntity1.getSender().getRelationships().get(identity2.getRemoteId());
        }
        if (got == null) {
            got = identityEntity2.getSender().getRelationships().get(identity1.getRemoteId());
        }
        if (got == null) {
            throw new NodeNotFoundException();
        }
        Relationship relationship = new Relationship(got.getId());
        IdentityEntity senderEntity = got.getFrom();
        IdentityEntity receiverEntity = got.getTo();
        Identity sender = new Identity(senderEntity.getId());
        sender.setRemoteId(senderEntity.getRemoteId());
        sender.setProviderId(senderEntity.getProviderId());
        Identity receiver = new Identity(receiverEntity.getId());
        receiver.setRemoteId(receiverEntity.getRemoteId());
        receiver.setProviderId(receiverEntity.getProviderId());
        relationship.setSender(sender);
        relationship.setReceiver(receiver);
        relationship.setStatus(Relationship.Type.valueOf(got.getStatus()));
        return relationship;
    }

    @Override
    public Relationship saveRelationship(Relationship relationship) throws RelationshipStorageException {
        try {
            if (relationship.getId() == null) {
                this._createRelationship(relationship);
            } else {
                StorageUtils.persist();
                this._saveRelationship(relationship);
            }
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.ILLEGAL_ARGUMENTS, new String[]{Relationship.class.getSimpleName()});
        }
        return relationship;
    }

    @Override
    public void removeRelationship(Relationship relationship) throws RelationshipStorageException {
        try {
            RelationshipEntity toDeleteRelationship = this._findById(RelationshipEntity.class, relationship.getId());
            RelationshipEntity symmetricalRelationship = toDeleteRelationship.getReciprocal();
            IdentityEntity from = toDeleteRelationship.getFrom();
            IdentityEntity to = toDeleteRelationship.getFrom();
            this._removeById(RelationshipEntity.class, symmetricalRelationship.getId());
            this._removeById(RelationshipEntity.class, relationship.getId());
            StorageUtils.persist();
            StreamInvocationHelper.deleteConnect(relationship.getSender(), relationship.getReceiver());
            this.getCachedActivityStorage().clearCache();
            LOG.debug((Object)String.format("Symmetrical relationship from %s:%s to %s:%s removed", to.getProviderId(), to.getRemoteId(), from.getProviderId(), from.getRemoteId()));
            LOG.debug((Object)String.format("Relationship from %s:%s to %s:%s removed", from.getProviderId(), from.getRemoteId(), to.getProviderId(), to.getRemoteId()));
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP);
        }
    }

    @Override
    public Relationship getRelationship(String uuid) throws RelationshipStorageException {
        try {
            return this._getRelationship(uuid);
        }
        catch (NodeNotFoundException e) {
            return null;
        }
    }

    @Override
    public List<Relationship> getSenderRelationships(Identity sender, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        try {
            return this._getSenderRelationships(sender, type, listCheckIdentity);
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, null, e, sender.getId(), type.toString());
        }
    }

    @Override
    public List<Relationship> getSenderRelationships(String senderId, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        return this.getSenderRelationships(new Identity(senderId), type, listCheckIdentity);
    }

    @Override
    public List<Relationship> getReceiverRelationships(Identity receiver, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        try {
            return this._getReceiverRelationships(receiver, type, listCheckIdentity);
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, null, e, receiver.getId(), type.toString());
        }
    }

    @Override
    public Relationship getRelationship(Identity identity1, Identity identity2) throws RelationshipStorageException {
        try {
            return this._getRelationship(identity1, identity2);
        }
        catch (NodeNotFoundException e) {
            return null;
        }
    }

    @Override
    public List<Relationship> getRelationships(Identity identity, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        try {
            ArrayList<Relationship> relationships = new ArrayList<Relationship>();
            IdentityEntity receiverEntity = this._findById(IdentityEntity.class, identity.getId());
            if (type == null) {
                this.putRelationshipToList(relationships, receiverEntity.getRelationship());
                this.putRelationshipToList(relationships, receiverEntity.getReceiver());
                this.putRelationshipToList(relationships, receiverEntity.getSender());
            } else {
                switch (type) {
                    case CONFIRMED: {
                        this.putRelationshipToList(relationships, receiverEntity.getRelationship());
                        break;
                    }
                    case PENDING: {
                        this.putRelationshipToList(relationships, receiverEntity.getReceiver());
                        this.putRelationshipToList(relationships, receiverEntity.getSender());
                        break;
                    }
                    case IGNORED: {
                        this.putRelationshipToList(relationships, receiverEntity.getIgnored());
                    }
                }
            }
            return relationships;
        }
        catch (NodeNotFoundException e) {
            return new ArrayList<Relationship>();
        }
    }

    @Override
    public List<Identity> getRelationships(Identity identity, long offset, long limit) throws RelationshipStorageException {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        try {
            IdentityEntity identityEntity = this._findById(IdentityEntity.class, identity.getId());
            QueryBuilder builder = this.getSession().createQueryBuilder(RelationshipEntity.class);
            WhereExpression whereExpression = new WhereExpression();
            whereExpression.like(JCRProperties.path, identityEntity.getPath() + "/" + "%");
            builder.where(whereExpression.toString());
            builder.orderBy(RelationshipEntity.createdTime.getName(), Ordering.DESC);
            QueryResult results = builder.get().objects(Long.valueOf(offset), Long.valueOf(limit));
            while (results.hasNext()) {
                RelationshipEntity currentRelationshipEntity = (RelationshipEntity)results.next();
                IdentityEntity gotIdentityEntity = currentRelationshipEntity.isReceiver() ? currentRelationshipEntity.getFrom() : currentRelationshipEntity.getTo();
                Identity newIdentity = new Identity(gotIdentityEntity.getId());
                newIdentity.setProviderId(gotIdentityEntity.getProviderId());
                newIdentity.setRemoteId(gotIdentityEntity.getRemoteId());
                identities.add(newIdentity);
            }
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, e.getMessage());
        }
        return identities;
    }

    @Override
    public List<Identity> getIncomingRelationships(Identity receiver, long offset, long limit) throws RelationshipStorageException {
        try {
            IdentityEntity receiverEntity = this._findById(IdentityEntity.class, receiver.getId());
            Iterator<RelationshipEntity> it = receiverEntity.getReceiver().getRelationships().values().iterator();
            return this.getIdentitiesFromRelationship(it, receiver, offset, limit);
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, e.getMessage());
        }
    }

    @Override
    public int getIncomingRelationshipsCount(Identity receiver) throws RelationshipStorageException {
        try {
            IdentityEntity receiverEntity = this._findById(IdentityEntity.class, receiver.getId());
            return receiverEntity.getReceiver().getRelationships().size();
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, e.getMessage());
        }
    }

    @Override
    public List<Identity> getOutgoingRelationships(Identity sender, long offset, long limit) throws RelationshipStorageException {
        try {
            IdentityEntity senderEntity = this._findById(IdentityEntity.class, sender.getId());
            Iterator<RelationshipEntity> it = senderEntity.getSender().getRelationships().values().iterator();
            return this.getIdentitiesFromRelationship(it, Origin.TO, offset, limit);
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, e.getMessage());
        }
    }

    @Override
    public int getOutgoingRelationshipsCount(Identity sender) throws RelationshipStorageException {
        try {
            IdentityEntity receiverEntity = this._findById(IdentityEntity.class, sender.getId());
            return receiverEntity.getSender().getRelationships().size();
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, e.getMessage());
        }
    }

    @Override
    public int getRelationshipsCount(Identity identity) throws RelationshipStorageException {
        int nb = 0;
        try {
            IdentityEntity identityEntity = this._findById(IdentityEntity.class, identity.getId());
            nb += identityEntity.getRelationship().getRelationships().size();
            nb += identityEntity.getSender().getRelationships().size();
            nb += identityEntity.getReceiver().getRelationships().size();
            return nb += identityEntity.getIgnore().getRelationships().size();
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, e.getMessage());
        }
    }

    @Override
    public List<Identity> getConnections(Identity identity, long offset, long limit) throws RelationshipStorageException {
        try {
            IdentityEntity identityEntity = this._findById(IdentityEntity.class, identity.getId());
            Iterator<RelationshipEntity> it = identityEntity.getRelationship().getRelationships().values().iterator();
            return this.getIdentitiesFromRelationship(it, Origin.TO, offset, limit);
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.ILLEGAL_ARGUMENTS);
        }
    }

    @Override
    public List<Identity> getConnections(Identity identity) throws RelationshipStorageException {
        return this.getConnections(identity, 0L, -1L);
    }

    @Override
    public int getConnectionsCount(Identity identity) throws RelationshipStorageException {
        try {
            IdentityEntity identityEntity = this._findById(IdentityEntity.class, identity.getId());
            return identityEntity.getRelationship().getRelationships().size();
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.ILLEGAL_ARGUMENTS);
        }
    }

    @Override
    public List<Identity> getConnectionsByFilter(Identity existingIdentity, ProfileFilter profileFilter, long offset, long limit) throws RelationshipStorageException {
        List<Identity> identities = this.getStorage().getConnections(existingIdentity);
        return this.getIdentitiesRelationsByFilter(identities, profileFilter, offset, limit);
    }

    @Override
    public List<Identity> getIncomingByFilter(Identity existingIdentity, ProfileFilter profileFilter, long offset, long limit) throws RelationshipStorageException {
        if (profileFilter.isEmpty()) {
            return StorageUtils.sortIdentitiesByFullName(this.getIncomingRelationships(existingIdentity, offset, limit), true);
        }
        List<Identity> identities = this.getStorage().getIncomingRelationships(existingIdentity, 0L, -1L);
        return this.getIdentitiesRelationsByFilter(identities, profileFilter, offset, limit);
    }

    @Override
    public List<Identity> getOutgoingByFilter(Identity existingIdentity, ProfileFilter profileFilter, long offset, long limit) throws RelationshipStorageException {
        if (profileFilter.isEmpty()) {
            return StorageUtils.sortIdentitiesByFullName(this.getOutgoingRelationships(existingIdentity, offset, limit), true);
        }
        List<Identity> identities = this.getStorage().getOutgoingRelationships(existingIdentity, 0L, -1L);
        return this.getIdentitiesRelationsByFilter(identities, profileFilter, offset, limit);
    }

    @Override
    public int getIncomingCountByFilter(Identity existingIdentity, ProfileFilter profileFilter) throws RelationshipStorageException {
        if (profileFilter.isEmpty()) {
            return this.getIncomingRelationshipsCount(existingIdentity);
        }
        List<Identity> identities = this.getStorage().getIncomingRelationships(existingIdentity, 0L, -1L);
        return this.getIdentitiesRelationsByFilterCount(identities, profileFilter);
    }

    @Override
    public int getConnectionsCountByFilter(Identity existingIdentity, ProfileFilter profileFilter) throws RelationshipStorageException {
        List<Identity> identities = this.getStorage().getConnections(existingIdentity);
        return this.getIdentitiesRelationsByFilterCount(identities, profileFilter);
    }

    @Override
    public int getOutgoingCountByFilter(Identity existingIdentity, ProfileFilter profileFilter) throws RelationshipStorageException {
        if (profileFilter.isEmpty()) {
            return this.getOutgoingRelationshipsCount(existingIdentity);
        }
        List<Identity> identities = this.getStorage().getOutgoingRelationships(existingIdentity, 0L, -1L);
        return this.getIdentitiesRelationsByFilterCount(identities, profileFilter);
    }

    @Override
    public Map<Identity, Integer> getSuggestions(Identity currentIdentity, int maxConnections, int maxConnectionsToLoad, int maxSuggestions) throws RelationshipStorageException {
        try {
            return this._getSuggestions(currentIdentity, maxConnections, maxConnectionsToLoad, maxSuggestions);
        }
        catch (Exception e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_SUGGESTION, e);
        }
    }

    public Map<Identity, Integer> _getSuggestions(Identity currentIdentity, int maxConnections, int maxConnectionsToLoad, int maxSuggestions) throws Exception {
        Identity[] connections;
        int endIndex;
        if (maxConnectionsToLoad > 0 && maxConnections > maxConnectionsToLoad) {
            maxConnectionsToLoad = maxConnections;
        }
        HashSet<Identity> relationIdLevel1 = new HashSet<Identity>();
        RelationshipManager relationshipManager = this.getRelationshipManager();
        ListAccess<Identity> allConnections = relationshipManager.getConnections(currentIdentity);
        int size = allConnections.getSize();
        Random random = new Random();
        if (size > maxConnectionsToLoad && maxConnectionsToLoad > 0 && maxConnections > 0) {
            int startIndex = random.nextInt(size - maxConnectionsToLoad);
            endIndex = maxConnections;
            connections = (Identity[])allConnections.load(startIndex, maxConnectionsToLoad);
        } else {
            endIndex = size;
            connections = (Identity[])allConnections.load(0, size);
        }
        for (int i = 0; i < connections.length; ++i) {
            Identity id = connections[i];
            relationIdLevel1.add(id);
        }
        relationIdLevel1.remove(currentIdentity);
        HashMap<Identity, Integer> suggestedIdentities = new HashMap<Identity, Integer>();
        Iterator it = relationIdLevel1.iterator();
        for (int j = 0; j < size && it.hasNext(); ++j) {
            Identity id = (Identity)it.next();
            if (j >= endIndex && suggestedIdentities.size() > maxSuggestions && maxSuggestions > 0) break;
            ListAccess<Identity> allConns = relationshipManager.getConnections(id);
            int allConnSize = allConns.getSize();
            int allConnStartIndex = 0;
            if (allConnSize > maxConnections && maxConnections > 0) {
                allConnStartIndex = random.nextInt(allConnSize - maxConnections);
                connections = (Identity[])allConns.load(allConnStartIndex, maxConnections);
            } else {
                connections = (Identity[])allConns.load(0, allConnSize);
            }
            for (int i = 0; i < connections.length; ++i) {
                Identity ids = connections[i];
                if (relationIdLevel1.contains(ids) || ids.equals(currentIdentity) || ids.isDeleted() || relationshipManager.get(ids, currentIdentity) != null) continue;
                Integer commonIdentities = (Integer)suggestedIdentities.get(ids);
                commonIdentities = commonIdentities == null ? new Integer(1) : new Integer(commonIdentities + 1);
                suggestedIdentities.put(ids, commonIdentities);
            }
        }
        TreeMap<Integer, ArrayList<Identity>> groupByCommonConnections = new TreeMap<Integer, ArrayList<Identity>>();
        for (Identity identity : suggestedIdentities.keySet()) {
            Integer commonIdentities = (Integer)suggestedIdentities.get(identity);
            ArrayList<Identity> ids = (ArrayList<Identity>)groupByCommonConnections.get(commonIdentities);
            if (ids == null) {
                ids = new ArrayList<Identity>();
                groupByCommonConnections.put(commonIdentities, ids);
            }
            ids.add(identity);
        }
        LinkedHashMap<Identity, Integer> suggestions = new LinkedHashMap<Identity, Integer>();
        int suggestionLeft = maxSuggestions;
        block4: for (Integer key : groupByCommonConnections.descendingKeySet()) {
            List ids = (List)groupByCommonConnections.get(key);
            for (Identity identity : ids) {
                suggestions.put(identity, key);
                if (maxSuggestions <= 0 || --suggestionLeft != 0) continue;
                break block4;
            }
        }
        return suggestions;
    }

    public void setStorage(RelationshipStorage storage) {
        this.relationshipStorage = storage;
    }

    private static enum Origin {
        FROM,
        TO;

    }
}

