/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.streams;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.common.service.ProcessContext;
import org.exoplatform.social.common.service.impl.SocialServiceContextImpl;
import org.exoplatform.social.common.service.utils.ObjectHelper;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.api.ActivityStreamStorage;
import org.exoplatform.social.core.storage.streams.SocialChromatticAsyncProcessor;
import org.exoplatform.social.core.storage.streams.StreamProcessContext;

public class StreamProcessorFactory {
    private static ActivityStreamStorage getStreamStorage() {
        return (ActivityStreamStorage)PortalContainer.getInstance().getComponentInstanceOfType(ActivityStreamStorage.class);
    }

    private static ActivityStorage getActivityStorage() {
        return (ActivityStorage)PortalContainer.getInstance().getComponentInstanceOfType(ActivityStorage.class);
    }

    public static SocialChromatticAsyncProcessor saveStream() {
        return new SocialChromatticAsyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessorFactory.getStreamStorage().save(processContext);
                return processContext;
            }
        };
    }

    public static SocialChromatticAsyncProcessor savePoster() {
        return new SocialChromatticAsyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessorFactory.getStreamStorage().savePoster(processContext);
                return processContext;
            }
        };
    }

    public static SocialChromatticAsyncProcessor updateStream() {
        return new SocialChromatticAsyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessorFactory.getStreamStorage().update(processContext);
                return processContext;
            }
        };
    }

    public static SocialChromatticAsyncProcessor updateHidable() {
        return new SocialChromatticAsyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessorFactory.getStreamStorage().updateHidable(processContext);
                return processContext;
            }
        };
    }

    public static SocialChromatticAsyncProcessor updateCommenter() {
        return new SocialChromatticAsyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessorFactory.getStreamStorage().updateCommenter(processContext);
                return processContext;
            }
        };
    }

    public static SocialChromatticAsyncProcessor deleteCommentStream() {
        return new SocialChromatticAsyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessorFactory.getStreamStorage().deleteComment(processContext);
                return processContext;
            }
        };
    }

    public static SocialChromatticAsyncProcessor unlikeActivity() {
        return new SocialChromatticAsyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessContext ctx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)processContext));
                StreamProcessorFactory.getStreamStorage().unLike(ctx.getIdentity(), ctx.getActivity());
                return processContext;
            }
        };
    }

    public static SocialChromatticAsyncProcessor likeActivity() {
        return new SocialChromatticAsyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessContext ctx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)processContext));
                StreamProcessorFactory.getStreamStorage().like(ctx.getIdentity(), ctx.getActivity());
                return processContext;
            }
        };
    }

    public static SocialChromatticAsyncProcessor deleteConnectStream() {
        return new SocialChromatticAsyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessContext ctx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)processContext));
                StreamProcessorFactory.getStreamStorage().deleteConnect(ctx.getSender(), ctx.getReceiver());
                return processContext;
            }
        };
    }

    public static SocialChromatticAsyncProcessor connectStream() {
        return new SocialChromatticAsyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessContext ctx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)processContext));
                StreamProcessorFactory.getStreamStorage().connect(ctx.getSender(), ctx.getReceiver());
                return processContext;
            }
        };
    }

    public static SocialChromatticAsyncProcessor addSpaceMemberStream() {
        return new SocialChromatticAsyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessorFactory.getStreamStorage().addSpaceMember(processContext);
                return processContext;
            }
        };
    }

    public static SocialChromatticAsyncProcessor removeSpaceMemberStream() {
        return new SocialChromatticAsyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessorFactory.getStreamStorage().removeSpaceMember(processContext);
                return processContext;
            }
        };
    }

    public static SocialChromatticAsyncProcessor createFeedActivityRef() {
        return new SocialChromatticAsyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)processContext));
                StreamProcessorFactory.getStreamStorage().createFeedActivityRef(streamCtx.getIdentity(), streamCtx.getActivities());
                return processContext;
            }
        };
    }

    public static SocialChromatticAsyncProcessor createConnectionsActivityRef() {
        return new SocialChromatticAsyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)processContext));
                StreamProcessorFactory.getStreamStorage().createConnectionsActivityRef(streamCtx.getIdentity(), streamCtx.getActivities());
                return processContext;
            }
        };
    }

    public static SocialChromatticAsyncProcessor createMySpacesActivityRef() {
        return new SocialChromatticAsyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)processContext));
                StreamProcessorFactory.getStreamStorage().createMySpacesActivityRef(streamCtx.getIdentity(), streamCtx.getActivities());
                return processContext;
            }
        };
    }

    public static SocialChromatticAsyncProcessor createMyActivitiesActivityRef() {
        return new SocialChromatticAsyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)processContext));
                StreamProcessorFactory.getStreamStorage().createMyActivitiesActivityRef(streamCtx.getIdentity(), streamCtx.getActivities());
                return processContext;
            }
        };
    }

    public static SocialChromatticAsyncProcessor createSpaceActivityRef() {
        return new SocialChromatticAsyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)processContext));
                StreamProcessorFactory.getStreamStorage().createSpaceActivityRef(streamCtx.getIdentity(), streamCtx.getActivities());
                return processContext;
            }
        };
    }

    public static SocialChromatticAsyncProcessor loadFeed() {
        return new SocialChromatticAsyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)processContext));
                StreamProcessorFactory.getActivityStorage().getActivityFeed(streamCtx.getIdentity(), 0, 20);
                return processContext;
            }
        };
    }
}

