/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONArray;

public class RequireJS {
    Log log = ExoLogger.getLogger(RequireJS.class);
    Map<String, String> depends = new LinkedHashMap<String, String>();
    Set<String> noAlias = new LinkedHashSet<String>();
    StringBuilder scripts = new StringBuilder();

    public RequireJS require(String moduleId) {
        return this.require(moduleId, null);
    }

    public RequireJS require(String moduleId, String alias) {
        if (moduleId == null || moduleId.isEmpty()) {
            this.log.warn((Object)"The moduleId can not be NULL");
        } else if (alias != null && !alias.trim().isEmpty()) {
            if (this.depends.containsKey(alias = alias.trim())) {
                if (!this.depends.get(alias).equals(moduleId)) {
                    this.log.warn("There is already an alias named as {}", new Object[]{alias});
                }
            } else {
                this.depends.put(alias, moduleId);
            }
        } else {
            this.log.debug("Adding requirejs module {} without alias", new Object[]{moduleId});
            this.noAlias.add(moduleId);
        }
        return this;
    }

    public RequireJS addScripts(String scripts) {
        this.scripts.append(scripts);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.depends.size() > 0 || this.noAlias.size() > 0) {
            builder.append("window.require(");
            LinkedList<String> tmp = new LinkedList<String>(this.depends.values());
            this.noAlias.removeAll(this.depends.values());
            tmp.addAll(this.noAlias);
            builder.append(new JSONArray(tmp)).append(",");
            builder.append("function(").append(StringUtils.join(this.depends.keySet(), (String)",")).append(") {").append('\n').append((CharSequence)this.scripts).append("});");
        } else {
            builder.append((CharSequence)this.scripts);
        }
        return builder.toString();
    }
}

