/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.exoplatform.commons.api.notification.model.PluginInfo;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.container.PortalContainer;

public class UserSetting {
    private static UserSetting defaultSetting = null;
    private boolean isActive = true;
    private Calendar lastUpdateTime;
    private String userId;
    private List<String> instantlyProviders = new ArrayList<String>();
    private List<String> dailyProviders = new ArrayList<String>();
    private List<String> weeklyProviders = new ArrayList<String>();

    public UserSetting() {
        this.lastUpdateTime = Calendar.getInstance();
    }

    public static UserSetting getInstance() {
        return new UserSetting();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserSetting setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public Calendar getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public UserSetting setLastUpdateTime(Calendar lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        return this;
    }

    public List<String> getInstantlyProviders() {
        return this.instantlyProviders;
    }

    public void setInstantlyProviders(List<String> instantlyProviders) {
        this.instantlyProviders = instantlyProviders;
    }

    public List<String> getDailyProviders() {
        return this.dailyProviders;
    }

    public void setDailyProviders(List<String> dailyProviders) {
        this.dailyProviders = dailyProviders;
    }

    public List<String> getWeeklyProviders() {
        return this.weeklyProviders;
    }

    public void setWeeklyProviders(List<String> weeklyProviders) {
        this.weeklyProviders = weeklyProviders;
    }

    public void addProvider(String providerId, FREQUENCY frequencyType) {
        if (frequencyType.equals((Object)FREQUENCY.DAILY)) {
            this.addProperty(this.dailyProviders, providerId);
        } else if (frequencyType.equals((Object)FREQUENCY.WEEKLY)) {
            this.addProperty(this.weeklyProviders, providerId);
        } else if (frequencyType.equals((Object)FREQUENCY.INSTANTLY)) {
            this.addProperty(this.instantlyProviders, providerId);
        }
    }

    public boolean isInInstantly(String providerId) {
        return this.instantlyProviders.contains(providerId);
    }

    public boolean isInDaily(String providerId) {
        return this.dailyProviders.contains(providerId);
    }

    public boolean isInWeekly(String providerId) {
        return this.weeklyProviders.contains(providerId);
    }

    public boolean isActiveWithoutInstantly(String pluginId) {
        return this.isInDaily(pluginId) || this.isInWeekly(pluginId);
    }

    private void addProperty(List<String> providers, String providerId) {
        if (!providers.contains(providerId)) {
            providers.add(providerId);
        }
    }

    public UserSetting clone() {
        UserSetting setting = UserSetting.getInstance();
        setting.setActive(this.isActive);
        setting.setDailyProviders(this.dailyProviders);
        setting.setWeeklyProviders(this.weeklyProviders);
        setting.setInstantlyProviders(this.instantlyProviders);
        setting.setUserId(this.userId);
        return setting;
    }

    public static final UserSetting getDefaultInstance() {
        if (defaultSetting == null) {
            PluginSettingService settingService = (PluginSettingService)PortalContainer.getInstance().getComponentInstanceOfType(PluginSettingService.class);
            List<PluginInfo> providerDatas = settingService.getActivePlugins();
            if (providerDatas == null || providerDatas.size() == 0) {
                return new UserSetting();
            }
            defaultSetting = UserSetting.getInstance();
            defaultSetting.setActive(true);
            for (PluginInfo providerData : providerDatas) {
                for (String defaultConf : providerData.getDefaultConfig()) {
                    defaultSetting.addProvider(providerData.getType(), FREQUENCY.getFrequecy(defaultConf));
                }
            }
        }
        return defaultSetting.clone();
    }

    public static enum FREQUENCY {
        INSTANTLY,
        DAILY,
        WEEKLY;


        public static FREQUENCY getFrequecy(String name) {
            for (int i = 0; i < FREQUENCY.values().length; ++i) {
                if (!FREQUENCY.values()[i].name().equalsIgnoreCase(name)) continue;
                return FREQUENCY.values()[i];
            }
            return null;
        }
    }
}

