/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.plugin;

import java.util.Locale;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfile;

public class NotificationPluginUtils {
    public static final String DEFAULT_LANGUAGE = Locale.ENGLISH.getLanguage();
    private static OrganizationService organizationService;
    private static SettingService settingService;
    public static final String NOTIFICATION_SENDER_NAME = "exo:notificationSenderName";
    public static final String NOTIFICATION_SENDER_EMAIL = "exo:notificationSenderEmail";
    public static final String BRANDING_PORTAL_NAME = "exo:brandingPortalName";

    public static String getPortalName() {
        return NotificationPluginUtils.getExoContainerContext().getPortalContainerName();
    }

    public static String getDomain() {
        return System.getProperty("gatein.email.domain.url", "http://localhost:8080");
    }

    public static String getFirstName(String userName) {
        User user = null;
        try {
            UserHandler userHandler = NotificationPluginUtils.getOrganizationService().getUserHandler();
            user = userHandler.findUserByName(userName);
            return user.getFirstName();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ExoContainerContext getExoContainerContext() {
        return (ExoContainerContext)PortalContainer.getInstance().getComponentInstanceOfType(ExoContainerContext.class);
    }

    public static String getProfileUrl(String userId) {
        StringBuffer footerLink = new StringBuffer(NotificationPluginUtils.getDomain());
        return footerLink.append("/").append(NotificationPluginUtils.getExoContainerContext().getRestContextName()).append("/").append("social/notifications/redirectUrl/notification_settings").append("/").append(userId).toString();
    }

    public static String getFullName(String userId) {
        try {
            User user = NotificationPluginUtils.getOrganizationService().getUserHandler().findUserByName(userId);
            return NotificationPluginUtils.getFullName(user);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getFullName(User user) {
        StringBuilder userInfor = new StringBuilder();
        String displayName = user.getDisplayName();
        if (displayName == null || displayName.length() == 0) {
            userInfor.append(user.getFirstName()).append(" ").append(user.getLastName());
        } else {
            userInfor.append(displayName);
        }
        return userInfor.toString();
    }

    private static String getEmailFormat(String userId) {
        try {
            User user = NotificationPluginUtils.getOrganizationService().getUserHandler().findUserByName(userId);
            StringBuilder userInfor = new StringBuilder(NotificationPluginUtils.getFullName(user));
            userInfor.append("<").append(user.getEmail()).append(">");
            return userInfor.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getFrom(String from) {
        if (from != null && from.length() > 0 && from.indexOf("@") > 0) {
            return from;
        }
        return new StringBuffer(NotificationPluginUtils.getSenderName()).append("<").append(NotificationPluginUtils.getEmailFrom()).append(">").toString();
    }

    public static String getEmailFrom() {
        SettingValue<?> mail = NotificationPluginUtils.getSettingService().get(Context.GLOBAL, Scope.GLOBAL, NOTIFICATION_SENDER_EMAIL);
        return mail != null ? (String)mail.getValue() : System.getProperty("gatein.email.smtp.from", "noreply@exoplatform.com");
    }

    public static String getSenderName() {
        SettingValue<?> name = NotificationPluginUtils.getSettingService().get(Context.GLOBAL, Scope.GLOBAL, NOTIFICATION_SENDER_NAME);
        return name != null ? (String)name.getValue() : System.getProperty("exo.notifications.portalname", "eXo");
    }

    public static String getBrandingPortalName() {
        SettingValue<?> name = NotificationPluginUtils.getSettingService().get(Context.GLOBAL, Scope.GLOBAL, BRANDING_PORTAL_NAME);
        return name != null ? (String)name.getValue() : "eXo";
    }

    public static String getPortalHome(String portalName) {
        StringBuffer portalLink = new StringBuffer(NotificationPluginUtils.getDomain());
        portalLink.append("/").append(NotificationPluginUtils.getExoContainerContext().getRestContextName()).append("/").append("social/notifications/redirectUrl/portal_home").append("/").append(portalName);
        return "<a target=\"_blank\" style=\"text-decoration: none; font-weight: bold; color: #2F5E92; \" href=\"" + portalLink.toString() + "\">" + portalName + "</a>";
    }

    public static String getTo(String to) {
        if (to.indexOf("@") < 0) {
            return NotificationPluginUtils.getEmailFormat(to);
        }
        return to;
    }

    public static String getLanguage(String userId) {
        try {
            UserProfile profile = NotificationPluginUtils.getOrganizationService().getUserProfileHandler().findUserProfileByName(userId);
            String lang = profile.getAttribute(UserProfile.PERSONAL_INFO_KEYS[8]);
            return lang != null && lang.trim().length() > 0 ? lang : DEFAULT_LANGUAGE;
        }
        catch (Exception e) {
            return DEFAULT_LANGUAGE;
        }
    }

    public static OrganizationService getOrganizationService() {
        if (organizationService == null) {
            organizationService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
        }
        return organizationService;
    }

    public static SettingService getSettingService() {
        if (settingService == null) {
            settingService = (SettingService)PortalContainer.getInstance().getComponentInstanceOfType(SettingService.class);
        }
        return settingService;
    }
}

