/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.File;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.ext.backup.BackupChainLog;
import org.exoplatform.services.jcr.ext.backup.RepositoryRestoreExeption;
import org.exoplatform.services.jcr.ext.backup.impl.BackupManagerImpl;
import org.exoplatform.services.jcr.ext.backup.impl.JobRepositoryRestore;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.backup.JCRRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.DataRestoreContext;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanService;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanerTool;
import org.exoplatform.services.jcr.impl.clean.rdbms.DummyDBCleanerTool;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExistingRepositorySameConfigRestore
extends JobRepositoryRestore {
    public JobExistingRepositorySameConfigRestore(RepositoryService repoService, BackupManagerImpl backupManagerImpl, RepositoryEntry repositoryEntry, Map<String, File> workspacesMapping, File backupChainLogFile) {
        this(repoService, backupManagerImpl, repositoryEntry, workspacesMapping, backupChainLogFile, false);
    }

    public JobExistingRepositorySameConfigRestore(RepositoryService repoService, BackupManagerImpl backupManagerImpl, RepositoryEntry repositoryEntry, Map<String, File> workspacesMapping, File backupChainLogFile, boolean removeJobOnceOver) {
        super(repoService, backupManagerImpl, repositoryEntry, workspacesMapping, backupChainLogFile, removeJobOnceOver);
    }

    /*
     * Loose catch block
     */
    @Override
    protected void restoreRepository() throws RepositoryRestoreExeption {
        block33: {
            ArrayList<DataRestore> dataRestorer = new ArrayList<DataRestore>();
            ArrayList<WorkspaceContainerFacade> workspacesWaits4Resume = new ArrayList<WorkspaceContainerFacade>();
            WorkspaceEntry wsEntry = (WorkspaceEntry)this.repositoryEntry.getWorkspaceEntries().get(0);
            Connection jdbcConn = null;
            DBCleanerTool dbCleaner = null;
            JDBCDataContainerConfig.DatabaseStructureType dbType = DBInitializerHelper.getDatabaseType((WorkspaceEntry)wsEntry);
            if (dbType.isShareSameDatasource()) {
                String dsName = wsEntry.getContainer().getParameterValue("source-name");
                final DataSource ds = (DataSource)new InitialContext().lookup(dsName);
                if (ds == null) {
                    throw new NameNotFoundException("Data source " + dsName + " not found");
                }
                jdbcConn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

                    @Override
                    public Connection run() throws Exception {
                        return ds.getConnection();
                    }
                });
                jdbcConn.setAutoCommit(false);
                if (dbType == JDBCDataContainerConfig.DatabaseStructureType.SINGLE) {
                    dbCleaner = DBCleanService.getRepositoryDBCleaner((Connection)jdbcConn, (RepositoryEntry)this.repositoryEntry);
                }
            }
            ManageableRepository repository = this.repositoryService.getRepository(this.repositoryEntry.getName());
            for (String wsName : repository.getWorkspaceNames()) {
                LOG.info((Object)("Trying to suspend workspace '" + wsName + "'"));
                WorkspaceContainerFacade wsContainer = repository.getWorkspaceContainer(wsName);
                wsContainer.setState(3);
                workspacesWaits4Resume.add(wsContainer);
            }
            boolean isSharedDbCleaner = false;
            for (WorkspaceEntry wEntry : this.repositoryEntry.getWorkspaceEntries()) {
                DataRestoreContext context;
                List backupable = this.repositoryService.getRepository(this.repositoryEntry.getName()).getWorkspaceContainer(wEntry.getName()).getComponentInstancesOfType(Backupable.class);
                File fullBackupDir = JCRRestore.getFullBackupFile((File)new BackupChainLog((File)this.workspacesMapping.get(wEntry.getName())).getBackupConfig().getBackupDir());
                if (jdbcConn != null) {
                    if (dbType == JDBCDataContainerConfig.DatabaseStructureType.SINGLE) {
                        context = new DataRestoreContext(new String[]{"storage-dir", "db-connection", "db-cleaner"}, new Object[]{fullBackupDir, jdbcConn, isSharedDbCleaner ? new DummyDBCleanerTool() : dbCleaner});
                        isSharedDbCleaner = true;
                    } else {
                        context = new DataRestoreContext(new String[]{"storage-dir", "db-connection"}, new Object[]{fullBackupDir, jdbcConn});
                    }
                } else {
                    context = new DataRestoreContext(new String[]{"storage-dir"}, new Object[]{fullBackupDir});
                }
                for (Backupable component : backupable) {
                    dataRestorer.add(component.getDataRestorer(context));
                }
            }
            for (DataRestore restorer : dataRestorer) {
                restorer.clean();
            }
            for (DataRestore restorer : dataRestorer) {
                restorer.restore();
            }
            for (DataRestore restorer : dataRestorer) {
                restorer.commit();
            }
            for (WorkspaceContainerFacade wsContainer : workspacesWaits4Resume) {
                wsContainer.setState(1);
            }
            for (WorkspaceEntry wEntry : this.repositoryEntry.getWorkspaceEntries()) {
                LOG.info((Object)("Trying to restore an incremental backup for the workspace '" + wEntry.getName() + "'"));
                this.repositoryService.getRepository(this.repositoryEntry.getName()).getWorkspaceContainer(wEntry.getName()).getComponentInstancesOfType(Backupable.class);
                WorkspacePersistentDataManager dataManager = (WorkspacePersistentDataManager)this.repositoryService.getRepository(this.repositoryEntry.getName()).getWorkspaceContainer(wEntry.getName()).getComponent(WorkspacePersistentDataManager.class);
                File storageDir = JCRRestore.getFullBackupFile((File)new BackupChainLog((File)this.workspacesMapping.get(wEntry.getName())).getBackupConfig().getBackupDir());
                FileCleanerHolder cleanerHolder = (FileCleanerHolder)this.repositoryService.getRepository(this.repositoryEntry.getName()).getWorkspaceContainer(wEntry.getName()).getComponent(FileCleanerHolder.class);
                JCRRestore restorer = new JCRRestore((DataManager)dataManager, cleanerHolder.getFileCleaner());
                for (File incrBackupFile : JCRRestore.getIncrementalFiles((File)storageDir)) {
                    restorer.incrementalRestore(incrBackupFile);
                }
            }
            Object var18_29 = null;
            for (DataRestore restorer : dataRestorer) {
                try {
                    restorer.close();
                }
                catch (BackupException e) {
                    LOG.error((Object)"Can't close restorer", (Throwable)e);
                }
            }
            try {
                for (WorkspaceContainerFacade wsContainer : workspacesWaits4Resume) {
                    wsContainer.setState(1);
                }
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Can't resume repository", (Throwable)e);
                {
                    break block33;
                }
            }
            break block33;
            {
                catch (Throwable t) {
                    LOG.info((Object)"Trying to roll back the changes");
                    for (DataRestore restorer : dataRestorer) {
                        try {
                            restorer.rollback();
                        }
                        catch (BackupException e) {
                            LOG.error((Object)"Can't rollback changes", (Throwable)e);
                        }
                    }
                    throw new RepositoryRestoreExeption("Repository " + this.repositoryEntry.getName() + " was not restored", t);
                }
            }
            catch (Throwable throwable) {
                Object var18_30 = null;
                for (DataRestore restorer : dataRestorer) {
                    try {
                        restorer.close();
                    }
                    catch (BackupException e) {
                        LOG.error((Object)"Can't close restorer", (Throwable)e);
                    }
                }
                try {
                    for (WorkspaceContainerFacade wsContainer : workspacesWaits4Resume) {
                        wsContainer.setState(1);
                    }
                }
                catch (RepositoryException e) {
                    LOG.error((Object)"Can't resume repository", (Throwable)e);
                }
                throw throwable;
            }
        }
    }
}

