/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.embedder;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.embedder.AbstractEmbedder;
import org.exoplatform.commons.embedder.ExoMedia;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class OembedEmbedder
extends AbstractEmbedder {
    private static final Log LOG = ExoLogger.getLogger(OembedEmbedder.class);
    private static final String EMBED_TITLE = "title";
    private static final String EMBED_DESC = "description";
    private static final String EMBED_PROVIDER = "provider_name";
    private static final String EMBED_URL = "url";
    private static final String EMBED_HTML = "html";
    private static final String EMBED_TYPE = "type";

    public OembedEmbedder(InitParams initParams) {
        super(initParams);
    }

    public Pattern getOembedURLPattern() {
        return this.getPattern();
    }

    @Override
    public ExoMedia getExoMedia() {
        URL urlObj = this.getOembedUrl(this.url);
        if (urlObj == null) {
            return null;
        }
        JSONObject oembedData = this.getJSONObject(urlObj);
        if (oembedData == null) {
            return null;
        }
        return this.jsonToExoMedia(oembedData);
    }

    private URL getOembedUrl(String url) {
        try {
            for (Pattern pattern : this.schemeEndpointMap.keySet()) {
                Matcher matcher = pattern.matcher(url);
                if (!matcher.find()) continue;
                String endpoint = (String)this.schemeEndpointMap.get(pattern);
                return new URL(String.format(endpoint, url));
            }
        }
        catch (MalformedURLException e) {
            LOG.warn((Object)"Can't get oembed url for oembed request", (Throwable)e);
        }
        return null;
    }

    private ExoMedia jsonToExoMedia(JSONObject jsonObject) {
        ExoMedia mediaObject = new ExoMedia();
        try {
            mediaObject.setTitle(jsonObject.getString(EMBED_TITLE));
            mediaObject.setHtml(jsonObject.getString(EMBED_HTML));
            mediaObject.setType(jsonObject.getString(EMBED_TYPE));
            mediaObject.setProvider(jsonObject.getString(EMBED_PROVIDER));
            mediaObject.setDescription(jsonObject.has(EMBED_DESC) ? jsonObject.getString(EMBED_DESC) : "");
            mediaObject.setUrl(jsonObject.has(EMBED_URL) ? jsonObject.getString(EMBED_URL) : "");
            return mediaObject;
        }
        catch (JSONException e) {
            LOG.warn((Object)"Can't convert JSONObject to ExoMedia object", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Log getExoLogger() {
        return LOG;
    }
}

