/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.notification.impl.NotificationSessionManager;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

public abstract class AbstractService {
    public static final String STG_SCOPE = "stg:scope";
    public static final String STG_CONTEXT = "stg:context";
    public static final String STG_SUBCONTEXT = "stg:subcontext";
    public static final String STG_SIMPLE_CONTEXT = "stg:simplecontext";
    public static final String EXO_IS_ACTIVE = "exo:isActive";
    public static final String EXO_INSTANTLY = "exo:instantly";
    public static final String EXO_DAILY = "exo:daily";
    public static final String EXO_WEEKLY = "exo:weekly";
    public static final String NTF_FROM = "ntf:from";
    public static final String NTF_ORDER = "ntf:order";
    public static final String NTF_MESSAGE = "ntf:message";
    public static final String NTF_MESSAGE_INFO = "ntf:messageInfo";
    public static final String NTF_SEND_TO_DAILY = "ntf:sendToDaily";
    public static final String NTF_SEND_TO_WEEKLY = "ntf:sendToWeekly";
    public static final String NTF_MESSAGE_HOME = "ntf:messageHome";
    public static final String NTF_MESSAGE_INFO_HOME = "ntf:messageInfoHome";
    public static final String NTF_NOTIFICATION = "ntf:notification";
    public static final String NTF_PROVIDER_TYPE = "ntf:providerType";
    public static final String MIX_SUB_MESSAGE_HOME = "mix:subMessageHome";
    public static final String MIX_DEFAULT_SETTING = "mix:defaultSetting";
    public static final String NTF_OWNER_PARAMETER = "ntf:ownerParameter";
    public static final String EXO_LAST_MODIFIED_DATE = "exo:lastModifiedDate";
    public static final String JCR_ROOT = "/jcr:root";
    public static final String ASCENDING = " ASC";
    public static final String DESCENDING = " DESC";
    public static final String WORKSPACE_PARAM = "workspace";
    public static final String DEFAULT_WORKSPACE_NAME = "portal-system";
    public static final String NOTIFICATION_HOME_NODE = "eXoNotification";
    public static final String MESSAGE_HOME_NODE = "messageHome";
    public static final String MESSAGE_INFO_HOME_NODE = "messageInfoHome";
    public static final String SETTING_NODE = "settings";
    public static final String SETTING_USER_NODE = "user";
    public static final String SETTING_USER_PATH = "settings/user";
    public static final String NOTIFICATION_PARENT_PATH = "/";
    public static final String DAY = "d";
    public static final String HOUR = "h";

    protected static Node getNotificationHomeNode(SessionProvider sProvider, String workspace) throws Exception {
        Node notificationHome;
        Session session = AbstractService.getSession(sProvider, workspace);
        Node rootNode = session.getRootNode();
        if (rootNode.hasNode(NOTIFICATION_HOME_NODE)) {
            notificationHome = rootNode.getNode(NOTIFICATION_HOME_NODE);
        } else {
            notificationHome = rootNode.addNode(NOTIFICATION_HOME_NODE, NTF_NOTIFICATION);
            session.save();
        }
        return notificationHome;
    }

    protected Node getMessageInfoHomeNode(SessionProvider sProvider, String workspace) throws Exception {
        Node ntfHomeNode = AbstractService.getNotificationHomeNode(sProvider, workspace);
        if (!ntfHomeNode.hasNode(MESSAGE_INFO_HOME_NODE)) {
            Node messageHome = ntfHomeNode.addNode(MESSAGE_INFO_HOME_NODE, NTF_MESSAGE_INFO_HOME);
            AbstractService.sessionSave(ntfHomeNode);
            return messageHome;
        }
        return ntfHomeNode.getNode(MESSAGE_INFO_HOME_NODE);
    }

    protected Node getOrCreateMessageParent(SessionProvider sProvider, String workspace, String pluginId) throws Exception {
        Node providerNode = this.getMessageNodeByPluginId(sProvider, workspace, pluginId);
        String dayName = String.valueOf(Calendar.getInstance().get(5));
        Node dayNode = this.getOrCreateMessageNode(providerNode, DAY + dayName);
        return dayNode;
    }

    protected Node getMessageNodeByPluginId(SessionProvider sProvider, String workspace, String pluginId) throws Exception {
        Node root = AbstractService.getNotificationHomeNode(sProvider, workspace);
        Node messageHome = this.getOrCreateMessageNode(root, MESSAGE_HOME_NODE);
        return this.getOrCreateMessageNode(messageHome, pluginId);
    }

    private Node getOrCreateMessageNode(Node parent, String nodeName) throws Exception {
        if (!parent.hasNode(nodeName)) {
            Node messageHome = parent.addNode(nodeName, NTF_MESSAGE_HOME);
            messageHome.addMixin(MIX_SUB_MESSAGE_HOME);
            AbstractService.sessionSave(messageHome);
            return messageHome;
        }
        return parent.getNode(nodeName);
    }

    public static Session getSession(SessionProvider sProvider, String workspace) {
        if (workspace == null || workspace.length() == 0) {
            workspace = DEFAULT_WORKSPACE_NAME;
        }
        try {
            return sProvider.getSession(workspace, CommonsUtils.getRepository());
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            try {
                return NotificationSessionManager.createSystemProvider().getSession(workspace, CommonsUtils.getRepository());
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static String getCurrentTenantName() {
        try {
            return CommonsUtils.getRepository().getConfiguration().getName();
        }
        catch (Exception e) {
            return "defaultTenantName";
        }
    }

    protected static SessionProvider getSystemProvider() {
        return CommonsUtils.getSystemSessionProvider();
    }

    protected static void sessionSave(Node node) throws Exception {
        node.getSession().save();
    }
}

