/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationPlugin;
import org.exoplatform.commons.api.notification.service.QueueMessage;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.notification.service.storage.NotificationDataStorage;
import org.exoplatform.commons.api.notification.service.storage.NotificationService;
import org.exoplatform.commons.api.notification.service.template.DigestorService;
import org.exoplatform.commons.notification.NotificationContextFactory;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.AbstractService;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.impl.service.QueueMessageImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;

public class NotificationServiceImpl
extends AbstractService
implements NotificationService {
    private static final Log LOG = ExoLogger.getLogger(NotificationServiceImpl.class);
    private final NotificationDataStorage storage;

    public NotificationServiceImpl(NotificationDataStorage storage) {
        this.storage = storage;
    }

    public void process(NotificationInfo notification) throws Exception {
        String pluginId = notification.getKey().getId();
        if (NotificationContextFactory.getInstance().getStatisticsService().isStatisticsEnabled()) {
            NotificationContextFactory.getInstance().getStatisticsCollector().createNotificationInfoCount(pluginId);
        }
        if (!CommonsUtils.getService(PluginSettingService.class).isActive(pluginId)) {
            return;
        }
        UserSettingService notificationService = CommonsUtils.getService(UserSettingService.class);
        List userIds = notification.getSendToUserIds();
        if (notification.isSendAll()) {
            userIds = notificationService.getUserSettingByPlugin(pluginId);
        }
        ArrayList<String> userIdPendings = new ArrayList<String>();
        for (String userId : userIds) {
            UserSetting userSetting = notificationService.get(userId);
            if (!userSetting.isActive()) continue;
            if (userSetting.isInInstantly(pluginId)) {
                this.sendInstantly(notification.clone().setTo(userId));
            }
            if (!userSetting.isActiveWithoutInstantly(pluginId)) continue;
            userIdPendings.add(userId);
            this.setValueSendbyFrequency(notification, userSetting, userId);
        }
        if (userIdPendings.size() > 0 || notification.isSendAll()) {
            notification.to(userIdPendings);
            this.storage.save(notification);
        }
    }

    private void sendInstantly(NotificationInfo notification) {
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        NotificationContext nCtx = NotificationContextImpl.cloneInstance();
        AbstractNotificationPlugin plugin = nCtx.getPluginContainer().getPlugin(notification.getKey());
        if (plugin != null) {
            nCtx.setNotificationInfo(notification);
            MessageInfo info = plugin.buildMessage(nCtx);
            if (info != null) {
                if (NotificationUtils.isValidEmailAddresses(info.getTo())) {
                    CommonsUtils.getService(QueueMessageImpl.class).sendMessage(info.makeEmailNotification());
                } else {
                    LOG.warn((Object)String.format("The email %s is not valid for sending notification", info.getTo()));
                }
                if (stats) {
                    NotificationContextFactory.getInstance().getStatisticsCollector().createMessageInfoCount(info.getPluginId());
                }
            }
        }
    }

    public void process(Collection<NotificationInfo> messages) throws Exception {
        for (NotificationInfo message : messages) {
            this.process(message);
        }
    }

    private void setValueSendbyFrequency(NotificationInfo message, UserSetting userNotificationSetting, String userId) {
        if (message.isSendAll()) {
            return;
        }
        String pluginId = message.getKey().getId();
        if (userNotificationSetting.isInDaily(pluginId)) {
            message.setSendToDaily(userId);
        }
        if (userNotificationSetting.isInWeekly(pluginId)) {
            message.setSendToWeekly(userId);
        }
    }

    public void processDigest() throws Exception {
        List usersDefaultSettings;
        List userSettings;
        UserSettingService userService = CommonsUtils.getService(UserSettingService.class);
        DigestorService digest = CommonsUtils.getService(DigestorService.class);
        MailService mailService = CommonsUtils.getService(MailService.class);
        PluginSettingService settingService = CommonsUtils.getService(PluginSettingService.class);
        UserSetting defaultSetting = this.getDefaultUserSetting(settingService.getActivePluginIds());
        long startTime = System.currentTimeMillis();
        int limit = 100;
        int offset = 0;
        while ((userSettings = userService.getDaily(offset, limit)).size() != 0) {
            this.send(digest, mailService, userSettings, null);
            offset += limit;
        }
        LOG.debug((Object)("Time to run process users have settings: " + (System.currentTimeMillis() - startTime) + "ms."));
        startTime = System.currentTimeMillis();
        offset = 0;
        while ((usersDefaultSettings = userService.getDefaultDaily(offset, limit)).size() != 0) {
            this.send(digest, mailService, usersDefaultSettings, defaultSetting);
            offset += limit;
        }
        this.storage.removeMessageAfterSent();
        LOG.debug((Object)("Time to run process users used default settings: " + (System.currentTimeMillis() - startTime) + "ms."));
    }

    private void send(DigestorService digest, MailService mail, List<UserSetting> userSettings, UserSetting defaultSetting) throws Exception {
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        for (UserSetting userSetting : userSettings) {
            MessageInfo messageInfo;
            Map notificationMessageMap;
            if (defaultSetting != null) {
                userSetting = defaultSetting.clone().setUserId(userSetting.getUserId()).setLastUpdateTime(userSetting.getLastUpdateTime());
            }
            if ((notificationMessageMap = this.storage.getByUser(userSetting)).size() <= 0 || (messageInfo = digest.buildMessage(notificationMessageMap, userSetting)) == null) continue;
            CommonsUtils.getService(QueueMessage.class).put(messageInfo);
            if (!stats) continue;
            NotificationContextFactory.getInstance().getStatisticsCollector().createMessageInfoCount(messageInfo.getPluginId());
            NotificationContextFactory.getInstance().getStatisticsCollector().putQueue(messageInfo.getPluginId());
        }
    }

    private UserSetting getDefaultUserSetting(List<String> activesProvider) {
        UserSetting setting = UserSetting.getInstance();
        UserSetting defaultSetting = UserSetting.getDefaultInstance();
        for (String string : activesProvider) {
            if (defaultSetting.isInWeekly(string)) {
                setting.addProvider(string, UserSetting.FREQUENCY.WEEKLY);
                continue;
            }
            if (!defaultSetting.isInDaily(string)) continue;
            setting.addProvider(string, UserSetting.FREQUENCY.DAILY);
        }
        return setting;
    }
}

