/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service;

import org.exoplatform.commons.notification.impl.service.QueueMessageImpl;
import org.exoplatform.management.ManagementAware;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;

@Managed
@ManagedDescription(value="Mock mail service")
@NameTemplate(value={@Property(key="service", value="notification"), @Property(key="view", value="mockmail")})
public class SendEmailService
implements ManagementAware {
    private boolean isOn = false;
    private long sentCounter = 0L;
    private long currentCapacity = 0L;
    private int emailPerSend = 0;
    private int interval = 0;
    private ManagementContext context;
    private QueueMessageImpl queueMessage;

    public SendEmailService(QueueMessageImpl queueMessage) {
        this.queueMessage = queueMessage;
        this.queueMessage.setManagementView(this);
    }

    public void registerManager(Object o) {
        if (this.context != null) {
            this.context.register(o);
        }
    }

    public void setContext(ManagementContext context) {
        this.context = context;
    }

    public void counter() {
        ++this.sentCounter;
    }

    public void addCurrentCapacity() {
        ++this.currentCapacity;
    }

    public void removeCurrentCapacity() {
        if (this.currentCapacity > 0L) {
            --this.currentCapacity;
        }
    }

    @Managed
    @ManagedDescription(value="Current mail service capacity should be available.")
    @Impact(value=ImpactType.READ)
    public long getCurrentCapacity() {
        return this.currentCapacity;
    }

    @Managed
    @ManagedDescription(value="Turn on the mail service.")
    @Impact(value=ImpactType.READ)
    public void on() {
        this.resetCounter();
        this.isOn = true;
        this.emailPerSend = 120;
        this.interval = 120;
        this.makeJob();
    }

    @Managed
    @ManagedDescription(value="Status of mail service. (true/false)")
    @Impact(value=ImpactType.READ)
    public boolean isOn() {
        return this.isOn;
    }

    @Managed
    @ManagedDescription(value="Turn off the mail service.")
    @Impact(value=ImpactType.READ)
    public void off() {
        this.resetCounter();
        this.queueMessage.resetDefaultConfigJob();
        this.isOn = false;
    }

    @Managed
    @ManagedDescription(value="Number emails sent")
    @Impact(value=ImpactType.READ)
    public long getSentCounter() {
        return this.sentCounter;
    }

    @Managed
    @ManagedDescription(value="Reset email countet.")
    @Impact(value=ImpactType.READ)
    public void resetCounter() {
        this.sentCounter = 0L;
    }

    @Managed
    @ManagedDescription(value="Set number emails send per one time.")
    @Impact(value=ImpactType.READ)
    public void setNumberEmailPerSend(int emailPerSend) {
        this.emailPerSend = emailPerSend;
        this.makeJob();
    }

    @Managed
    @ManagedDescription(value="Number emails send per one time.")
    @Impact(value=ImpactType.READ)
    public int getNumberEmailPerSend() {
        return this.emailPerSend;
    }

    @Managed
    @ManagedDescription(value="Set period of time (in seconds) for each sending notification execution.")
    @Impact(value=ImpactType.READ)
    public void setInterval(int interval) {
        this.interval = interval;
        this.makeJob();
    }

    @Managed
    @ManagedDescription(value="Period of time (in seconds) between each sending notification execution.")
    @Impact(value=ImpactType.READ)
    public int getInterval() {
        return this.interval;
    }

    @Managed
    @ManagedDescription(value="Removes all notification data that stored in database.")
    @Impact(value=ImpactType.READ)
    public String resetTestMail() {
        this.currentCapacity = 0L;
        this.resetCounter();
        this.isOn = true;
        this.emailPerSend = 120;
        this.interval = 120;
        return this.queueMessage.removeAll();
    }

    private void makeJob() {
        if (this.isOn) {
            this.queueMessage.makeJob(this.emailPerSend, this.interval * 1000);
        }
    }
}

