/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service.storage;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.NotificationKey;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.storage.NotificationDataStorage;
import org.exoplatform.commons.notification.NotificationConfiguration;
import org.exoplatform.commons.notification.NotificationContextFactory;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.AbstractService;
import org.exoplatform.commons.notification.impl.NotificationSessionManager;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NotificationDataStorageImpl
extends AbstractService
implements NotificationDataStorage {
    private static final Log LOG = ExoLogger.getLogger(NotificationDataStorageImpl.class);
    public static final String REMOVE_ALL = "removeAll";
    private String workspace;
    private NotificationConfiguration configuration = null;
    private final ReentrantLock lock = new ReentrantLock();
    private Map<String, Set<String>> removeByCallBack = new ConcurrentHashMap<String, Set<String>>();

    public NotificationDataStorageImpl(NotificationConfiguration configuration) {
        this.workspace = configuration.getWorkspace();
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(NotificationInfo message) throws Exception {
        SessionProvider sProvider = CommonsUtils.getSystemSessionProvider();
        ReentrantLock localLock = this.lock;
        try {
            localLock.lock();
            Node messageHomeNode = this.getOrCreateMessageParent(sProvider, this.workspace, message.getKey().getId());
            Node messageNode = messageHomeNode.addNode(message.getId(), "ntf:message");
            messageNode.setProperty("ntf:from", message.getFrom());
            messageNode.setProperty("ntf:order", (long)message.getOrder());
            messageNode.setProperty("ntf:providerType", message.getKey().getId());
            messageNode.setProperty("ntf:ownerParameter", message.getArrayOwnerParameter());
            messageNode.setProperty("ntf:sendToDaily", message.getSendToDaily());
            messageNode.setProperty("ntf:sendToWeekly", message.getSendToWeekly());
            messageHomeNode.getSession().save();
            if (NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled()) {
                NotificationContextFactory.getInstance().getStatisticsCollector().insertEntity("ntf:message");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to save the NotificationMessage", (Throwable)e);
        }
        finally {
            localLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<NotificationKey, List<NotificationInfo>> getByUser(UserSetting setting) {
        SessionProvider sProvider = NotificationSessionManager.createSystemProvider();
        LinkedHashMap<NotificationKey, List<NotificationInfo>> notificationData = new LinkedHashMap<NotificationKey, List<NotificationInfo>>();
        try {
            if (!this.configuration.isSendWeekly()) {
                for (String pluginId : setting.getDailyProviders()) {
                    NotificationDataStorageImpl.putMap(notificationData, NotificationKey.key((String)pluginId), this.getNotificationMessages(sProvider, pluginId, "ntf:sendToDaily", setting.getUserId()));
                }
            } else {
                for (String pluginId : setting.getWeeklyProviders()) {
                    NotificationDataStorageImpl.putMap(notificationData, NotificationKey.key((String)pluginId), this.getNotificationMessages(sProvider, pluginId, "ntf:sendToWeekly", setting.getUserId()));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to get the NotificationMessage by user: " + setting.getUserId()), (Throwable)e);
        }
        return notificationData;
    }

    private static void putMap(Map<NotificationKey, List<NotificationInfo>> notificationData, NotificationKey key, List<NotificationInfo> values) {
        if (notificationData.containsKey(key)) {
            List<NotificationInfo> messages = notificationData.get(key);
            for (NotificationInfo notificationMessage : values) {
                if (messages.size() != 0 && messages.contains(notificationMessage)) continue;
                messages.add(notificationMessage);
            }
            if (messages.size() > 0) {
                notificationData.put(key, messages);
            }
        } else if (values.size() > 0) {
            notificationData.put(key, values);
        }
    }

    private Node getParentNodeByPlugin(SessionProvider sProvider, String property, String pluginId) throws Exception {
        if ("ntf:sendToDaily".equals(property)) {
            return this.getOrCreateMessageParent(sProvider, this.workspace, pluginId).getParent();
        }
        return this.getMessageNodeByPluginId(sProvider, this.workspace, pluginId);
    }

    private List<NotificationInfo> getNotificationMessages(SessionProvider sProvider, String pluginId, String property, String userId) throws Exception {
        ArrayList<NotificationInfo> messages = new ArrayList<NotificationInfo>();
        Node messageHomeNode = this.getParentNodeByPlugin(sProvider, property, pluginId);
        NodeIterator iter = this.getNotificationNodeMessages(messageHomeNode, property, userId);
        Session session = messageHomeNode.getSession();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            NotificationInfo model = this.fillModel(node);
            messages.add(model.setTo(userId));
            this.processRemove(session, model, property, node.getPath());
        }
        return messages;
    }

    private NodeIterator getNotificationNodeMessages(Node messageHomeNode, String property, String userId) throws Exception {
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        long startTime = 0L;
        if (stats) {
            startTime = System.currentTimeMillis();
        }
        StringBuilder strQuery = new StringBuilder("SELECT * FROM ").append("ntf:message").append(" WHERE ");
        if ("ntf:sendToDaily".equals(property)) {
            String dayName = String.valueOf(Calendar.getInstance().get(5));
            strQuery.append(" (jcr:path LIKE '").append(messageHomeNode.getPath()).append("/").append("d").append(dayName).append("/%'").append(" AND NOT jcr:path LIKE '").append(messageHomeNode.getPath()).append("/").append("d").append(dayName).append("/%/%')");
        } else {
            strQuery.append(" jcr:path LIKE '").append(messageHomeNode.getPath()).append("/%'");
        }
        strQuery.append(" AND (").append(property).append("='").append(userId).append("'");
        if (!"&forAllUser".equals(userId)) {
            strQuery.append(" OR ").append(property).append("='").append("&forAllUser").append("') AND ").append("ntf:from").append("<>'").append(userId).append("'");
            strQuery.append(" order by ").append("ntf:order").append(" ASC").append(", exo:dateCreated").append(" DESC");
        } else {
            strQuery.append(")");
        }
        QueryManager qm = messageHomeNode.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery(strQuery.toString(), "sql");
        NodeIterator it = query.execute().getNodes();
        if (stats) {
            NotificationContextFactory.getInstance().getStatisticsCollector().queryExecuted(strQuery.toString(), it.getSize(), System.currentTimeMillis() - startTime);
        }
        return it;
    }

    private NotificationInfo fillModel(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        NotificationInfo message = NotificationInfo.instance().setFrom(node.getProperty("ntf:from").getString()).setOrder(Integer.valueOf(node.getProperty("ntf:order").getString()).intValue()).key(node.getProperty("ntf:providerType").getString()).setOwnerParameter(node.getProperty("ntf:ownerParameter").getValues()).setSendToDaily(NotificationUtils.valuesToArray(node.getProperty("ntf:sendToDaily").getValues())).setSendToWeekly(NotificationUtils.valuesToArray(node.getProperty("ntf:sendToWeekly").getValues())).setId(node.getName());
        return message;
    }

    private Set<String> addValue(String property, String value) {
        Set<String> set = this.removeByCallBack.get(property);
        if (set == null) {
            set = new HashSet<String>();
        }
        set.add(value);
        return set;
    }

    private void processRemove(Session session, NotificationInfo message, String property, String path) throws Exception {
        boolean isRemove = false;
        if (message.isSendAll() && !(isRemove = property.equals("ntf:sendToWeekly"))) {
            this.removeByCallBack.put(property, this.addValue(property, path));
        }
        if (!isRemove && property.equals("ntf:sendToDaily") && message.getSendToDaily().length == 1) {
            boolean bl = isRemove = message.getSendToWeekly().length == 0;
        }
        if (!isRemove && property.equals("ntf:sendToWeekly") && message.getSendToWeekly().length == 1) {
            boolean bl = isRemove = message.getSendToDaily().length == 0;
        }
        if (isRemove) {
            this.removeByCallBack.put(REMOVE_ALL, this.addValue(REMOVE_ALL, path));
        } else {
            this.removeProperty(session, path, property, message.getTo());
        }
    }

    private void removeProperty(Session session, String path, String property, String value) {
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        try {
            Node node = (Node)session.getItem(path);
            List<String> values = NotificationUtils.valuesToList(node.getProperty(property).getValues());
            if (values.contains(value)) {
                values.remove(value);
                if (values.isEmpty()) {
                    values.add("");
                }
                node.setProperty(property, values.toArray(new String[values.size()]));
                node.save();
                if (stats) {
                    NotificationContextFactory.getInstance().getStatisticsCollector().updateEntity("ntf:message");
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)String.format("Failed to remove property %s of value %s on node ", property, value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageAfterSent() throws Exception {
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        SessionProvider sProvider = NotificationSessionManager.createSystemProvider();
        try {
            Node notificationHome = NotificationDataStorageImpl.getNotificationHomeNode(sProvider, this.workspace);
            Session session = notificationHome.getSession();
            Set<String> listPaths = this.removeByCallBack.get(REMOVE_ALL);
            this.removeByCallBack.remove(REMOVE_ALL);
            if (listPaths != null && listPaths.size() > 0) {
                for (String nodePath : listPaths) {
                    try {
                        session.getItem(nodePath).remove();
                        if (stats) {
                            NotificationContextFactory.getInstance().getStatisticsCollector().deleteEntity("ntf:message");
                        }
                        LOG.debug((Object)("Remove NotificationMessage " + nodePath));
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Failed to remove node of NotificationMessage " + nodePath + "\n" + e.getMessage()));
                    }
                }
                session.save();
            }
            listPaths = this.removeByCallBack.get("ntf:sendToDaily");
            this.removeByCallBack.remove("ntf:sendToDaily");
            if (listPaths != null && listPaths.size() > 0) {
                for (String nodePath : listPaths) {
                    this.removeProperty(session, nodePath, "ntf:sendToDaily", "&forAllUser");
                }
            }
            if (this.configuration.isSendWeekly()) {
                Node messageHomeNode = notificationHome.getNode("messageHome");
                NodeIterator iterator = this.getNotificationNodeMessages(messageHomeNode, "ntf:sendToWeekly", "&forAllUser");
                while (iterator.hasNext()) {
                    Node node = iterator.nextNode();
                    String nodePath = node.getPath();
                    node.remove();
                    if (stats) {
                        NotificationContextFactory.getInstance().getStatisticsCollector().deleteEntity("ntf:message");
                    }
                    LOG.debug((Object)("Remove NotificationMessage " + nodePath));
                }
                session.save();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to remove message after sent email notification", (Throwable)e);
        }
    }
}

