/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.setting;

import groovy.text.GStringTemplateEngine;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.exoplatform.commons.api.notification.model.NotificationKey;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationPlugin;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.setting.PluginContainer;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.notification.template.ResourceBundleConfigDeployer;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.WebAppListener;
import org.picocontainer.Startable;

public class NotificationPluginContainer
implements PluginContainer,
Startable {
    private static final Log LOG = ExoLogger.getLogger(NotificationPluginContainer.class);
    private final Map<NotificationKey, AbstractNotificationPlugin> pluginMap = new HashMap<NotificationKey, AbstractNotificationPlugin>();
    private PluginSettingService pSettingService = CommonsUtils.getService(PluginSettingService.class);
    private ResourceBundleConfigDeployer deployer = new ResourceBundleConfigDeployer();
    private GStringTemplateEngine gTemplateEngine = new GStringTemplateEngine();

    public void start() {
        HashSet<String> datas = new HashSet<String>();
        for (AbstractNotificationPlugin plugin : this.pluginMap.values()) {
            for (PluginConfig pluginConfig : plugin.getPluginConfigs()) {
                this.pSettingService.registerPluginConfig(pluginConfig);
                datas.add(pluginConfig.getTemplateConfig().getBundlePath());
            }
        }
        if (ServletContainerFactory.getServletContainer().addWebAppListener((WebAppListener)this.deployer)) {
            this.deployer.initBundlePath(datas);
        }
    }

    public void stop() {
        ServletContainerFactory.getServletContainer().removeWebAppListener((WebAppListener)this.deployer);
    }

    public AbstractNotificationPlugin getPlugin(NotificationKey key) {
        return this.pluginMap.get(key);
    }

    public void add(AbstractNotificationPlugin plugin) {
        this.registerPlugin(plugin);
    }

    private void registerPlugin(AbstractNotificationPlugin plugin) {
        try {
            String templatePath = ((PluginConfig)plugin.getPluginConfigs().get(0)).getTemplateConfig().getTemplatePath();
            String template = TemplateUtils.loadGroovyTemplate(templatePath);
            plugin.setTemplateEngine(this.gTemplateEngine.createTemplate(template));
        }
        catch (Exception e) {
            LOG.debug((Object)("Failed to register notification plugin " + plugin.getId()));
        }
        this.pluginMap.put(plugin.getKey(), plugin);
    }

    public boolean remove(NotificationKey key) {
        this.pluginMap.remove(key);
        return true;
    }
}

