/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.setting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.NotificationCompletionService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.notification.NotificationConfiguration;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.AbstractService;
import org.exoplatform.commons.notification.impl.NotificationSessionManager;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.UserImpl;
import org.picocontainer.Startable;

public class UserSettingServiceImpl
extends AbstractService
implements UserSettingService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(UserSettingServiceImpl.class);
    private static final Scope NOTIFICATION_SCOPE = Scope.GLOBAL;
    private SettingService settingService;
    private String workspace;
    private NotificationConfiguration configuration;
    private NotificationCompletionService completeService;
    protected static final int MAX_LIMIT = 30;

    public UserSettingServiceImpl(SettingService settingService, NotificationConfiguration configuration) {
        this.settingService = settingService;
        this.configuration = configuration;
        this.workspace = configuration.getWorkspace();
        this.completeService = CommonsUtils.getService(NotificationCompletionService.class);
    }

    private Node getUserSettingHome(Session session) throws Exception {
        Node settingNode = session.getRootNode().getNode("settings");
        Node userHomeNode = null;
        if (!settingNode.hasNode("user")) {
            userHomeNode = settingNode.addNode("user", "stg:subcontext");
            session.save();
        } else {
            userHomeNode = settingNode.getNode("user");
        }
        return userHomeNode;
    }

    public void start() {
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                try {
                    SessionProvider sProvider = NotificationSessionManager.createSystemProvider();
                    if (this.hasUserToUpgrade(sProvider)) {
                        UserSettingServiceImpl.this.processUpgrade();
                    }
                }
                catch (Exception e) {
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    NotificationSessionManager.closeSessionProvider();
                }
                return true;
            }

            private boolean hasUserToUpgrade(SessionProvider sProvider) {
                try {
                    Session session = AbstractService.getSession(sProvider, UserSettingServiceImpl.this.workspace);
                    return !session.getRootNode().getNode("settings/user").getNodes().hasNext();
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot get node of users.", (Throwable)e);
                    return false;
                }
            }
        };
        this.completeService.addTask((Callable)callable);
    }

    public void stop() {
    }

    private void processUpgrade() {
        OrganizationService organizationService = CommonsUtils.getService(OrganizationService.class);
        try {
            ListAccess list = organizationService.getUserHandler().findAllUsers();
            int size = list.getSize();
            SessionProvider sProvider = NotificationSessionManager.getOrCreateSessionProvider();
            for (int offset = 0; offset < size; offset += 30) {
                this.addMixin(sProvider, (User[])list.load(offset, 30));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Upgrade old users to use notification default setting failed", (Throwable)e);
        }
    }

    public void save(UserSetting model) {
        String userId = model.getUserId();
        String instantlys = NotificationUtils.listToString(model.getInstantlyProviders());
        String dailys = NotificationUtils.listToString(model.getDailyProviders());
        String weeklys = NotificationUtils.listToString(model.getWeeklyProviders());
        this.saveUserSetting(userId, "exo:isActive", String.valueOf(model.isActive()));
        this.saveUserSetting(userId, "exo:instantly", instantlys);
        this.saveUserSetting(userId, "exo:daily", dailys);
        this.saveUserSetting(userId, "exo:weekly", weeklys);
        this.removeMixin(userId);
    }

    private void saveUserSetting(String userId, String key, String value) {
        this.settingService.set(Context.USER.id(userId), NOTIFICATION_SCOPE, key, SettingValue.create((String)value));
    }

    public UserSetting get(String userId) {
        UserSetting model = UserSetting.getInstance();
        List<String> instantlys = this.getArrayListValue(userId, "exo:instantly", null);
        if (instantlys != null) {
            model.setUserId(userId);
            model.setActive(this.isActive(userId));
            model.setInstantlyProviders(instantlys);
            model.setDailyProviders(this.getArrayListValue(userId, "exo:daily", Collections.<String>emptyList()));
            model.setWeeklyProviders(this.getArrayListValue(userId, "exo:weekly", Collections.<String>emptyList()));
        } else {
            model = UserSetting.getDefaultInstance().setUserId(userId);
            this.addMixin(userId);
        }
        return model;
    }

    private SettingValue<String> getSettingValue(String userId, String propertyName) {
        return this.settingService.get(Context.USER.id(userId), NOTIFICATION_SCOPE, propertyName);
    }

    private List<String> getArrayListValue(String userId, String propertyName, List<String> defaultValue) {
        SettingValue<String> values = this.getSettingValue(userId, propertyName);
        if (values != null) {
            String strs = (String)values.getValue();
            return Arrays.asList(strs.split(","));
        }
        return defaultValue;
    }

    private boolean isActive(String userId) {
        SettingValue<String> values = this.getSettingValue(userId, "exo:isActive");
        if (values != null) {
            return Boolean.valueOf((String)values.getValue());
        }
        return false;
    }

    public void addMixin(String userId) {
        this.addMixin(new User[]{new UserImpl(userId)});
    }

    public void addMixin(User[] users) {
        SessionProvider sProvider = UserSettingServiceImpl.getSystemProvider();
        try {
            this.addMixin(sProvider, users);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to add mixin for default setting of users", (Throwable)e);
        }
    }

    private void addMixin(SessionProvider sProvider, User[] users) {
        try {
            Session session = UserSettingServiceImpl.getSession(sProvider, this.workspace);
            Node userHomeNode = this.getUserSettingHome(session);
            for (int i = 0; i < users.length; ++i) {
                Node userNode;
                User user = users[i];
                if (user == null || user.getUserName() == null || !(userNode = userHomeNode.hasNode(user.getUserName()) ? userHomeNode.getNode(user.getUserName()) : userHomeNode.addNode(user.getUserName(), "stg:simplecontext")).canAddMixin("mix:defaultSetting")) continue;
                userNode.addMixin("mix:defaultSetting");
            }
            session.save();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to upgrade user notification setting", (Throwable)e);
        }
    }

    private void removeMixin(String userId) {
        SessionProvider sProvider = UserSettingServiceImpl.getSystemProvider();
        try {
            Node userNode;
            Session session = UserSettingServiceImpl.getSession(sProvider, this.workspace);
            Node userHomeNode = session.getRootNode().getNode("settings/user");
            if (userHomeNode.hasNode(userId) && (userNode = userHomeNode.getNode(userId)).isNodeType("mix:defaultSetting")) {
                userNode.removeMixin("mix:defaultSetting");
                UserSettingServiceImpl.sessionSave(userNode);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to remove mixin for default setting of user: " + userId), (Throwable)e);
        }
    }

    private StringBuilder buildQuery() {
        StringBuilder queryBuffer = new StringBuilder();
        queryBuffer.append("exo:isActive").append("='true' AND (").append("exo:daily").append("<>''");
        if (this.configuration.isSendWeekly()) {
            queryBuffer.append(" OR ").append("exo:weekly").append("<>''");
        }
        queryBuffer.append(")");
        return queryBuffer;
    }

    private StringBuilder buildQuery(String pluginId) {
        if (pluginId == null) {
            return this.buildQuery();
        }
        StringBuilder queryBuffer = new StringBuilder();
        queryBuffer.append("exo:isActive").append("='true' AND (").append("exo:instantly").append("='").append(pluginId).append("'").append(" OR ").append("exo:instantly").append(" LIKE '%,").append(pluginId).append(",%'").append(" OR ").append("exo:instantly").append(" LIKE '%,").append(pluginId).append("'").append(" OR ").append("exo:instantly").append(" LIKE '").append(pluginId).append(",%'").append(")");
        return queryBuffer;
    }

    public List<String> getUserSettingByPlugin(String pluginId) {
        SessionProvider sProvider = UserSettingServiceImpl.getSystemProvider();
        ArrayList<String> userIds = new ArrayList<String>();
        try {
            NodeIterator iter = this.getDailyIterator(sProvider, 0, 0, pluginId);
            while (iter != null && iter.hasNext()) {
                Node node = iter.nextNode();
                userIds.add(node.getParent().getName());
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to get all users have the " + pluginId + " in settings"), (Throwable)e);
        }
        return userIds;
    }

    private NodeIterator getDailyIterator(SessionProvider sProvider, int offset, int limit, String pluginId) throws Exception {
        Session session = UserSettingServiceImpl.getSession(sProvider, this.workspace);
        if (!session.getRootNode().hasNode("settings/user")) {
            return null;
        }
        StringBuilder strQuery = new StringBuilder("SELECT * FROM ").append("stg:scope");
        strQuery.append(" WHERE ").append((CharSequence)this.buildQuery(pluginId));
        QueryManager qm = session.getWorkspace().getQueryManager();
        QueryImpl query = (QueryImpl)qm.createQuery(strQuery.toString(), "sql");
        if (limit > 0) {
            query.setLimit((long)limit);
            query.setOffset((long)offset);
        }
        return query.execute().getNodes();
    }

    public List<UserSetting> getDaily(int offset, int limit) {
        SessionProvider sProvider = NotificationSessionManager.createSystemProvider();
        ArrayList<UserSetting> models = new ArrayList<UserSetting>();
        try {
            NodeIterator iter = this.getDailyIterator(sProvider, offset, limit, null);
            while (iter != null && iter.hasNext()) {
                Node node = iter.nextNode();
                models.add(this.fillModel(node));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to get all daily users have notification messages", (Throwable)e);
        }
        return models;
    }

    private List<String> getValues(Node node, String propertyName) throws Exception {
        String values = node.getProperty(propertyName).getString();
        if (values.trim().length() == 0) {
            return new ArrayList<String>();
        }
        return Arrays.asList(values.split(","));
    }

    private UserSetting fillModel(Node node) throws Exception {
        UserSetting model = UserSetting.getInstance();
        model.setDailyProviders(this.getValues(node, "exo:daily"));
        model.setWeeklyProviders(this.getValues(node, "exo:weekly"));
        model.setUserId(node.getParent().getName());
        model.setLastUpdateTime(node.getParent().getProperty("exo:lastModifiedDate").getDate());
        return model;
    }

    public long getNumberOfDaily() {
        SessionProvider sProvider = NotificationSessionManager.createSystemProvider();
        try {
            NodeIterator iter = this.getDailyIterator(sProvider, 0, 0, null);
            return iter == null ? 0L : iter.getSize();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private NodeIterator getDefaultDailyIterator(SessionProvider sProvider, int offset, int limit) throws Exception {
        Session session = UserSettingServiceImpl.getSession(sProvider, this.workspace);
        StringBuilder strQuery = new StringBuilder("SELECT * FROM ").append("mix:defaultSetting");
        strQuery.append(" WHERE jcr:path LIKE '/").append("settings/user").append("/%' AND NOT jcr:path LIKE '/").append("settings/user").append("/%/%'");
        QueryManager qm = session.getWorkspace().getQueryManager();
        QueryImpl query = (QueryImpl)qm.createQuery(strQuery.toString(), "sql");
        if (limit > 0) {
            query.setLimit((long)limit);
            query.setOffset((long)offset);
        }
        return query.execute().getNodes();
    }

    public List<UserSetting> getDefaultDaily(int offset, int limit) {
        SessionProvider sProvider = NotificationSessionManager.createSystemProvider();
        ArrayList<UserSetting> users = new ArrayList<UserSetting>();
        try {
            Session session = UserSettingServiceImpl.getSession(sProvider, this.workspace);
            if (session.getRootNode().hasNode("settings/user")) {
                NodeIterator iter = this.getDefaultDailyIterator(sProvider, offset, limit);
                while (iter.hasNext()) {
                    Node node = iter.nextNode();
                    users.add(UserSetting.getInstance().setUserId(node.getName()).setLastUpdateTime(node.getProperty("exo:lastModifiedDate").getDate()));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to get default daily users have notification messages", (Throwable)e);
        }
        return users;
    }

    public long getNumberOfDefaultDaily() {
        SessionProvider sProvider = NotificationSessionManager.createSystemProvider();
        try {
            Session session = UserSettingServiceImpl.getSession(sProvider, this.workspace);
            if (session.getRootNode().hasNode("settings/user")) {
                NodeIterator iter = this.getDefaultDailyIterator(sProvider, 0, 0);
                return iter.getSize();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to get default daily users have notification messages", (Throwable)e);
        }
        return 0L;
    }
}

