/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.template;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleData;
import org.exoplatform.services.resources.ResourceBundleService;

public class TemplateResourceBundle {
    private static final Log LOG = ExoLogger.getLogger(TemplateResourceBundle.class);
    private static final String CONF_LOCATION = "war:/classes/";
    private String language;
    private String bundlePath;

    public TemplateResourceBundle(String language, String bundlePath) {
        this.language = language;
        this.bundlePath = bundlePath;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getBundlePath() {
        return this.bundlePath;
    }

    public void setBundlePath(String bundlePath) {
        this.bundlePath = bundlePath;
    }

    public String appRes(String key) {
        Locale locale = Locale.ENGLISH;
        if (this.language != null && this.language.length() > 0) {
            locale = new Locale(this.language);
        }
        return TemplateResourceBundle.getResourceBundle(key, locale, this.bundlePath);
    }

    public String appRes(String key, String ... strs) {
        String value = this.appRes(key);
        if (strs != null && strs.length > 0) {
            for (int i = 0; i < strs.length; ++i) {
                value = StringUtils.replace((String)value, (String)("{" + i + "}"), (String)strs[i]);
            }
        }
        return value;
    }

    private static ResourceBundle addResourceBundle(ResourceBundleService bundleService, String resourceLocale, Locale locale) {
        String id = new StringBuffer(CONF_LOCATION).append(resourceLocale.replace(".", "/")).append("_").append(locale.getLanguage()).append(".properties").toString();
        try {
            ConfigurationManager configurationManager = CommonsUtils.getService(ConfigurationManager.class);
            InputStream inputStream = configurationManager.getInputStream(id);
            if (inputStream != null) {
                String data = TemplateResourceBundle.getContent(inputStream);
                ResourceBundleData bundleData = new ResourceBundleData(data);
                bundleData.setLanguage(locale.getLanguage());
                bundleData.setName(resourceLocale);
                bundleData.setCountry("");
                bundleData.setVariant("");
                bundleService.saveResourceBundle(bundleData);
                return bundleService.getResourceBundle(resourceLocale, locale);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Can not add resource bundle of locale " + resourceLocale + "\n" + e.getMessage()));
        }
        return null;
    }

    public static String getResourceBundle(String key, Locale locale, String resourceLocale) {
        if (key == null || key.trim().length() == 0) {
            return "";
        }
        if (locale == null || locale.getLanguage().isEmpty()) {
            locale = Locale.ENGLISH;
        }
        ResourceBundle res = null;
        ResourceBundleService bundleService = CommonsUtils.getService(ResourceBundleService.class);
        if (bundleService != null && (res = bundleService.getResourceBundle(resourceLocale, locale)) == null) {
            res = TemplateResourceBundle.addResourceBundle(bundleService, resourceLocale, locale);
        }
        if (res == null || !res.containsKey(key)) {
            if (key.indexOf(".digest.") < 0) {
                LOG.warn((Object)("Can not get resource bundle by key: " + key));
            }
            return key;
        }
        return res.getString(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getContent(InputStream input) throws IOException {
        StringBuilder content = new StringBuilder();
        Scanner scanner = new Scanner(input, "UTF-8");
        try {
            while (scanner.hasNextLine()) {
                if (content.length() > 0) {
                    content.append("\n");
                }
                String s = scanner.nextLine();
                content.append(s);
            }
        }
        finally {
            scanner.close();
            input.close();
        }
        return content.toString();
    }
}

