/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.util.ISO9075;
import org.exoplatform.services.jcr.impl.util.NodeTypeRecognizer;

public class DeploymentUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getNodeName(InputStream stream) throws XMLStreamException, IOException {
        String nodeToImportName = null;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader reader = null;
        try {
            reader = factory.createXMLEventReader(stream);
            XMLEvent event = null;
            do {
                event = reader.nextEvent();
            } while (reader.hasNext() && event.getEventType() != 1);
            if (event.getEventType() != 1) {
                throw new IllegalStateException("Content isn't lisible");
            }
            StartElement element = event.asStartElement();
            QName name = element.getName();
            switch (NodeTypeRecognizer.recognize((String)name.getNamespaceURI(), (String)(name.getPrefix() + ":" + name.getLocalPart()))) {
                case DOCVIEW: {
                    if (name.getPrefix() == null || name.getPrefix().isEmpty()) {
                        nodeToImportName = ISO9075.decode((String)name.getLocalPart());
                        return nodeToImportName;
                    } else {
                        nodeToImportName = ISO9075.decode((String)(name.getPrefix() + ":" + name.getLocalPart()));
                        return nodeToImportName;
                    }
                }
                case SYSVIEW: {
                    Iterator<Attribute> attributes = element.getAttributes();
                    while (attributes.hasNext() && nodeToImportName == null) {
                        Attribute attribute = attributes.next();
                        if (!(attribute.getName().getNamespaceURI() + ":" + attribute.getName().getLocalPart()).equals(Constants.SV_NAME_NAME.getNamespace() + ":" + Constants.SV_NAME_NAME.getName())) continue;
                        nodeToImportName = attribute.getValue();
                        return nodeToImportName;
                    }
                    return nodeToImportName;
                }
                default: {
                    throw new IllegalStateException("There was an error during ascertaining the type of document. First element ");
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
                stream.close();
            }
        }
    }
}

