/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.user;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/state/")
public class RESTUserService
implements ResourceContainer {
    private final UserStateService userService;
    protected static final String ACTIVITY = "activity";
    protected static final String STATUS = "status";

    public RESTUserService(UserStateService userService) {
        this.userService = userService;
    }

    @GET
    @Path(value="/ping/")
    @RolesAllowed(value={"users"})
    public Response updateState() {
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        this.userService.ping(userId);
        return Response.ok().build();
    }

    @GET
    @Path(value="/status/")
    @RolesAllowed(value={"users"})
    public Response online() throws ParserConfigurationException, JSONException {
        List<UserStateModel> usersOnline = this.userService.online();
        if (usersOnline == null) {
            return Response.ok().build();
        }
        JSONArray json = new JSONArray();
        for (int i = 0; i < usersOnline.size(); ++i) {
            UserStateModel model = usersOnline.get(i);
            JSONObject object = new JSONObject();
            object.put("userId", (Object)model.getUserId());
            Date date = new Date(model.getLastActivity());
            SimpleDateFormat ISO_8601_DATE_TIME = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            String lastActivityDate = ISO_8601_DATE_TIME.format(date);
            object.put("lastActivityDate", (Object)lastActivityDate);
            object.put(STATUS, (Object)model.getStatus());
            long iDate = new Date().getTime();
            long lastActivity = model.getLastActivity();
            if (lastActivity >= iDate - (long)this.userService.delay) {
                object.put(ACTIVITY, (Object)"online");
            } else {
                object.put(ACTIVITY, (Object)"offline");
            }
            json.put((Object)object);
        }
        return Response.ok((Object)json.toString(), (String)"application/json").build();
    }

    @GET
    @Path(value="/status/{userId}/")
    @RolesAllowed(value={"users"})
    public Response getStatus(@PathParam(value="userId") String userId) throws JSONException {
        UserStateModel model = this.userService.getUserState(userId);
        if (model == null) {
            return Response.noContent().build();
        }
        JSONObject object = new JSONObject();
        object.put(ACTIVITY, (Object)"offline");
        if (model != null) {
            object.put("userId", (Object)model.getUserId());
            Date date = new Date(model.getLastActivity());
            SimpleDateFormat ISO_8601_DATE_TIME = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            String lastActivityDate = ISO_8601_DATE_TIME.format(date);
            object.put("lastActivityDate", (Object)lastActivityDate);
            object.put(STATUS, (Object)model.getStatus());
            long iDate = new Date().getTime();
            long lastActivity = model.getLastActivity();
            if (lastActivity >= iDate - (long)this.userService.delay) {
                object.put(ACTIVITY, (Object)"online");
            }
        }
        return Response.ok((Object)object.toString(), (String)"application/json").build();
    }

    @PUT
    @Path(value="/status/{userId}/")
    @RolesAllowed(value={"users"})
    public Response setStatus(@PathParam(value="userId") String userId, @QueryParam(value="status") String status) throws JSONException {
        UserStateModel model = this.userService.getUserState(userId);
        if (StringUtils.isNotEmpty((String)status)) {
            model.setStatus(status);
            this.userService.save(model);
            return Response.ok().build();
        }
        return Response.notModified().build();
    }
}

