/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParserBase;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.QuasiNode;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StringLiteralQuasiNode
extends QuasiNode {
    private final String bindingName;

    StringLiteralQuasiNode(String bindingName) {
        super(new QuasiNode[0]);
        this.bindingName = bindingName;
    }

    @Override
    protected boolean consumeSpecimens(List<ParseTreeNode> specimens, Map<String, ParseTreeNode> bindings) {
        if (specimens.isEmpty()) {
            return false;
        }
        ParseTreeNode specimen = specimens.get(0);
        if (!(specimen instanceof StringLiteral)) {
            return false;
        }
        StringLiteral lit = (StringLiteral)specimen;
        String ident = lit.getUnquotedValue();
        if (!ParserBase.isJavascriptIdentifier(ident)) {
            return false;
        }
        ParseTreeNode existing = bindings.get(this.bindingName);
        if (!(existing == null || existing instanceof Identifier && ident.equals(existing.getValue()))) {
            return false;
        }
        Identifier identBinding = new Identifier(lit.getFilePosition(), ident);
        bindings.put(this.bindingName, identBinding);
        specimens.remove(0);
        return true;
    }

    @Override
    protected boolean createSubstitutes(List<ParseTreeNode> substitutes, Map<String, ParseTreeNode> bindings) {
        Identifier ident;
        ParseTreeNode binding = bindings.get(this.bindingName);
        if (binding instanceof Identifier) {
            ident = (Identifier)binding;
        } else if (binding instanceof Reference) {
            ident = ((Reference)binding).getIdentifier();
        } else {
            return false;
        }
        if (ident.getName() == null) {
            return false;
        }
        StringLiteral sl = StringLiteral.valueOf(ident.getFilePosition(), ident.getName());
        substitutes.add(sl);
        return true;
    }
}

