/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.xhtml.handler;

import org.xwiki.rendering.wikimodel.xhtml.handler.TagHandler;
import org.xwiki.rendering.wikimodel.xhtml.impl.XhtmlHandler;

public class QuoteTagHandler
extends TagHandler {
    public static final String QUOTEDEPTH = "quoteDepth";

    public QuoteTagHandler() {
        super(false, false, true);
    }

    @Override
    public boolean isBlockHandler(XhtmlHandler.TagStack.TagContext context) {
        return !context.getParent().getName().equals("blockquote");
    }

    @Override
    protected void begin(XhtmlHandler.TagStack.TagContext context) {
        int quoteDepth = (Integer)context.getTagStack().getStackParameter(QUOTEDEPTH);
        if (quoteDepth == 0) {
            context.getScannerContext().beginQuot(context.getParams());
        }
        context.getScannerContext().beginQuotLine(++quoteDepth);
        context.getTagStack().setStackParameter(QUOTEDEPTH, quoteDepth);
    }

    @Override
    protected void end(XhtmlHandler.TagStack.TagContext context) {
        int quoteDepth = (Integer)context.getTagStack().getStackParameter(QUOTEDEPTH);
        if (--quoteDepth < 0) {
            quoteDepth = 0;
        }
        context.getScannerContext().endQuotLine();
        if (quoteDepth == 0) {
            context.getScannerContext().endQuot();
        }
        context.getTagStack().setStackParameter(QUOTEDEPTH, quoteDepth);
    }
}

