/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.nodetype.ConstraintViolationException;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanCutNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotEditingDocumentFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.clipboard.ClipboardService;
import org.exoplatform.services.cms.clipboard.jcr.model.ClipboardCommand;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

@ComponentConfig(events={@EventConfig(listeners={CutActionListener.class})})
public class CutManageComponent
extends UIAbstractManagerComponent {
    private static final Log LOG = ExoLogger.getLogger((String)CutManageComponent.class.getName());
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotInTrashFilter(), new CanCutNodeFilter(), new IsNotLockedFilter(), new IsNotTrashHomeNodeFilter(), new IsNotEditingDocumentFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    private static void processCut(String nodePath, Event<CutManageComponent> event, UIJCRExplorer uiExplorer, boolean isMultiSelect) throws Exception {
        UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
        UIApplication uiApp = (UIApplication)((CutManageComponent)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePath);
        String wsName = null;
        if (!matcher.find()) {
            throw new IllegalArgumentException("The ObjectId is invalid '" + nodePath + "'");
        }
        wsName = matcher.group(1);
        nodePath = matcher.group(2);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        try {
            Node selectedNode = uiExplorer.getNodeByPath(nodePath, session, false);
            nodePath = selectedNode.getPath();
            session = selectedNode.getSession();
            wsName = session.getWorkspace().getName();
        }
        catch (ConstraintViolationException cons) {
            uiExplorer.getSession().refresh(false);
            uiExplorer.refreshExplorer();
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.constraintviolation-exception", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            return;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"an unexpected error occurs while cuting the node", (Throwable)e);
            }
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        try {
            ClipboardCommand clipboard = new ClipboardCommand("cut", nodePath, wsName);
            ClipboardService clipboardService = (ClipboardService)WCMCoreUtils.getService(ClipboardService.class);
            String userId = ConversationState.getCurrent().getIdentity().getUserId();
            clipboardService.addClipboardCommand(userId, clipboard, false);
            if (isMultiSelect) {
                clipboardService.addClipboardCommand(userId, clipboard, true);
            } else {
                session.save();
            }
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
        }
    }

    private static void processMultipleCut(String[] nodePaths, Event<CutManageComponent> event, UIJCRExplorer uiExplorer) throws Exception {
        for (int i = 0; i < nodePaths.length; ++i) {
            CutManageComponent.processCut(nodePaths[i], event, uiExplorer, true);
        }
        uiExplorer.getSession().save();
    }

    public static void cutManage(Event<CutManageComponent> event, UIJCRExplorer uiExplorer) throws Exception {
        UIWorkingArea uiWorkingArea = (UIWorkingArea)((CutManageComponent)((Object)event.getSource())).getParent();
        String nodePath = event.getRequestContext().getRequestParameter("objectId");
        if (nodePath.indexOf(";") > -1) {
            ClipboardService clipboardService = (ClipboardService)WCMCoreUtils.getService(ClipboardService.class);
            String userId = ConversationState.getCurrent().getIdentity().getUserId();
            clipboardService.clearClipboardList(userId, true);
            CutManageComponent.processMultipleCut(Utils.removeChildNodes((String)nodePath), event, uiExplorer);
        } else {
            CutManageComponent.processCut(nodePath, event, uiExplorer, false);
        }
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    public static class CutActionListener
    extends UIWorkingAreaActionListener<CutManageComponent> {
        public void processEvent(Event<CutManageComponent> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((CutManageComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            CutManageComponent.cutManage(event, uiExplorer);
        }
    }
}

