/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

class CrossModuleCodeMotion
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(CrossModuleCodeMotion.class.getName());
    private final AbstractCompiler compiler;
    private final JSModuleGraph graph;
    private final Map<JSModule, Node> moduleVarParentMap = new HashMap<JSModule, Node>();
    private final Map<Scope.Var, NamedInfo> namedInfo = new LinkedHashMap<Scope.Var, NamedInfo>();

    CrossModuleCodeMotion(AbstractCompiler compiler, JSModuleGraph graph) {
        this.compiler = compiler;
        this.graph = graph;
    }

    @Override
    public void process(Node externs, Node root) {
        logger.info("Moving functions + variable into deeper modules");
        if (this.graph != null && this.graph.getModuleCount() > 1) {
            NodeTraversal.traverse(this.compiler, root, this);
            this.moveCode();
        }
    }

    private void moveCode() {
        for (NamedInfo info : this.namedInfo.values()) {
            JSModule deepestDependency = info.deepestModule;
            if (!info.allowMove || deepestDependency == null) continue;
            Iterator<Declaration> it = info.declarationIterator();
            JSModuleGraph moduleGraph = this.compiler.getModuleGraph();
            while (it.hasNext()) {
                Node declParent;
                Declaration decl = it.next();
                if (decl.module == null || !moduleGraph.dependsOn(deepestDependency, decl.module)) continue;
                Node destParent = this.moduleVarParentMap.get(deepestDependency);
                if (destParent == null) {
                    destParent = this.compiler.getNodeForCodeInsertion(deepestDependency);
                    this.moduleVarParentMap.put(deepestDependency, destParent);
                }
                Preconditions.checkState(((declParent = decl.node.getParent()).getType() != 118 || declParent.hasOneChild() ? 1 : 0) != 0, (Object)"AST not normalized.");
                declParent.detachFromParent();
                destParent.addChildToFront(declParent);
                this.compiler.reportCodeChange();
            }
        }
    }

    private boolean hasConditionalAncestor(Node n) {
        for (Node ancestor : n.getAncestors()) {
            switch (ancestor.getType()) {
                case 98: 
                case 105: 
                case 108: 
                case 110: 
                case 113: 
                case 114: 
                case 115: {
                    return true;
                }
            }
        }
        return false;
    }

    private NamedInfo getNamedInfo(Scope.Var v) {
        NamedInfo info = this.namedInfo.get(v);
        if (info == null) {
            info = new NamedInfo();
            this.namedInfo.put(v, info);
        }
        return info;
    }

    private void processReference(NodeTraversal t, NamedInfo info, String name) {
        boolean recursive = false;
        Node rootNode = t.getScope().getRootNode();
        if (rootNode.isFunction()) {
            String scopeFuncName = rootNode.getFirstChild().getString();
            Node scopeFuncParent = rootNode.getParent();
            if (scopeFuncName.equals(name)) {
                recursive = true;
            } else if (scopeFuncParent.isName() && scopeFuncParent.getString().equals(name)) {
                recursive = true;
            } else {
                Scope s = t.getScope();
                while (s.getParent() != null) {
                    Node curRoot = s.getRootNode();
                    if (curRoot.getParent().isAssign()) {
                        Node owner = curRoot.getParent().getFirstChild();
                        while (owner.isGetProp()) {
                            owner = owner.getFirstChild();
                        }
                        if (owner.isName() && owner.getString().equals(name)) {
                            recursive = true;
                            break;
                        }
                    }
                    s = s.getParent();
                }
            }
        }
        if (!recursive) {
            info.addUsedModule(t.getModule());
        }
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.getType() != 38) {
            return;
        }
        String name = n.getString();
        if (name.isEmpty() || this.compiler.getCodingConvention().isExported(name)) {
            return;
        }
        Scope.Var v = t.getScope().getVar(name);
        if (v == null || !v.isGlobal()) {
            return;
        }
        NamedInfo info = this.getNamedInfo(v);
        if (info.allowMove) {
            if (this.maybeProcessDeclaration(t, n, parent, info)) {
                if (this.hasConditionalAncestor(parent.getParent())) {
                    info.allowMove = false;
                }
            } else {
                this.processReference(t, info, name);
            }
        }
    }

    private boolean maybeProcessDeclaration(NodeTraversal t, Node name, Node parent, NamedInfo info) {
        Node gramps = parent.getParent();
        switch (parent.getType()) {
            case 118: {
                if (this.canMoveValue(name.getFirstChild())) {
                    return info.addDeclaration(new Declaration(t.getModule(), name, parent, gramps));
                }
                return false;
            }
            case 105: {
                if (NodeUtil.isFunctionDeclaration(parent)) {
                    return info.addDeclaration(new Declaration(t.getModule(), name, parent, gramps));
                }
                return false;
            }
            case 33: 
            case 86: {
                Node child = name;
                for (Node current : name.getAncestors()) {
                    if (!current.isGetProp()) {
                        if (current.isAssign() && current.getFirstChild() == child) {
                            Node currentParent = current.getParent();
                            if (NodeUtil.isExpressionNode(currentParent) && this.canMoveValue(current.getLastChild())) {
                                return info.addDeclaration(new Declaration(t.getModule(), current, currentParent, currentParent.getParent()));
                            }
                        } else {
                            return false;
                        }
                    }
                    child = current;
                }
                return false;
            }
            case 37: {
                CodingConvention.SubclassRelationship relationship;
                if (NodeUtil.isExprCall(gramps) && (relationship = this.compiler.getCodingConvention().getClassesDefinedByCall(parent)) != null && name.getString().equals(relationship.subclassName)) {
                    return info.addDeclaration(new Declaration(t.getModule(), parent, gramps, gramps.getParent()));
                }
                return false;
            }
        }
        return false;
    }

    private boolean canMoveValue(Node n) {
        if (n == null || NodeUtil.isLiteralValue(n, true) || n.isFunction()) {
            return true;
        }
        if (n.isCall()) {
            Node functionName = n.getFirstChild();
            return functionName.isName() && (functionName.getString().equals("JSCompiler_stubMethod") || functionName.getString().equals("JSCompiler_unstubMethod"));
        }
        if (n.getType() == 63 || n.isObjectLit()) {
            boolean isObjectLit = n.isObjectLit();
            for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                if (this.canMoveValue(isObjectLit ? child.getFirstChild() : child)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private class Declaration {
        final JSModule module;
        final Node node;

        Declaration(JSModule module, Node node, Node parent, Node gramps) {
            this.module = module;
            this.node = node;
        }
    }

    private class NamedInfo {
        boolean allowMove = true;
        private JSModule deepestModule = null;
        private JSModule declModule = null;
        private final Deque<Declaration> declarations = new ArrayDeque<Declaration>();

        private NamedInfo() {
        }

        void addUsedModule(JSModule m) {
            if (!this.allowMove) {
                return;
            }
            this.deepestModule = this.deepestModule == null ? m : CrossModuleCodeMotion.this.graph.getDeepestCommonDependencyInclusive(m, this.deepestModule);
        }

        boolean addDeclaration(Declaration d) {
            if (this.declModule != null && d.module != this.declModule) {
                return false;
            }
            this.declarations.push(d);
            this.declModule = d.module;
            return true;
        }

        Iterator<Declaration> declarationIterator() {
            return this.declarations.iterator();
        }
    }
}

