/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.converter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.MathMLParserSupport;
import net.sourceforge.jeuclid.MutableLayoutContext;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.converter.ConverterPlugin;
import net.sourceforge.jeuclid.converter.ConverterRegistry;
import net.sourceforge.jeuclid.layout.JEuclidView;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class Converter {
    public static final String TYPE_SVG = "image/svg+xml";
    public static final String EXTENSION_SVG = "svg";
    private static final String UNSUPPORTED_OUTPUT_TYPE = "Unsupported output type: ";
    private static final Log LOGGER = LogFactory.getLog(Converter.class);

    protected Converter() {
    }

    public static Converter getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Deprecated
    public static Converter getConverter() {
        return Converter.getInstance();
    }

    public Dimension convert(File file, File file2, String string) throws IOException {
        LayoutContextImpl layoutContextImpl = new LayoutContextImpl(LayoutContextImpl.getDefaultLayoutContext());
        return this.convert(file, file2, string, (MutableLayoutContext)layoutContextImpl);
    }

    public Dimension convert(File file, File file2, String string, MutableLayoutContext mutableLayoutContext) throws IOException {
        try {
            Document document = MathMLParserSupport.parseFile(file);
            return this.convert((Node)document, file2, string, mutableLayoutContext);
        }
        catch (SAXException sAXException) {
            LOGGER.error((Object)("Failed to parse file:" + file), (Throwable)sAXException);
            return null;
        }
    }

    public Dimension convert(Node node, File file, String string, MutableLayoutContext mutableLayoutContext) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        Dimension dimension = this.convert(node, bufferedOutputStream, string, mutableLayoutContext);
        if (dimension == null) {
            if (!file.delete()) {
                LOGGER.debug((Object)("Could not delete " + file));
            }
        } else {
            try {
                ((OutputStream)bufferedOutputStream).close();
            }
            catch (IOException iOException) {
                LOGGER.debug((Object)iOException);
            }
        }
        return dimension;
    }

    public ConverterPlugin.DocumentWithDimension convert(Node node, String string, LayoutContext layoutContext) {
        ConverterPlugin converterPlugin = ConverterRegistry.getInstance().getConverter(string);
        ConverterPlugin.DocumentWithDimension documentWithDimension = null;
        if (converterPlugin != null) {
            documentWithDimension = converterPlugin.convert(node, layoutContext);
        }
        if (documentWithDimension == null) {
            LOGGER.fatal((Object)(UNSUPPORTED_OUTPUT_TYPE + string));
        }
        return documentWithDimension;
    }

    public Dimension convert(Node node, OutputStream outputStream, String string, MutableLayoutContext mutableLayoutContext) throws IOException {
        ConverterPlugin converterPlugin = ConverterRegistry.getInstance().getConverter(string);
        Dimension dimension = null;
        if (converterPlugin == null) {
            LOGGER.fatal((Object)(UNSUPPORTED_OUTPUT_TYPE + string));
        } else {
            try {
                dimension = converterPlugin.convert(node, mutableLayoutContext, outputStream);
            }
            catch (IOException iOException) {
                LOGGER.fatal((Object)("Failed to process: " + iOException.getMessage()), (Throwable)iOException);
            }
        }
        return dimension;
    }

    public BufferedImage render(Node node, LayoutContext layoutContext) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        JEuclidView jEuclidView = new JEuclidView(node, layoutContext, graphics2D);
        int n = (int)Math.ceil(jEuclidView.getWidth());
        int n2 = (int)Math.ceil(jEuclidView.getAscentHeight());
        int n3 = (int)Math.ceil(jEuclidView.getDescentHeight()) + n2;
        BufferedImage bufferedImage2 = new BufferedImage(n, n3, 2);
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        Color color = new Color(255, 255, 255, 0);
        graphics2D2.setColor(color);
        graphics2D2.fillRect(0, 0, n, n3);
        graphics2D2.setColor(Color.black);
        jEuclidView.draw(graphics2D2, 0.0f, n2);
        return bufferedImage2;
    }

    private static final class SingletonHolder {
        private static final Converter INSTANCE = new Converter();

        private SingletonHolder() {
        }
    }
}

