/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.converter;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Properties;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.converter.ConverterPlugin;
import net.sourceforge.jeuclid.layout.JEuclidView;
import org.freehep.graphics2d.VectorGraphics;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeHepConverter
implements ConverterPlugin {
    private final Constructor<VectorGraphics> streamConst;

    FreeHepConverter(Class<?> clazz) throws NoSuchMethodException {
        this.streamConst = clazz.getConstructor(OutputStream.class, Dimension.class);
    }

    @Override
    public Dimension convert(Node node, LayoutContext layoutContext, OutputStream outputStream) throws IOException {
        Properties properties = new Properties();
        properties.setProperty("PageSize", "A5");
        VectorGraphics vectorGraphics = this.createGraphics(new ByteArrayOutputStream(), new Dimension(1, 1));
        JEuclidView jEuclidView = new JEuclidView(node, layoutContext, (Graphics2D)vectorGraphics);
        int n = (int)Math.ceil(jEuclidView.getAscentHeight());
        Dimension dimension = new Dimension((int)Math.ceil(jEuclidView.getWidth()), (int)Math.ceil(jEuclidView.getDescentHeight()) + n);
        VectorGraphics vectorGraphics2 = this.createGraphics(outputStream, dimension);
        vectorGraphics2.setCreator("JEuclid (from MathML)");
        vectorGraphics2.startExport();
        jEuclidView.draw((Graphics2D)vectorGraphics2, 0.0f, n);
        vectorGraphics2.endExport();
        return dimension;
    }

    @Override
    public ConverterPlugin.DocumentWithDimension convert(Node node, LayoutContext layoutContext) {
        return null;
    }

    private VectorGraphics createGraphics(OutputStream outputStream, Dimension dimension) {
        try {
            return this.streamConst.newInstance(outputStream, dimension);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected - failed to create a FreeHep VectorGraphics instance", exception);
        }
    }
}

