/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.general;

import java.awt.Color;
import java.awt.Graphics2D;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.InlineLayoutContext;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.elements.AbstractJEuclidElement;
import net.sourceforge.jeuclid.elements.support.Dimension2DImpl;
import net.sourceforge.jeuclid.elements.support.ElementListSupport;
import net.sourceforge.jeuclid.elements.support.GraphicsSupport;
import net.sourceforge.jeuclid.elements.support.attributes.AttributesHelper;
import net.sourceforge.jeuclid.elements.support.attributes.HAlign;
import net.sourceforge.jeuclid.layout.LayoutInfo;
import net.sourceforge.jeuclid.layout.LayoutStage;
import net.sourceforge.jeuclid.layout.LayoutView;
import net.sourceforge.jeuclid.layout.LayoutableNode;
import net.sourceforge.jeuclid.layout.LineObject;
import org.w3c.dom.Node;
import org.w3c.dom.mathml.MathMLElement;
import org.w3c.dom.mathml.MathMLFractionElement;

public final class Mfrac
extends AbstractJEuclidElement
implements MathMLFractionElement {
    public static final String ELEMENT = "mfrac";
    public static final float FRAC_TILT_ANGLE = 0.577f;
    public static final String ATTR_LINETHICKNESS = "linethickness";
    public static final String ATTR_BEVELED_WRONG = "beveled";
    public static final String ATTR_BEVELLED = "bevelled";
    public static final String ATTR_NUMALIGN = "numalign";
    public static final String ATTR_DENOMALIGN = "denomalign";
    private static final String EXTRA_SPACE_AROUND = "0.1em";
    private static final long serialVersionUID = 1L;
    private static final float NOLINE_THRESHHOLD = 0.001f;

    public Mfrac() {
        this.setDefaultMathAttribute(ATTR_LINETHICKNESS, "1");
        this.setDefaultMathAttribute(ATTR_BEVELLED, Boolean.FALSE.toString());
        this.setDefaultMathAttribute(ATTR_NUMALIGN, "center");
        this.setDefaultMathAttribute(ATTR_DENOMALIGN, "center");
    }

    protected Node newNode() {
        return new Mfrac();
    }

    public LayoutContext getChildLayoutContext(int n, LayoutContext layoutContext) {
        return new InlineLayoutContext(this.applyLocalAttributesToContext(layoutContext), (Boolean)layoutContext.getParameter(Parameter.MFRAC_KEEP_SCRIPTLEVEL) == false);
    }

    public void setLinethickness(String string) {
        this.setAttribute(ATTR_LINETHICKNESS, string);
    }

    public float getLinethickness(Graphics2D graphics2D, LayoutContext layoutContext) {
        float f;
        block2: {
            String string = this.getLinethickness();
            try {
                f = Float.parseFloat(string);
                f *= GraphicsSupport.lineWidth(layoutContext);
            }
            catch (NumberFormatException numberFormatException) {
                f = AttributesHelper.convertSizeToPt(string, this.applyLocalAttributesToContext(layoutContext), "pt");
                if (!(f < 1.0f) || !(f >= 0.001f)) break block2;
                f = 1.0f;
            }
        }
        return f;
    }

    public void setBevelled(String string) {
        this.setAttribute(ATTR_BEVELLED, string);
    }

    public String getBevelled() {
        String string = this.getMathAttribute(ATTR_BEVELED_WRONG, false);
        if (string == null) {
            return this.getMathAttribute(ATTR_BEVELLED);
        }
        return string;
    }

    public MathMLElement getDenominator() {
        return this.getMathElement(1);
    }

    public String getLinethickness() {
        return this.getMathAttribute(ATTR_LINETHICKNESS);
    }

    public MathMLElement getNumerator() {
        return this.getMathElement(0);
    }

    public void setDenominator(MathMLElement mathMLElement) {
        this.setMathElement(1, mathMLElement);
    }

    public void setNumerator(MathMLElement mathMLElement) {
        this.setMathElement(0, mathMLElement);
    }

    public String getDenomalign() {
        return this.getMathAttribute(ATTR_DENOMALIGN);
    }

    public String getNumalign() {
        return this.getMathAttribute(ATTR_NUMALIGN);
    }

    public void setDenomalign(String string) {
        this.setAttribute(ATTR_DENOMALIGN, string);
    }

    public void setNumalign(String string) {
        this.setAttribute(ATTR_NUMALIGN, string);
    }

    protected void layoutStageInvariant(LayoutView layoutView, LayoutInfo layoutInfo, LayoutStage layoutStage, LayoutContext layoutContext) {
        Graphics2D graphics2D = layoutView.getGraphics();
        float f = this.getMiddleShift(graphics2D, layoutContext);
        boolean bl = Boolean.parseBoolean(this.getBevelled());
        float f2 = this.getLinethickness(graphics2D, layoutContext);
        float f3 = AttributesHelper.convertSizeToPt(EXTRA_SPACE_AROUND, this.applyLocalAttributesToContext(layoutContext), "");
        LayoutInfo layoutInfo2 = layoutView.getInfo((LayoutableNode)((Object)this.getNumerator()));
        LayoutInfo layoutInfo3 = layoutView.getInfo((LayoutableNode)((Object)this.getDenominator()));
        if (bl) {
            this.layoutBeveled(layoutInfo, layoutStage, f, f2, f3, layoutInfo2, layoutInfo3, layoutContext);
        } else {
            this.layoutStacked(layoutInfo, layoutStage, f, f2, f3, layoutInfo2, layoutInfo3, layoutContext);
        }
        Dimension2DImpl dimension2DImpl = new Dimension2DImpl(f3 + f2, 0.0f);
        Dimension2DImpl dimension2DImpl2 = new Dimension2DImpl(f3 + f2, 0.0f);
        ElementListSupport.fillInfoFromChildren(layoutView, layoutInfo, this, layoutStage, dimension2DImpl, dimension2DImpl2);
    }

    private void layoutStacked(LayoutInfo layoutInfo, LayoutStage layoutStage, float f, float f2, float f3, LayoutInfo layoutInfo2, LayoutInfo layoutInfo3, LayoutContext layoutContext) {
        float f4 = layoutInfo2.getWidth(layoutStage);
        float f5 = layoutInfo3.getWidth(layoutStage);
        float f6 = Math.max(f5, f4);
        float f7 = HAlign.parseString(this.getNumalign(), HAlign.CENTER).getHAlignOffset(layoutStage, layoutInfo2, f6);
        float f8 = HAlign.parseString(this.getDenomalign(), HAlign.CENTER).getHAlignOffset(layoutStage, layoutInfo3, f6);
        layoutInfo2.moveTo(f7 + f3, -(f + f2 / 2.0f + f3 + layoutInfo2.getDescentHeight(layoutStage)), layoutStage);
        layoutInfo3.moveTo(f8 + f3, -f + f2 / 2.0f + f3 + layoutInfo3.getAscentHeight(layoutStage), layoutStage);
        if (f2 > 0.001f) {
            LineObject lineObject = new LineObject(f3, -f, f3 + f6, -f, f2, (Color)this.applyLocalAttributesToContext(layoutContext).getParameter(Parameter.MATHCOLOR));
            layoutInfo.setGraphicsObject(lineObject);
        }
    }

    private void layoutBeveled(LayoutInfo layoutInfo, LayoutStage layoutStage, float f, float f2, float f3, LayoutInfo layoutInfo2, LayoutInfo layoutInfo3, LayoutContext layoutContext) {
        float f4 = -f / 2.0f + layoutInfo2.getDescentHeight(layoutStage);
        float f5 = f / 2.0f + layoutInfo3.getDescentHeight(layoutStage);
        float f6 = Math.max(-f4 + layoutInfo2.getAscentHeight(layoutStage), -f5 + layoutInfo3.getAscentHeight(layoutStage));
        float f7 = Math.max(f4 + layoutInfo2.getDescentHeight(layoutStage), f5 + layoutInfo3.getDescentHeight(layoutStage));
        float f8 = f6 + f7;
        float f9 = f8 * 0.577f;
        layoutInfo2.moveTo(f3, f4, layoutStage);
        float f10 = layoutInfo2.getWidth(layoutStage) + f3;
        if (f2 > 0.001f) {
            LineObject lineObject = new LineObject(f10, f7, f9 + f10, f7 - f8, f2, (Color)this.applyLocalAttributesToContext(layoutContext).getParameter(Parameter.MATHCOLOR));
            layoutInfo.setGraphicsObject(lineObject);
        }
        layoutInfo3.moveTo(f10 += f9, f5, layoutStage);
    }
}

