/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.definitions;

public final class AccentMap {
    private static final int MIN_CODEPOINT = 32;
    private static final int MAX_CODEPOINT = 128;
    private final char[] textAccentByCodePoint = new char[96];
    private final char[] mathSafeAccentByCodePoint = new char[96];

    public AccentMap(char[] accentData, String mathUnsafeChars) {
        int i = 0;
        while (i < accentData.length) {
            char ascii = accentData[i++];
            char accented = accentData[i++];
            int index = this.charToIndex(ascii);
            if (index == -1) continue;
            this.textAccentByCodePoint[index] = accented;
            if (mathUnsafeChars.indexOf(ascii) != -1) continue;
            this.mathSafeAccentByCodePoint[index] = accented;
        }
    }

    public char getAccentedTextChar(char c) {
        int index = this.charToIndex(c);
        return index != -1 ? this.textAccentByCodePoint[index] : (char)'\u0000';
    }

    public char getAccentedMathChar(char c) {
        int index = this.charToIndex(c);
        return index != -1 ? this.mathSafeAccentByCodePoint[index] : (char)'\u0000';
    }

    private int charToIndex(char c) {
        int index = c - 32;
        return index >= 0 && index < 128 ? index : -1;
    }
}

