/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.dombuilding;

import java.util.List;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.ErrorCode;
import uk.ac.ed.ph.snuggletex.dombuilding.EnvironmentHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.TabularHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;

public final class EqnArrayHandler
implements EnvironmentHandler {
    private static final String[] COLUMN_ALIGNMENTS = new String[]{"right", "center", "left"};

    public void handleEnvironment(DOMBuilder builder, Element parentElement, EnvironmentToken token) throws SnuggleParseException {
        Element semantics;
        int[] geometry = TabularHandler.computeTableDimensions(token.getContent());
        int numColumns = geometry[1];
        if (numColumns > 3) {
            builder.appendOrThrowError(parentElement, token, ErrorCode.TDEM01, numColumns);
            return;
        }
        builder.setOutputContext(DOMBuilder.OutputContext.MATHML_BLOCK);
        Element mathElement = builder.appendMathMLElement(parentElement, "math");
        mathElement.setAttribute("display", "block");
        Element mtableParent = builder.getOptions().isAddingMathAnnotations() ? (semantics = builder.appendMathMLElement(mathElement, "semantics")) : mathElement;
        Element mtableElement = builder.appendMathMLElement(mtableParent, "mtable");
        for (FlowToken rowToken : token.getContent()) {
            Element mtrElement = builder.appendMathMLElement(mtableElement, "mtr");
            List<FlowToken> columns = ((CommandToken)rowToken).getArguments()[0].getContents();
            int columnIndex = 0;
            for (FlowToken columnToken : columns) {
                Element mtdElement = builder.appendMathMLElement(mtrElement, "mtd");
                mtdElement.setAttribute("columnalign", COLUMN_ALIGNMENTS[columnIndex++]);
                builder.handleTokens(mtdElement, ((CommandToken)columnToken).getArguments()[0].getContents(), true);
            }
            for (int i = 0; i < numColumns - columns.size(); ++i) {
                builder.appendMathMLElement(mtrElement, "mtd");
            }
        }
        if (builder.getOptions().isAddingMathAnnotations()) {
            Element annotation = builder.appendMathMLTextElement(mtableParent, "annotation", ((Object)token.getSlice().extract()).toString(), true);
            annotation.setAttribute("encoding", "SnuggleTeX");
        }
        builder.setOutputContext(DOMBuilder.OutputContext.XHTML);
    }
}

