/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.semantics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MathMLOperator {
    ADD(OperatorType.INFIX, "+"),
    SUBTRACT(OperatorType.INFIX, "-"),
    ASTERISK(OperatorType.INFIX, "*"),
    SLASH(OperatorType.INFIX, "/"),
    COMMA(OperatorType.INFIX, ","),
    EQUALS(OperatorType.INFIX, "="),
    FACTORIAL(OperatorType.POSTFIX, "!"),
    BACKSLASH(OperatorType.INFIX, "\\"),
    NEG(OperatorType.PREFIX, "\u00ac"),
    LESS_THAN_OR_OPEN_ANGLE_BRACKET(OperatorType.INFIX, "<"),
    GREATER_THAN_OR_CLOSE_ANGLE_BRACKET(OperatorType.INFIX, ">"),
    OPEN_BRACKET(OperatorType.PREFIX, "("),
    CLOSE_BRACKET(OperatorType.POSTFIX, ")"),
    OPEN_CURLY_BRACKET(OperatorType.PREFIX, "{"),
    CLOSE_CURLY_BRACKET(OperatorType.POSTFIX, "}"),
    OPEN_SQUARE_BRACKET(OperatorType.PREFIX, "["),
    CLOSE_SQUARE_BRACKET(OperatorType.POSTFIX, "]"),
    VERT_BRACKET(OperatorType.INFIX, "|"),
    DOUBLE_VERT_BRACKET(OperatorType.INFIX, "\u2225"),
    PM(OperatorType.INFIX, "\u00b1"),
    TIMES(OperatorType.INFIX, "\u00d7"),
    DIV(OperatorType.INFIX, "\u00f7"),
    DAGGER(OperatorType.INFIX, "\u2020"),
    DDAGGER(OperatorType.INFIX, "\u2021"),
    APPLY_FUNCTION(OperatorType.INFIX, "\u2061"),
    INVISIBLE_TIMES(OperatorType.INFIX, "\u2062"),
    LEFTARROW(OperatorType.INFIX, "\u2190"),
    UPARROW(OperatorType.INFIX, "\u2191"),
    RIGHTARROW(OperatorType.INFIX, "\u2192"),
    DOWNARROW(OperatorType.INFIX, "\u2193"),
    LEFTRIGHTARROW(OperatorType.INFIX, "\u2194"),
    UPDOWNARROW(OperatorType.INFIX, "\u2195"),
    NWARROW(OperatorType.INFIX, "\u2196"),
    NEARROW(OperatorType.INFIX, "\u2197"),
    SEARROW(OperatorType.INFIX, "\u2198"),
    SWARROW(OperatorType.INFIX, "\u2199"),
    MAPSTO(OperatorType.INFIX, "\u21a6"),
    HOOKLEFTARROW(OperatorType.INFIX, "\u21a9"),
    HOOKRIGHTARROW(OperatorType.INFIX, "\u21aa"),
    LEFTHARPOONUP(OperatorType.INFIX, "\u21bc"),
    LEFTHARPOONDOWN(OperatorType.INFIX, "\u21bd"),
    RIGHTHARPOONOUP(OperatorType.INFIX, "\u21c0"),
    RIGHTHARPOONDOWN(OperatorType.INFIX, "\u21c1"),
    RIGHTLEFTHARPOONS(OperatorType.INFIX, "\u21cc"),
    UC_LEFTARROW(OperatorType.INFIX, "\u21d0"),
    UC_UPARROW(OperatorType.INFIX, "\u21d1"),
    UC_RIGHTARROW(OperatorType.INFIX, "\u21d2"),
    UC_DOWNARROW(OperatorType.INFIX, "\u21d3"),
    UC_LEFTRIGHTARROW(OperatorType.INFIX, "\u21d4"),
    UC_UPDOWNARROW(OperatorType.INFIX, "\u21d5"),
    FORALL(OperatorType.PREFIX, "\u2200"),
    PARTIAL(OperatorType.PREFIX, "\u2202"),
    EXISTS(OperatorType.PREFIX, "\u2203"),
    NABLA(OperatorType.PREFIX, "\u2207"),
    IN(OperatorType.INFIX, "\u2208"),
    NOT_IN(OperatorType.INFIX, "\u2209"),
    NI(OperatorType.INFIX, "\u220b"),
    NOT_NI(OperatorType.INFIX, "\u220c"),
    PROD(OperatorType.PREFIX, "\u220f", true),
    COPROD(OperatorType.PREFIX, "\u2210", true),
    SUM(OperatorType.PREFIX, "\u2211", true),
    MP(OperatorType.INFIX, "\u2213"),
    SETMINUS(OperatorType.INFIX, "\u2216"),
    AST(OperatorType.INFIX, "\u2217"),
    CIRC(OperatorType.INFIX, "\u2218"),
    BULLET(OperatorType.INFIX, "\u2219"),
    PROPTO(OperatorType.INFIX, "\u221d"),
    MID(OperatorType.INFIX, "\u2223"),
    NOT_MID(OperatorType.INFIX, "\u2224"),
    PARALLEL(OperatorType.INFIX, "\u2225"),
    NOT_PARALLEL(OperatorType.INFIX, "\u2226"),
    WEDGE(OperatorType.INFIX, "\u2227"),
    VEE(OperatorType.INFIX, "\u2228"),
    CAP(OperatorType.INFIX, "\u2229"),
    CUP(OperatorType.INFIX, "\u222a"),
    SURD(OperatorType.PREFIX, "\u221a"),
    ANGLE(OperatorType.PREFIX, "\u2220"),
    INTEGRAL(OperatorType.PREFIX, "\u222b"),
    OINT(OperatorType.PREFIX, "\u222e"),
    TOP(OperatorType.INFIX, "\u22a4"),
    BOT(OperatorType.INFIX, "\u22a5"),
    SIM(OperatorType.INFIX, "\u223c"),
    WR(OperatorType.INFIX, "\u2240"),
    NOT_SIM(OperatorType.INFIX, "\u2241"),
    SIMEQ(OperatorType.INFIX, "\u2243"),
    NOT_SIMEQ(OperatorType.INFIX, "\u2244"),
    CONG(OperatorType.INFIX, "\u2245"),
    NOT_CONG(OperatorType.INFIX, "\u2246"),
    APPROX(OperatorType.INFIX, "\u2248"),
    NOT_APPROX(OperatorType.INFIX, "\u2249"),
    ASYMP(OperatorType.INFIX, "\u224d"),
    DOTEQ(OperatorType.INFIX, "\u2250"),
    NOT_EQUALS(OperatorType.INFIX, "\u2260"),
    EQUIV(OperatorType.INFIX, "\u2261"),
    NOT_EQUIV(OperatorType.INFIX, "\u2262"),
    LEQ(OperatorType.INFIX, "\u2264"),
    GEQ(OperatorType.INFIX, "\u2265"),
    LL(OperatorType.INFIX, "\u226a"),
    GG(OperatorType.INFIX, "\u226b"),
    NOT_LESS_THAN(OperatorType.INFIX, "\u226e"),
    NOT_GREATER_THAN(OperatorType.INFIX, "\u226f"),
    NOT_LEQ(OperatorType.INFIX, "\u2270"),
    NOT_GEQ(OperatorType.INFIX, "\u2271"),
    PREC(OperatorType.INFIX, "\u227a"),
    SUCC(OperatorType.INFIX, "\u227b"),
    PRECEQ(OperatorType.INFIX, "\u227c"),
    SUCCEQ(OperatorType.INFIX, "\u227d"),
    NOT_PREC(OperatorType.INFIX, "\u2280"),
    NOT_SUCC(OperatorType.INFIX, "\u2281"),
    SUBSET(OperatorType.INFIX, "\u2282"),
    SUPSET(OperatorType.INFIX, "\u2283"),
    NOT_SUBSET(OperatorType.INFIX, "\u2284"),
    NOT_SUPSET(OperatorType.INFIX, "\u2285"),
    SUBSETEQ(OperatorType.INFIX, "\u2286"),
    SUPSETEQ(OperatorType.INFIX, "\u2287"),
    NOT_SUBSETEQ(OperatorType.INFIX, "\u2288"),
    NOT_SUPSETEQ(OperatorType.INFIX, "\u2289"),
    UPLUS(OperatorType.INFIX, "\u228e"),
    SQSUBSET(OperatorType.INFIX, "\u228f"),
    SQSUPSET(OperatorType.INFIX, "\u2290"),
    SQSUBSETEQ(OperatorType.INFIX, "\u2291"),
    SQSUPSETEQ(OperatorType.INFIX, "\u2292"),
    SQCAP(OperatorType.INFIX, "\u2293"),
    SQCUP(OperatorType.INFIX, "\u2294"),
    OPLUS(OperatorType.INFIX, "\u2295"),
    OMINUS(OperatorType.INFIX, "\u2296"),
    OTIMES(OperatorType.INFIX, "\u2297"),
    OSLASH(OperatorType.INFIX, "\u2298"),
    ODOT(OperatorType.INFIX, "\u2299"),
    VDASH(OperatorType.INFIX, "\u22a2"),
    DASHV(OperatorType.INFIX, "\u22a3"),
    PERP(OperatorType.INFIX, "\u22a5"),
    MODELS(OperatorType.INFIX, "\u22a8"),
    NOT_VDASH(OperatorType.INFIX, "\u22ac"),
    NOT_MODELS(OperatorType.INFIX, "\u22ad"),
    TRIANGLELEFT(OperatorType.INFIX, "\u22b2"),
    TRIANGLERIGHT(OperatorType.INFIX, "\u22b3"),
    BIGWEDGE(OperatorType.PREFIX, "\u22c0", true),
    BIGVEE(OperatorType.PREFIX, "\u22c1", true),
    CDOT(OperatorType.INFIX, "\u22c5"),
    STAR(OperatorType.INFIX, "\u22c6"),
    BOWTIE(OperatorType.INFIX, "\u22c8"),
    NOT_SQSUBSETEQ(OperatorType.INFIX, "\u22e2"),
    NOT_SQSUPSETEQ(OperatorType.INFIX, "\u22e3"),
    BIGCAP(OperatorType.PREFIX, "\u22c2", true),
    BIGCUP(OperatorType.PREFIX, "\u22c3", true),
    SMILE(OperatorType.INFIX, "\u2323"),
    FROWN(OperatorType.INFIX, "\u2324"),
    BIGTRIANGLEUP(OperatorType.INFIX, "\u25b3"),
    BIGTRIANGLEDOWN(OperatorType.INFIX, "\u25bd"),
    DIAMOND(OperatorType.INFIX, "\u25c7"),
    BIGCIRC(OperatorType.INFIX, "\u25cb"),
    BIGODOT(OperatorType.PREFIX, "\u2a00", true),
    BIGOPLUS(OperatorType.PREFIX, "\u2a01", true),
    BIGOTIMES(OperatorType.PREFIX, "\u2a02", true),
    BIGUPLUS(OperatorType.PREFIX, "\u2a04", true),
    BIGSQCUP(OperatorType.PREFIX, "\u2a06", true),
    AMALG(OperatorType.INFIX, "\u2a3f"),
    SUPER(OperatorType.INFIX, null),
    SUB(OperatorType.INFIX, null);

    private final OperatorType operatorType;
    private final String output;
    private final boolean limitsUnderOrOver;

    private MathMLOperator(OperatorType operatorType, String output) {
        this(operatorType, output, false);
    }

    private MathMLOperator(OperatorType operatorType, String output, boolean limitsUnderOrOver) {
        this.operatorType = operatorType;
        this.output = output;
        this.limitsUnderOrOver = limitsUnderOrOver;
    }

    public OperatorType getOperatorType() {
        return this.operatorType;
    }

    public String getOutput() {
        return this.output;
    }

    public boolean isLimitsUnderOrOver() {
        return this.limitsUnderOrOver;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperatorType {
        PREFIX,
        INFIX,
        POSTFIX;

    }
}

