/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.chromattic.ext.ntdef.NTFolder;
import org.chromattic.ext.ntdef.Resource;
import org.exoplatform.application.gadget.EncodingDetector;
import org.exoplatform.application.gadget.GadgetImporter;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.application.gadget.impl.GadgetDefinition;
import org.exoplatform.application.gadget.impl.LocalGadgetData;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.common.io.IOTools;

public class LocalGadgetImporter
extends GadgetImporter {
    private static final Log LOG = ExoLogger.getExoLogger(LocalGadgetImporter.class);
    private ConfigurationManager configurationManager;
    private PortalContainer container;
    private String gadgetPath;
    private String gadgetRootAbsolutePath;
    private NTFolder folder;
    private GadgetRegistryService gadgetService;

    public LocalGadgetImporter(String name, GadgetRegistryService registryService, String gadgetPath, ConfigurationManager configurationManager, PortalContainer container) {
        super(name, gadgetPath);
        this.configurationManager = configurationManager;
        this.container = container;
        this.gadgetPath = gadgetPath;
        this.gadgetService = registryService;
        if (gadgetPath.startsWith("war:")) {
            gadgetPath = gadgetPath.replace("war:", "");
            this.gadgetRootAbsolutePath = container.getPortalContext().getRealPath(gadgetPath);
            this.gadgetRootAbsolutePath = this.gadgetRootAbsolutePath.replace("\\", "/");
            int gadgetRootPathIndex = this.gadgetRootAbsolutePath.lastIndexOf(gadgetPath);
            this.gadgetRootAbsolutePath = this.gadgetRootAbsolutePath.substring(0, gadgetRootPathIndex);
        }
    }

    protected void process(String gadgetURI, GadgetDefinition def) throws Exception {
        def.setLocal(true);
        LocalGadgetData data = (LocalGadgetData)def.getData();
        String fileName = this.getName(this.gadgetPath);
        data.setFileName(fileName);
        this.folder = data.getResources();
        String folderPath = this.getParent(this.gadgetPath);
        this.visitChildren(this.gadgetPath, folderPath);
        this.folder = null;
    }

    protected byte[] getGadgetBytes(String gadgetURI) throws IOException {
        return this.getContent(gadgetURI);
    }

    protected String getGadgetURL() {
        return this.gadgetService.getGadgetURL(this.getGadgetName());
    }

    private void visit(String uri, String resourcePath) throws Exception {
        String name = this.getName(resourcePath);
        if (this.isFile(resourcePath)) {
            byte[] content = this.getContent(resourcePath);
            if (content != null) {
                String mimeType = this.getMimeType(name);
                if (mimeType == null) {
                    mimeType = "application/octet-stream";
                }
                String encoding = null;
                if ("application/xml".equals(mimeType)) {
                    encoding = EncodingDetector.detect((InputStream)new ByteArrayInputStream(content));
                }
                if (resourcePath.equals(uri)) {
                    mimeType = "application/x-google-gadget";
                }
                this.folder.createFile(name, new Resource(mimeType, encoding, content));
            }
        } else {
            this.folder = this.folder.createFolder(name);
            this.visitChildren(uri, resourcePath);
            this.folder = this.folder.getParent();
        }
    }

    private void visitChildren(String gadgetURI, String folderPath) throws Exception {
        for (String childPath : this.getChildren(folderPath)) {
            this.visit(gadgetURI, childPath);
        }
    }

    private String getName(String resourcePath) {
        if ((resourcePath = resourcePath.replace("\\", "/")).endsWith("/")) {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        int index = resourcePath.lastIndexOf(47);
        return resourcePath.substring(index + 1);
    }

    private String getParent(String resourcePath) throws IOException {
        String separator = this.getUsedSeparator(resourcePath);
        separator = resourcePath.indexOf("\\") >= 0 ? "\\" : "/";
        if (resourcePath.endsWith(separator)) {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        int index = resourcePath.lastIndexOf(separator);
        return resourcePath.substring(0, index + 1);
    }

    private String getRealPath(String resourcePath) throws Exception {
        if (!(resourcePath.startsWith("war:") || resourcePath.startsWith("classpath:") || resourcePath.startsWith("jar:"))) {
            File file = new File(resourcePath);
            return file.getAbsolutePath();
        }
        if (resourcePath.startsWith("war:")) {
            if (!resourcePath.equals(this.gadgetPath)) {
                resourcePath = resourcePath.replace("war:", "");
                return this.gadgetRootAbsolutePath + resourcePath;
            }
            File file = new File(this.container.getPortalContext().getRealPath(resourcePath));
            return file.getAbsolutePath();
        }
        File file = new File(this.configurationManager.getURL(resourcePath).getPath());
        return file.getAbsolutePath();
    }

    private byte[] getContent(String filePath) throws IOException {
        InputStream in;
        try {
            if (!(filePath.startsWith("classpath:") || filePath.startsWith("jar:") || filePath.startsWith("war:") || filePath.startsWith("system:"))) {
                filePath = filePath.startsWith("") ? "file:" + filePath : "file:/" + filePath;
            }
            if (filePath.startsWith("war:")) {
                filePath = filePath.replace("war:", "");
                in = this.container.getPortalContext().getResourceAsStream(filePath);
            } else {
                in = this.configurationManager.getInputStream(filePath);
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (in == null) {
            return null;
        }
        return IOTools.getBytes((InputStream)in);
    }

    private String getUsedSeparator(String filePath) {
        String separator = null;
        separator = filePath.indexOf("\\") >= 0 ? "\\" : "/";
        return separator;
    }

    private Iterable<String> getChildren(String folderPath) throws IOException {
        try {
            String absoluteFolderPath = this.getRealPath(folderPath);
            File file = new File(absoluteFolderPath);
            File[] children = file.listFiles();
            ArrayList<String> childList = new ArrayList<String>();
            if (!folderPath.endsWith("/") && !folderPath.endsWith("\\")) {
                folderPath = folderPath + this.getUsedSeparator(folderPath);
            }
            for (File fileChild : children) {
                childList.add(folderPath + fileChild.getName());
            }
            return childList;
        }
        catch (Exception exception) {
            LOG.error((Object)"Exception when getting Children", (Throwable)exception);
            return null;
        }
    }

    private boolean isFile(String resourcePath) {
        Boolean isFile = null;
        try {
            File file = new File(this.getRealPath(resourcePath));
            if (file.exists()) {
                isFile = file.isFile();
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"file doesn't exist or may be the path has another format ", (Throwable)exception);
        }
        if (isFile == null) {
            return !resourcePath.endsWith("/") && !resourcePath.endsWith("\\");
        }
        return isFile;
    }

    private String getMimeType(String fileName) {
        String mimeType = URLConnection.guessContentTypeFromName(fileName);
        if (mimeType == null) {
            mimeType = this.container.getPortalContext().getMimeType(fileName);
        }
        return mimeType;
    }

    protected void processMetadata(ModulePrefs prefs, GadgetDefinition def) {
    }
}

