/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.io.InputStream;
import java.util.regex.Pattern;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.config.NewPortalConfig;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.ModelUnmarshaller;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.UnmarshalledObject;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jibx.runtime.JiBXException;

public class PlatformUpgradeUtils {
    private static final Log LOG = ExoLogger.getLogger(PlatformUpgradeUtils.class);
    private static final Pattern OWNER_PATTERN = Pattern.compile("@owner@");

    private static void fixOwnerName(PortalConfig config) {
        config.setName(PlatformUpgradeUtils.fixOwnerName(config.getType(), config.getName()));
        PlatformUpgradeUtils.fixOwnerName(config.getPortalLayout());
    }

    private static void fixOwnerName(Container container) {
        for (ModelObject o : container.getChildren()) {
            if (!(o instanceof Container)) continue;
            PlatformUpgradeUtils.fixOwnerName((Container)o);
        }
    }

    private static String fixOwnerName(String type, String owner) {
        if ((type.equals(PortalConfig.USER_TYPE) || type.equals(PortalConfig.GROUP_TYPE)) && !owner.startsWith("/")) {
            return "/" + owner;
        }
        return owner;
    }

    private static <T> UnmarshalledObject<T> fromXML(String ownerType, String owner, String xml, Class<T> clazz) throws Exception {
        UnmarshalledObject obj = ModelUnmarshaller.unmarshall(clazz, (byte[])xml.getBytes("UTF-8"));
        Object o = obj.getObject();
        if (!(o instanceof PortalConfig)) {
            throw new Exception();
        }
        PortalConfig portalConfig = (PortalConfig)o;
        portalConfig.setType(ownerType);
        portalConfig.setName(owner);
        PlatformUpgradeUtils.fixOwnerName(portalConfig);
        return obj;
    }

    private static ConfigurationManager getConfigurationManagerService() {
        ConfigurationManager configurationManager = (ConfigurationManager)PortalContainer.getInstance().getComponentInstanceOfType(ConfigurationManager.class);
        if (configurationManager != null) {
            return configurationManager;
        }
        return null;
    }

    private static String getDefaultConfig(String location, String path) {
        String s = location + path;
        String content = null;
        try {
            LOG.debug((Object)("Attempt to load file " + s));
            content = IOUtil.getStreamContentAsString((InputStream)PlatformUpgradeUtils.getConfigurationManagerService().getInputStream(s));
            LOG.debug((Object)("Loaded file from path " + s + " with content " + content));
        }
        catch (Exception ignore) {
            LOG.debug((Object)("Could not get file " + s + " will return null instead"));
        }
        return content;
    }

    private static <T> UnmarshalledObject<T> getConfig(NewPortalConfig config, String owner, String fileName, Class<T> type) throws Exception {
        LOG.debug((Object)("About to load config=" + config + " owner=" + owner + " fileName=" + fileName));
        String ownerType = config.getOwnerType();
        String path = "/" + ownerType + "/" + owner + "/" + fileName + ".xml";
        String xml = PlatformUpgradeUtils.getDefaultConfig(config.getTemplateLocation(), path);
        if (xml == null) {
            String templateName = config.getTemplateName() != null ? config.getTemplateName() : fileName;
            path = "/" + ownerType + "/template/" + templateName + "/" + fileName + ".xml";
            xml = PlatformUpgradeUtils.getDefaultConfig(config.getTemplateLocation(), path);
            if (xml != null) {
                xml = OWNER_PATTERN.matcher(xml).replaceAll(owner);
            }
        }
        if (xml != null) {
            boolean ok = false;
            try {
                UnmarshalledObject<T> o = PlatformUpgradeUtils.fromXML(config.getOwnerType(), owner, xml, type);
                ok = true;
                UnmarshalledObject<T> unmarshalledObject = o;
                return unmarshalledObject;
            }
            catch (JiBXException e) {
                LOG.error((Object)(e.getMessage() + " file: " + path), (Throwable)e);
                throw e;
            }
            finally {
                if (!ok) {
                    LOG.error((Object)("Could not load file: " + path));
                }
            }
        }
        return null;
    }

    public static PortalConfig getPortalConfigFromTemplate(String siteType, String templateName, String templatePath) {
        NewPortalConfig config = new NewPortalConfig(templatePath);
        config.setTemplateName(templateName);
        config.setOwnerType(siteType);
        UnmarshalledObject<PortalConfig> result = null;
        try {
            result = PlatformUpgradeUtils.getConfig(config, templateName, siteType, PortalConfig.class);
            if (result != null) {
                return (PortalConfig)result.getObject();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Cannot find configuration of template: " + templateName));
        }
        return null;
    }
}

