/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.MembershipEntry;

public class UserHelper {
    public static OrganizationService getOrganizationService() {
        return CommonUtils.getComponent(OrganizationService.class);
    }

    private static UserHandler getUserHandler() {
        return UserHelper.getOrganizationService().getUserHandler();
    }

    private static GroupHandler getGroupHandler() {
        return UserHelper.getOrganizationService().getGroupHandler();
    }

    public static List<Group> getAllGroup() throws Exception {
        Collection pageList = UserHelper.getGroupHandler().getAllGroups();
        ArrayList<Group> list = new ArrayList<Group>(pageList);
        return list;
    }

    public static String checkValueUser(String values) throws Exception {
        StringBuilder errorUser = new StringBuilder();
        if (values != null && values.trim().length() > 0) {
            String[] userIds;
            for (String str : userIds = values.split(",")) {
                if ((str = str.trim()).indexOf("$") >= 0) {
                    str = str.replace("$", "&#36");
                }
                if (str.indexOf("/") >= 0) {
                    if (UserHelper.hasGroupIdAndMembershipId(str)) continue;
                    if (errorUser.length() == 0) {
                        errorUser.append(str);
                        continue;
                    }
                    errorUser.append(", ").append(str);
                    continue;
                }
                if (UserHelper.getUserHandler().findUserByName(str) != null) continue;
                if (errorUser.length() == 0) {
                    errorUser.append(str);
                    continue;
                }
                errorUser.append(", ").append(str);
            }
        }
        return errorUser.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasGroupIdAndMembershipId(String str) throws Exception {
        if (str.indexOf(":") >= 0) {
            String[] array = str.split(":");
            try {
                UserHelper.getGroupHandler().findGroupById(array[1]).getId();
            }
            catch (Exception e) {
                return false;
            }
            if (array[0].length() == 1 && array[0].charAt(0) == '*') {
                return true;
            }
            if (array[0].length() <= 0) return false;
            if (UserHelper.getOrganizationService().getMembershipTypeHandler().findMembershipType(array[0]) != null) return true;
            return false;
        }
        try {
            UserHelper.getGroupHandler().findGroupById(str).getId();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasUserInGroup(String groupId, String userId) throws Exception {
        User[] users;
        ListAccess pageList = UserHelper.getUserHandler().findUsersByGroupId(groupId);
        int size = pageList.getSize();
        for (User user : users = (User[])pageList.load(0, size)) {
            if (!user.getUserName().equals(userId)) continue;
            return true;
        }
        return false;
    }

    public static User getUserByUserId(String userId) throws Exception {
        return UserHelper.getUserHandler().findUserByName(userId);
    }

    public static String[] getUserGroups() throws Exception {
        Object[] objGroupIds = UserHelper.getGroupHandler().findGroupsOfUser(UserHelper.getCurrentUser()).toArray();
        String[] groupIds = new String[objGroupIds.length];
        for (int i = 0; i < groupIds.length; ++i) {
            groupIds[i] = ((GroupImpl)objGroupIds[i]).getId();
        }
        return groupIds;
    }

    public static List<String> getAllGroupId() throws Exception {
        ArrayList<String> grIds = new ArrayList<String>();
        for (Group gr : UserHelper.getAllGroup()) {
            grIds.add(gr.getId());
        }
        return grIds;
    }

    public static List<Group> findGroups(Group group) throws Exception {
        return (List)UserHelper.getGroupHandler().findGroups(group);
    }

    public static boolean isAnonim() {
        String userId = UserHelper.getCurrentUser();
        return userId == null;
    }

    public static Collection findMembershipsByUser(String userId) {
        try {
            return UserHelper.getOrganizationService().getMembershipHandler().findMembershipsByUser(userId);
        }
        catch (Exception e) {
            return Collections.EMPTY_LIST;
        }
    }

    public static List<String> getAllGroupAndMembershipOfUser(String userId) {
        ArrayList<String> listOfUser;
        block3: {
            block2: {
                listOfUser = new ArrayList<String>();
                if (userId != null && !userId.equals(UserHelper.getCurrentUser())) break block2;
                ConversationState conversionState = ConversationState.getCurrent();
                Identity identity = conversionState.getIdentity();
                userId = identity.getUserId();
                if (userId == null) break block3;
                listOfUser.add(userId);
                for (MembershipEntry membership : identity.getMemberships()) {
                    listOfUser.add(membership.getGroup());
                    listOfUser.add(membership.getMembershipType() + ":" + membership.getGroup());
                }
                break block3;
            }
            listOfUser.add(userId);
            Collection memberships = UserHelper.findMembershipsByUser(userId);
            for (Membership membership : memberships) {
                listOfUser.add(membership.getGroupId());
                listOfUser.add(membership.getMembershipType() + ":" + membership.getGroupId());
            }
        }
        return listOfUser;
    }

    public static String getEmailUser(String userName) throws Exception {
        User user = UserHelper.getUserHandler().findUserByName(userName);
        String email = user.getEmail();
        return email;
    }

    public static String getCurrentUser() {
        try {
            ConversationState conversionState = ConversationState.getCurrent();
            Identity identity = conversionState.getIdentity();
            String userId = identity.getUserId();
            if (userId == null || IdentityConstants.ANONIM.equals(userId)) {
                return Util.getPortalRequestContext().getRemoteUser();
            }
            return userId;
        }
        catch (Exception e) {
            return null;
        }
    }
}

