/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.tika;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.tika.OggDetector;
import org.gagravarr.vorbis.VorbisComments;
import org.gagravarr.vorbis.VorbisFile;
import org.gagravarr.vorbis.VorbisInfo;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VorbisParser
extends AbstractParser {
    private static List<MediaType> TYPES = Arrays.asList(OggDetector.OGG_AUDIO, OggDetector.OGG_VORBIS);

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return new HashSet<MediaType>(TYPES);
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        metadata.set("Content-Type", OggDetector.OGG_VORBIS.toString());
        metadata.set(XMPDM.AUDIO_COMPRESSOR, "Vorbis");
        OggFile ogg = new OggFile(stream);
        VorbisFile vorbis = new VorbisFile(ogg);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        this.extractInfo(metadata, vorbis.getInfo());
        VorbisParser.extractComments(metadata, xhtml, vorbis.getComment());
        xhtml.endDocument();
    }

    protected void extractInfo(Metadata metadata, VorbisInfo info) throws TikaException {
        metadata.set(XMPDM.AUDIO_SAMPLE_RATE, (int)info.getRate());
        metadata.add("version", "Vorbis " + info.getVersion());
        VorbisParser.extractChannelInfo(metadata, info.getChannels());
    }

    protected static void extractChannelInfo(Metadata metadata, int channelCount) {
        if (channelCount == 1) {
            metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "Mono");
        } else if (channelCount == 2) {
            metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "Stereo");
        } else if (channelCount == 5) {
            metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "5.1");
        } else if (channelCount == 7) {
            metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "7.1");
        }
    }

    protected static void extractComments(Metadata metadata, XHTMLContentHandler xhtml, VorbisComments comments) throws TikaException, SAXException {
        metadata.set("title", comments.getTitle());
        metadata.set("Author", comments.getArtist());
        metadata.set(XMPDM.ARTIST, comments.getArtist());
        metadata.set(XMPDM.ALBUM, comments.getAlbum());
        metadata.set(XMPDM.GENRE, comments.getGenre());
        metadata.set(XMPDM.RELEASE_DATE, comments.getDate());
        metadata.add("vendor", comments.getVendor());
        for (String comment : comments.getComments("comment")) {
            metadata.add(XMPDM.LOG_COMMENT.getName(), comment);
        }
        List<String> done = Arrays.asList("title", "artist", "album", "genre", "date", "tracknumber", "vendor", "comment");
        for (String key : comments.getAllComments().keySet()) {
            if (done.contains(key)) continue;
            for (String value : (List)comments.getAllComments().get(key)) {
                metadata.add(key, value);
            }
        }
        xhtml.element("h1", comments.getTitle());
        xhtml.element("p", comments.getArtist());
        if (comments.getTrackNumber() != null) {
            xhtml.element("p", comments.getAlbum() + ", track " + comments.getTrackNumber());
            metadata.set(XMPDM.TRACK_NUMBER, comments.getTrackNumber());
        } else {
            xhtml.element("p", comments.getAlbum());
        }
        xhtml.element("p", comments.getDate());
        for (String comment : comments.getComments("comment")) {
            xhtml.element("p", comment);
        }
        xhtml.element("p", comments.getGenre());
    }
}

