/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.extensions.deployment;

import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.deployment.DeploymentPlugin;
import org.exoplatform.services.deployment.DeploymentUtils;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.extensions.deployment.WCMPublicationDeploymentDescriptor;
import org.exoplatform.services.wcm.publication.WCMPublicationService;

public class WCMPublicationDeploymentPlugin
extends DeploymentPlugin {
    private ConfigurationManager configurationManager;
    private RepositoryService repositoryService;
    private PublicationService publicationService;
    private WCMPublicationService wcmPublicationService;
    private static final Log LOG = ExoLogger.getLogger((String)WCMPublicationDeploymentPlugin.class.getName());
    private static final String CLEAN_PUBLICATION = "clean-publication";
    private static final String PUBLISH_FIRST_PUBLICATION = "publish-first-publication";
    private static final String KEEP_PUBLICATION = "keep-publication";

    public WCMPublicationDeploymentPlugin(InitParams initParams, ConfigurationManager configurationManager, RepositoryService repositoryService, PublicationService publicationService, WCMPublicationService wcmPublicationService) {
        super(initParams);
        this.configurationManager = configurationManager;
        this.repositoryService = repositoryService;
        this.publicationService = publicationService;
        this.wcmPublicationService = wcmPublicationService;
    }

    public void deploy(SessionProvider sessionProvider) throws Exception {
        block5: {
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Iterator iterator = this.initParams.getObjectParamIterator();
            WCMPublicationDeploymentDescriptor deploymentDescriptor = null;
            try {
                while (iterator.hasNext()) {
                    ObjectParameter objectParameter = (ObjectParameter)iterator.next();
                    deploymentDescriptor = (WCMPublicationDeploymentDescriptor)((Object)objectParameter.getObject());
                    String sourcePath = deploymentDescriptor.getSourcePath();
                    String versionHistoryPath = deploymentDescriptor.getVersionHistoryPath();
                    String cleanupPublicationType = deploymentDescriptor.getCleanupPublicationType();
                    InputStream inputStream = this.configurationManager.getInputStream(sourcePath);
                    Session session = sessionProvider.getSession(deploymentDescriptor.getTarget().getWorkspace(), repository);
                    session.importXML(deploymentDescriptor.getTarget().getNodePath(), inputStream, 0);
                    String nodeName = DeploymentUtils.getNodeName((InputStream)this.configurationManager.getInputStream(sourcePath));
                    if (CLEAN_PUBLICATION.equalsIgnoreCase(cleanupPublicationType) || PUBLISH_FIRST_PUBLICATION.equalsIgnoreCase(cleanupPublicationType)) {
                        Node parent = (Node)session.getItem(deploymentDescriptor.getTarget().getNodePath() + "/" + nodeName);
                        this.cleanPublication(parent, cleanupPublicationType, true);
                    }
                    if (versionHistoryPath != null && versionHistoryPath.length() > 0) {
                        Node currentNode = (Node)session.getItem(deploymentDescriptor.getTarget().getNodePath());
                        Map mapHistoryValue = org.exoplatform.services.deployment.Utils.getMapImportHistory((InputStream)this.configurationManager.getInputStream(versionHistoryPath));
                        org.exoplatform.services.deployment.Utils.processImportHistory((Node)currentNode, (InputStream)this.configurationManager.getInputStream(versionHistoryPath), (Map)mapHistoryValue);
                    }
                    session.save();
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)(deploymentDescriptor.getSourcePath() + " is deployed succesfully into " + deploymentDescriptor.getTarget().getNodePath()));
                }
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error((Object)("deploy " + deploymentDescriptor.getSourcePath() + " into " + deploymentDescriptor.getTarget().getNodePath() + " is FAILURE at " + new Date().toString() + "\n"), (Throwable)ex);
            }
        }
    }

    private void cleanPublication(Node node, String cleanupPublicationType, boolean updateLifecycle) throws NotInPublicationLifecycleException, Exception {
        if (node.hasProperty("publication:liveRevision") && node.hasProperty("publication:currentState")) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("\"" + node.getName() + "\" publication lifecycle has been cleaned up"));
            }
            node.setProperty("publication:liveRevision", "");
            node.setProperty("publication:currentState", "published");
        }
        node.getSession().save();
        if (updateLifecycle && PUBLISH_FIRST_PUBLICATION.equalsIgnoreCase(cleanupPublicationType) && Utils.isDocument((Node)node)) {
            if (this.publicationService.isNodeEnrolledInLifecycle(node)) {
                this.publicationService.unsubcribeLifecycle(node);
            }
            this.wcmPublicationService.updateLifecyleOnChangeContent(node, "default", "__system", "published");
            node.save();
        }
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node childNode = iter.nextNode();
            this.cleanPublication(childNode, cleanupPublicationType, false);
        }
    }
}

