/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.create;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;

public class CreateUtils {
    public static final String SPACES_GROUP = "spaces";
    public static final String CATEGORY = "category";
    private static final String FORUM_PAGE_NAGVIGATION = "forum";
    private static final String FORUM_PORTLET_NAME = "ForumPortlet";

    public static List<String> getAllPortalNames() {
        UserPortalConfigService dataStorage = (UserPortalConfigService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserPortalConfigService.class);
        try {
            return dataStorage.getAllPortalNames();
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    public static String getCurrentPortalName() {
        UIPortal uiPortal = Util.getUIPortal();
        SiteKey siteKey = uiPortal.getSiteKey();
        if (siteKey.getType() == SiteType.PORTAL) {
            return siteKey.getName();
        }
        return SiteType.GROUP.name();
    }

    private static String getType(String categoryId, String forumId, String topicId) {
        if (!CommonUtils.isEmpty((String)topicId)) {
            return Utils.TOPIC;
        }
        if (!CommonUtils.isEmpty((String)forumId)) {
            return Utils.FORUM;
        }
        if (!CommonUtils.isEmpty((String)categoryId)) {
            return CATEGORY;
        }
        return "";
    }

    private static String getObjectId(String categoryId, String forumId, String topicId) {
        if (!CommonUtils.isEmpty((String)topicId)) {
            return topicId;
        }
        if (!CommonUtils.isEmpty((String)forumId)) {
            return forumId;
        }
        if (!CommonUtils.isEmpty((String)categoryId)) {
            return categoryId;
        }
        return "";
    }

    public static String buildLink(String categoryId, String forumId, String topicId) {
        return CreateUtils.buildLink(categoryId, forumId, topicId, null);
    }

    public static String buildLink(String categoryId, String forumId, String topicId, String siteName) {
        try {
            String link = "";
            String objectType = CreateUtils.getType(categoryId, forumId, topicId);
            String objectId = CreateUtils.getObjectId(categoryId, forumId, topicId);
            if (categoryId.indexOf(SPACES_GROUP) > 0 && !objectType.equals(CATEGORY)) {
                String prefixId = Utils.FORUM_SPACE_ID_PREFIX;
                String spaceGroupId = "/".concat(SPACES_GROUP).concat("/").concat(forumId.replaceFirst(prefixId, ""));
                link = CreateUtils.buildSpaceLink(spaceGroupId, objectType, objectId);
            } else {
                PortalRequestContext prc = Util.getPortalRequestContext();
                if (!CommonUtils.isEmpty((String)siteName) && !prc.getSiteKey().getName().equals(siteName)) {
                    SiteKey siteKey = SiteKey.portal((String)siteName);
                    String nodeURI = CreateUtils.getSiteName(siteKey);
                    if (!CommonUtils.isEmpty((String)nodeURI)) {
                        String siteHomeLink = CreateUtils.getSiteHomeURL(siteName, nodeURI);
                        link = String.format("%s/%s/%s", siteHomeLink, objectType, objectId);
                    }
                } else {
                    UserNavigation userNav;
                    UserPortal userPortal = prc.getUserPortal();
                    UserNode userNode = userPortal.getNode(userNav = userPortal.getNavigation(prc.getSiteKey()), Scope.ALL, null, null);
                    UserNode forumNode = userNode.getChild(FORUM_PAGE_NAGVIGATION);
                    if (forumNode != null) {
                        String forumURI = CreateUtils.getNodeURL(forumNode);
                        link = String.format("%s/%s/%s", forumURI, objectType, objectId);
                    }
                }
            }
            return link;
        }
        catch (Exception ex) {
            return "";
        }
    }

    private static String getNodeURL(UserNode node) {
        RequestContext ctx = RequestContext.getCurrentInstance();
        NodeURL nodeURL = (NodeURL)ctx.createURL(NodeURL.TYPE);
        return nodeURL.setNode(node).toString();
    }

    public static String buildSpaceLink(String spaceGroupId, String objectType, String objectId) throws Exception {
        String nodeURI = CreateUtils.getSiteName(SiteKey.group((String)spaceGroupId));
        if (!CommonUtils.isEmpty((String)nodeURI)) {
            String spaceLink = CreateUtils.getSpaceHomeURL(spaceGroupId);
            String objectLink = String.format("%s/%s/%s/%s", spaceLink, nodeURI, objectType, objectId);
            return objectLink;
        }
        return "";
    }

    public static String getSiteName(SiteKey siteKey) {
        NavigationContext nav;
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NavigationService navService = (NavigationService)container.getComponentInstance(NavigationService.class);
        NodeContext parentNodeCtx = navService.loadNode(NodeModel.SELF_MODEL, nav = navService.loadNavigation(siteKey), Scope.ALL, null);
        if (parentNodeCtx.getSize() >= 1) {
            Collection children = parentNodeCtx.getNodes();
            if (siteKey.getType() == SiteType.GROUP) {
                children = ((NodeContext)parentNodeCtx.get(0)).getNodes();
            }
            Iterator it = children.iterator();
            NodeContext child = null;
            while (it.hasNext() && !FORUM_PAGE_NAGVIGATION.equals((child = (NodeContext)it.next()).getName()) && child.getName().indexOf(FORUM_PORTLET_NAME) < 0) {
            }
            return child.getName();
        }
        return "";
    }

    public static String getSiteHomeURL(String portalName, String nodeURI) {
        NodeURL nodeURL = (NodeURL)RequestContext.getCurrentInstance().createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.PORTAL, portalName, nodeURI);
        return nodeURL.setResource(resource).toString();
    }

    public static String getSpaceHomeURL(String spaceGroupId) {
        String permanentSpaceName = spaceGroupId.split("/")[2];
        NodeURL nodeURL = (NodeURL)RequestContext.getCurrentInstance().createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.GROUP, spaceGroupId, permanentSpaceName);
        return nodeURL.setResource(resource).toString();
    }
}

