/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.drives;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.drives.UIDriveForm;
import org.exoplatform.ecm.webui.component.admin.drives.UIDriveList;
import org.exoplatform.ecm.webui.component.admin.drives.UINodeTypeSelector;
import org.exoplatform.ecm.webui.selector.UIAnyPermission;
import org.exoplatform.ecm.webui.selector.UIPermissionSelector;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.ext.manager.UIAbstractManager;

@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UIDriveManager
extends UIAbstractManager {
    public UIDriveManager() throws Exception {
        this.addChild(UIDriveList.class, null, null);
    }

    public void refresh() throws Exception {
        this.update();
    }

    public void update() throws Exception {
        UIDriveList uiDriveList = (UIDriveList)this.getChild(UIDriveList.class);
        uiDriveList.refresh(1);
    }

    public void initPopup(String id) throws Exception {
        UIDriveForm uiDriveForm;
        UIPopupWindow uiPopup = (UIPopupWindow)this.getChildById(id);
        if (uiPopup == null) {
            uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, id);
            uiPopup.setShowMask(true);
            uiPopup.setWindowSize(590, 420);
            uiDriveForm = (UIDriveForm)this.createUIComponent(UIDriveForm.class, null, null);
        } else {
            uiDriveForm = (UIDriveForm)uiPopup.findFirstComponentOfType(UIDriveForm.class);
            uiPopup.setRendered(true);
        }
        uiPopup.setUIComponent((UIComponent)uiDriveForm);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public void initPopupPermission(String membership) throws Exception {
        this.removeChildById("PopupDrivePermission");
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "PopupDrivePermission");
        uiPopup.setShowMask(true);
        uiPopup.setWindowSize(580, 300);
        UIPermissionSelector uiECMPermission = (UIPermissionSelector)this.createUIComponent(UIPermissionSelector.class, null, "UIDrivePermissionSelector");
        uiECMPermission.setSelectedMembership(true);
        ((UIAnyPermission)uiECMPermission.getChild(UIAnyPermission.class)).setId("UIMDriveAnyPermission");
        ((UIBreadcumbs)uiECMPermission.getChild(UIBreadcumbs.class)).setId("DriveBreadcumbGroupSelector");
        ((UITree)uiECMPermission.getChild(UITree.class)).setId("UIDriveTreeGroupSelector");
        if (membership != null && membership.indexOf(":/") > -1) {
            String[] arrMember = membership.split(":/");
            uiECMPermission.setCurrentPermission("/" + arrMember[1]);
        }
        uiPopup.setUIComponent((UIComponent)uiECMPermission);
        UIDriveForm uiDriveForm = (UIDriveForm)this.findFirstComponentOfType(UIDriveForm.class);
        uiECMPermission.setSourceComponent((UIComponent)uiDriveForm, new String[]{"permissions"});
        uiPopup.setShow(true);
    }

    public void initPopupNodeTypeSelector(String nodeTypes) throws Exception {
        this.removeChildById("PopupNodeTypeSelector");
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "PopupNodeTypeSelector");
        uiPopup.setShowMask(true);
        uiPopup.setWindowSize(580, 300);
        uiPopup.setResizable(true);
        UINodeTypeSelector uiNodeTypeSelector = (UINodeTypeSelector)this.createUIComponent(UINodeTypeSelector.class, null, null);
        uiNodeTypeSelector.setRepositoryName(((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository());
        List<Object> nodeList = new ArrayList();
        if (nodeTypes != null && nodeTypes.indexOf(",") > -1) {
            nodeList = Arrays.asList(nodeTypes.split(","));
        }
        uiNodeTypeSelector.init(1, nodeList);
        uiPopup.setUIComponent((UIComponent)uiNodeTypeSelector);
        UIDriveForm uiDriveForm = (UIDriveForm)this.findFirstComponentOfType(UIDriveForm.class);
        uiNodeTypeSelector.setSourceComponent((UIComponent)uiDriveForm, new String[]{"allowNodeTypesOnTree"});
        uiPopup.setShow(true);
    }

    private String getSystemWorkspaceName() throws RepositoryException {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        return manageableRepository.getConfiguration().getSystemWorkspaceName();
    }

    public void initPopupJCRBrowser(String workspace, boolean isDisable) throws Exception {
        this.removeChildById("JCRBrowser");
        this.removeChildById("JCRBrowserAssets");
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "JCRBrowser");
        uiPopup.setShowMask(true);
        uiPopup.setWindowSize(610, 300);
        UIOneNodePathSelector uiOneNodePathSelector = (UIOneNodePathSelector)this.createUIComponent(UIOneNodePathSelector.class, null, null);
        uiOneNodePathSelector.setIsDisable(workspace, isDisable);
        uiOneNodePathSelector.setShowRootPathSelect(true);
        uiOneNodePathSelector.setRootNodeLocation(repository, workspace, "/");
        if (WCMCoreUtils.isAnonim()) {
            uiOneNodePathSelector.init(WCMCoreUtils.createAnonimProvider());
        } else if (workspace.equals(this.getSystemWorkspaceName())) {
            uiOneNodePathSelector.init(WCMCoreUtils.getSystemSessionProvider());
        } else {
            uiOneNodePathSelector.init(WCMCoreUtils.getUserSessionProvider());
        }
        uiPopup.setUIComponent((UIComponent)uiOneNodePathSelector);
        UIDriveForm uiDriveForm = (UIDriveForm)this.findFirstComponentOfType(UIDriveForm.class);
        uiOneNodePathSelector.setSourceComponent((UIComponent)uiDriveForm, new String[]{"homePath"});
        uiPopup.setShow(true);
    }

    public void initPopupJCRBrowserAssets(String workspace) throws Exception {
        this.removeChildById("JCRBrowserAssets");
        this.removeChildById("JCRBrowser");
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "JCRBrowserAssets");
        uiPopup.setShowMask(true);
        uiPopup.setWindowSize(610, 300);
        UIOneNodePathSelector uiOneNodePathSelector = (UIOneNodePathSelector)this.createUIComponent(UIOneNodePathSelector.class, null, null);
        UIDriveForm uiDriveForm = (UIDriveForm)this.findFirstComponentOfType(UIDriveForm.class);
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        uiOneNodePathSelector.setAcceptedNodeTypesInPathPanel(new String[]{"nt:file"});
        uiOneNodePathSelector.setAcceptedNodeTypesInTree(new String[]{"nt:unstructured", "nt:folder"});
        uiOneNodePathSelector.setAcceptedMimeTypes(new String[]{"image/jpeg", "image/gif", "image/png"});
        uiOneNodePathSelector.setRootNodeLocation(repository, workspace, "/");
        if (WCMCoreUtils.isAnonim()) {
            uiOneNodePathSelector.init(WCMCoreUtils.createAnonimProvider());
        } else if (workspace.equals(this.getSystemWorkspaceName())) {
            uiOneNodePathSelector.init(WCMCoreUtils.getSystemSessionProvider());
        } else {
            uiOneNodePathSelector.init(WCMCoreUtils.getUserSessionProvider());
        }
        uiOneNodePathSelector.setSourceComponent((UIComponent)uiDriveForm, new String[]{"icon"});
        uiPopup.setUIComponent((UIComponent)uiOneNodePathSelector);
        uiPopup.setShow(true);
    }
}

