/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.folksonomy;

import javax.jcr.Node;
import org.exoplatform.ecm.permission.info.UIPermissionInputSet;
import org.exoplatform.ecm.webui.component.admin.folksonomy.UIFolksonomyManager;
import org.exoplatform.ecm.webui.component.admin.folksonomy.UITagPermissionManager;
import org.exoplatform.ecm.webui.core.UIPermissionFormBase;
import org.exoplatform.ecm.webui.core.UIPermissionManagerBase;
import org.exoplatform.ecm.webui.selector.UIGroupMemberSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/admin/tags/UITagPermissionForm.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectMemberActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectUserActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddAnyActionListener.class})})
public class UITagPermissionForm
extends UIPermissionFormBase
implements UISelectable {
    public static final String TAGS_PERMISSION = "permission";
    public static final String POPUP_SELECT = "SelectUserOrGroup";
    private static final Log LOG = ExoLogger.getLogger((String)UITagPermissionForm.class.getName());

    public UITagPermissionForm() throws Exception {
        this.removeChildById(TAGS_PERMISSION);
        this.addChild((UIComponent)new UIPermissionInputSet(TAGS_PERMISSION, false));
        UIPermissionInputSet uiPerInputset = (UIPermissionInputSet)this.getChildById(TAGS_PERMISSION);
        uiPerInputset.setButtonActions(new String[]{"Add"});
        uiPerInputset.setPrimaryButtonAction("Add");
        uiPerInputset.setActionInfo("userOrGroup", new String[]{"SelectUser", "SelectMember", "AddAny"});
    }

    public void doSelect(String selectField, Object value) {
        block2: {
            try {
                this.getUIStringInput(selectField).setValue((Object)value.toString());
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
    }

    public Node getCurrentNode() throws Exception {
        return null;
    }

    public static class AddAnyActionListener
    extends EventListener<UITagPermissionForm> {
        public void execute(Event<UITagPermissionForm> event) throws Exception {
            UITagPermissionForm uiForm = (UITagPermissionForm)((Object)event.getSource());
            UIPermissionInputSet uiInputSet = (UIPermissionInputSet)uiForm.getChildById(UITagPermissionForm.TAGS_PERMISSION);
            uiInputSet.getUIStringInput("userOrGroup").setValue((Object)IdentityConstants.ANY);
            UIPopupContainer popupContainer = (UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class);
            if (popupContainer != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
            }
        }
    }

    public static class SelectUserActionListener
    extends EventListener<UITagPermissionForm> {
        public void execute(Event<UITagPermissionForm> event) throws Exception {
            UITagPermissionForm uiForm = (UITagPermissionForm)((Object)event.getSource());
            ((UIPermissionManagerBase)uiForm.getParent()).initUserSelector();
            UIPopupContainer popupContainer = (UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class);
            if (popupContainer != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
            }
        }
    }

    public static class SelectMemberActionListener
    extends EventListener<UITagPermissionForm> {
        public void execute(Event<UITagPermissionForm> event) throws Exception {
            UITagPermissionForm uiForm = (UITagPermissionForm)((Object)event.getSource());
            UIGroupMemberSelector uiGroupMemberSelector = (UIGroupMemberSelector)uiForm.createUIComponent(UIGroupMemberSelector.class, null, null);
            uiGroupMemberSelector.setSourceComponent((UIComponent)uiForm, new String[]{"userOrGroup"});
            ((UIPermissionManagerBase)uiForm.getAncestorOfType(UIPermissionManagerBase.class)).initPopupPermission((UIComponent)uiGroupMemberSelector);
            UIPopupContainer popupContainer = (UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class);
            if (popupContainer != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
            }
        }
    }

    public static class AddActionListener
    extends EventListener<UITagPermissionForm> {
        public void execute(Event<UITagPermissionForm> event) throws Exception {
            UITagPermissionForm uiForm = (UITagPermissionForm)((Object)event.getSource());
            UITagPermissionManager uiParent = (UITagPermissionManager)uiForm.getParent();
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String userOrGroup = (String)((UIPermissionInputSet)uiForm.getChild(UIPermissionInputSet.class)).getUIStringInput("userOrGroup").getValue();
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)uiForm.getApplicationComponent(NewFolksonomyService.class);
            if (Utils.isNameEmpty((String)userOrGroup)) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.userOrGroup-required", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
                UIFolksonomyManager uiContainer = (UIFolksonomyManager)uiForm.getAncestorOfType(UIFolksonomyManager.class);
                if (uiContainer != null) {
                    uiContainer.selectUITagPermissionManager();
                }
                return;
            }
            if (newFolksonomyService.getTagPermissionList().contains(userOrGroup)) {
                uiApp.addMessage(new ApplicationMessage("UITagPermissionForm.msg.userOrGroup-alreadyExists", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
                UIFolksonomyManager uiContainer = (UIFolksonomyManager)uiForm.getAncestorOfType(UIFolksonomyManager.class);
                if (uiContainer != null) {
                    uiContainer.selectUITagPermissionManager();
                }
                return;
            }
            newFolksonomyService.addTagPermission(userOrGroup);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
            ((UIFormStringInput)((UIPermissionInputSet)uiForm.getChild(UIPermissionInputSet.class)).getChild(UIFormStringInput.class)).setValue((Object)"");
        }
    }
}

