/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.seo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.seo.PageMetadataModel;
import org.exoplatform.services.seo.SEOService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.seo.UISEOToolbarPortlet;
import org.exoplatform.wcm.webui.validator.FloatNumberValidator;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/webui/seo/UISEOForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RefreshActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={UpdateActionListener.class}), @EventConfig(listeners={RemoveActionListener.class}, confirm="UISEOForm.msg.confirm-delete"), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class})})
public class UISEOForm
extends UIForm {
    public static final String TITLE = "title";
    public static final String DESCRIPTION = "description";
    public static final String KEYWORDS = "keywords";
    public static final String LANGUAGE_TYPE = "language";
    public static final String ROBOTS = "robots";
    public static final String SITEMAP = "sitemap";
    public static final String ISINHERITED = "isInherited";
    public static final String SITEMAP_VISIBLE = "sitemapvisible";
    public static final String PRIORITY = "priority";
    public static final String FREQUENCY = "frequency";
    public static final String ROBOTS_INDEX = "INDEX";
    public static final String ROBOTS_FOLLOW = "FOLLOW";
    public static final String FREQUENCY_DEFAULT_VALUE = "Always";
    String title = "";
    String description = "";
    String keywords = "";
    String priority = "";
    String frequency = "";
    String index = "";
    String follow = "";
    boolean sitemap = true;
    boolean inherited = false;
    private static String contentPath = null;
    private static String contentURI = null;
    private boolean onContent = false;
    private boolean isInherited = false;
    private ArrayList<String> paramsArray = null;
    public static List<Locale> seoLocales = null;
    public static List<String> seoLanguages = new ArrayList<String>();
    private String selectedLanguage = null;
    private String defaultLanguage = null;
    private boolean isAddNew = true;
    private static final Log LOG = ExoLogger.getLogger((String)UISEOForm.class.getName());

    public String getContentPath() {
        return contentPath;
    }

    public void setContentPath(String contentPath) {
        UISEOForm.contentPath = contentPath;
    }

    public String getContentURI() {
        return contentURI;
    }

    public void setContentURI(String contentURI) {
        UISEOForm.contentURI = contentURI;
    }

    public boolean getOnContent() {
        return this.onContent;
    }

    public void setOnContent(boolean onContent) {
        this.onContent = onContent;
    }

    public boolean getIsInherited() {
        return this.isInherited;
    }

    public void setIsInherited(boolean isInherited) {
        this.isInherited = isInherited;
    }

    public ArrayList<String> getParamsArray() {
        return this.paramsArray;
    }

    public void setSEOLanguages(ArrayList<Locale> seoLocales) {
        UISEOForm.seoLocales = seoLocales;
    }

    public List<Locale> getSEOLanguages() {
        return seoLocales;
    }

    public void setParamsArray(ArrayList<String> params) {
        this.paramsArray = params;
    }

    public String getSelectedLanguage() {
        return this.selectedLanguage;
    }

    public void setSelectedLanguage(String selectedLanguage) {
        this.selectedLanguage = selectedLanguage;
    }

    public void setIsAddNew(boolean isAddNew) {
        this.isAddNew = isAddNew;
    }

    public boolean getIsAddNew() {
        return this.isAddNew;
    }

    public UISEOForm() throws Exception {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SEOService seoService = (SEOService)container.getComponentInstanceOfType(SEOService.class);
        UIFormTextAreaInput uiTitle = new UIFormTextAreaInput(TITLE, TITLE, null);
        uiTitle.setValue((Object)this.title);
        this.addUIFormInput((UIFormInput)uiTitle);
        UIFormTextAreaInput uiDescription = new UIFormTextAreaInput(DESCRIPTION, DESCRIPTION, null);
        uiDescription.setValue((Object)this.description);
        this.addUIFormInput((UIFormInput)uiDescription);
        UIFormTextAreaInput uiKeywords = new UIFormTextAreaInput(KEYWORDS, KEYWORDS, null);
        uiKeywords.setValue((Object)this.keywords);
        this.addUIFormInput((UIFormInput)uiKeywords);
        seoLocales = seoService.getSEOLanguages(portalRequestContext.getPortalOwner(), contentPath, this.onContent);
        seoLanguages = new ArrayList<String>();
        if (seoLocales != null && seoLocales.size() > 0) {
            for (Locale locale : seoLocales) {
                StringBuffer sb = new StringBuffer();
                sb.append(locale.getLanguage());
                String country = locale.getCountry();
                if (StringUtils.isNotEmpty((String)country)) {
                    sb.append("_").append(country);
                }
                seoLanguages.add(sb.toString());
            }
        }
        if (seoLanguages != null) {
            Collections.sort(seoLanguages);
        }
        UIFormSelectBox uiSelectForm = new UIFormSelectBox(LANGUAGE_TYPE, LANGUAGE_TYPE, this.getLanguages());
        uiSelectForm.setOnChange("Refresh");
        this.defaultLanguage = portalRequestContext.getLocale().getLanguage();
        if (StringUtils.isNotEmpty((String)portalRequestContext.getLocale().getCountry())) {
            this.defaultLanguage = this.defaultLanguage + "_" + portalRequestContext.getLocale().getCountry();
        }
        this.selectedLanguage = this.defaultLanguage;
        if (seoLanguages == null || !seoLanguages.contains(this.defaultLanguage)) {
            uiSelectForm.setValue(this.defaultLanguage);
        }
        this.addUIFormInput((UIFormInput)uiSelectForm);
        if (!this.onContent) {
            ArrayList<SelectItemOption> robotIndexItemOptions = new ArrayList<SelectItemOption>();
            List robotsindexOptions = seoService.getRobotsIndexOptions();
            List robotsfollowOptions = seoService.getRobotsFollowOptions();
            List frequencyOptions = seoService.getFrequencyOptions();
            if (robotsindexOptions != null && robotsindexOptions.size() > 0) {
                for (int i = 0; i < robotsindexOptions.size(); ++i) {
                    robotIndexItemOptions.add(new SelectItemOption((Object)((String)robotsindexOptions.get(i)).toString()));
                }
            }
            UIFormSelectBox robots_index = new UIFormSelectBox(ROBOTS_INDEX, null, robotIndexItemOptions);
            if (this.index != null && this.index.length() > 0) {
                robots_index.setValue(this.index);
            } else {
                robots_index.setValue(ROBOTS_INDEX);
            }
            this.addUIFormInput((UIFormInput)robots_index);
            ArrayList<SelectItemOption> robotFollowItemOptions = new ArrayList<SelectItemOption>();
            if (robotsfollowOptions != null && robotsfollowOptions.size() > 0) {
                for (int i = 0; i < robotsfollowOptions.size(); ++i) {
                    robotFollowItemOptions.add(new SelectItemOption((Object)((String)robotsfollowOptions.get(i)).toString()));
                }
            }
            UIFormSelectBox robots_follow = new UIFormSelectBox(ROBOTS_FOLLOW, null, robotFollowItemOptions);
            if (this.follow != null && this.follow.length() > 0) {
                robots_follow.setValue(this.follow);
            } else {
                robots_follow.setValue(ROBOTS_FOLLOW);
            }
            this.addUIFormInput((UIFormInput)robots_follow);
            UICheckBoxInput visibleSitemapCheckbox = new UICheckBoxInput(SITEMAP, SITEMAP, Boolean.valueOf(this.sitemap));
            this.addUIFormInput((UIFormInput)visibleSitemapCheckbox);
            UIFormStringInput uiPrority = new UIFormStringInput(PRIORITY, null);
            if (!StringUtils.isEmpty((String)this.priority)) {
                uiPrority.setValue((Object)this.priority);
            }
            this.addUIFormInput((UIFormInput)uiPrority.addValidator(FloatNumberValidator.class, new Object[0]));
            ArrayList<SelectItemOption> frequencyItemOptions = new ArrayList<SelectItemOption>();
            if (frequencyOptions != null && frequencyOptions.size() > 0) {
                for (int i = 0; i < frequencyOptions.size(); ++i) {
                    frequencyItemOptions.add(new SelectItemOption(((String)frequencyOptions.get(i)).toString(), (Object)((String)frequencyOptions.get(i)).toString()));
                }
            }
            UIFormSelectBox frequencySelectbox = new UIFormSelectBox(FREQUENCY, null, frequencyItemOptions);
            if (this.frequency != null && this.frequency.length() > 0) {
                frequencySelectbox.setValue(this.frequency);
            } else {
                frequencySelectbox.setValue(FREQUENCY_DEFAULT_VALUE);
            }
            this.addUIFormInput((UIFormInput)frequencySelectbox);
        }
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void initSEOForm(PageMetadataModel pageModel) throws Exception {
        UIFormTextAreaInput uiKeywords;
        UIFormTextAreaInput uiDescription;
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        if (pageModel != null) {
            this.title = pageModel.getTitle();
            this.description = pageModel.getDescription();
            this.keywords = pageModel.getKeywords();
            this.frequency = pageModel.getFrequency();
            this.priority = pageModel.getPriority() >= 0.0f ? String.valueOf(pageModel.getPriority()) : null;
            if (pageModel.getRobotsContent() != null && pageModel.getRobotsContent().length() > 0) {
                this.index = pageModel.getRobotsContent().split(",")[0].trim();
                this.follow = pageModel.getRobotsContent().split(",")[1].trim();
            }
            this.sitemap = pageModel.getSitemap();
        } else {
            this.title = !this.onContent ? portalRequestContext.getTitle() : "";
            this.description = "";
            this.keywords = "";
            this.priority = "";
            this.frequency = "";
            this.index = "";
            this.follow = "";
            this.sitemap = true;
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SEOService seoService = (SEOService)container.getComponentInstanceOfType(SEOService.class);
        UIFormTextAreaInput uiTitle = this.getUIFormTextAreaInput(TITLE);
        if (uiTitle != null) {
            uiTitle.setValue((Object)this.title);
        }
        if ((uiDescription = this.getUIFormTextAreaInput(DESCRIPTION)) != null) {
            uiDescription.setValue((Object)this.description);
        }
        if ((uiKeywords = this.getUIFormTextAreaInput(KEYWORDS)) != null) {
            uiKeywords.setValue((Object)this.keywords);
        }
        UIFormSelectBox uiSelectForm = this.getUIFormSelectBox(LANGUAGE_TYPE);
        uiSelectForm.setSelectedValues(new String[]{LANGUAGE_TYPE});
        if (uiSelectForm != null) {
            List<SelectItemOption<String>> languages;
            seoLocales = seoService.getSEOLanguages(portalRequestContext.getPortalOwner(), contentPath, this.onContent);
            seoLanguages = new ArrayList<String>();
            if (seoLocales != null && seoLocales.size() > 0) {
                for (Locale locale : seoLocales) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(locale.getLanguage());
                    String country = locale.getCountry();
                    if (StringUtils.isNotEmpty((String)country)) {
                        sb.append("_").append(country);
                    }
                    seoLanguages.add(sb.toString());
                }
            }
            if (seoLanguages.size() <= 0) {
                this.setSelectedLanguage(null);
            }
            if ((languages = this.getLanguages()).size() == 1) {
                this.setIsAddNew(false);
            } else {
                this.setIsAddNew(true);
            }
            uiSelectForm.setOptions(languages);
            uiSelectForm.setValue(this.selectedLanguage);
        }
        if (!this.onContent) {
            UIFormSelectBox frequencySelectbox;
            UIFormStringInput uiPrority;
            UICheckBoxInput visibleSitemapCheckbox;
            UIFormSelectBox robots_follow;
            UIFormSelectBox robots_index;
            ArrayList<SelectItemOption> robotIndexItemOptions = new ArrayList<SelectItemOption>();
            List robotsindexOptions = seoService.getRobotsIndexOptions();
            List robotsfollowOptions = seoService.getRobotsFollowOptions();
            List frequencyOptions = seoService.getFrequencyOptions();
            if (robotsindexOptions != null && robotsindexOptions.size() > 0) {
                for (int i = 0; i < robotsindexOptions.size(); ++i) {
                    robotIndexItemOptions.add(new SelectItemOption((Object)((String)robotsindexOptions.get(i)).toString()));
                }
            }
            if ((robots_index = this.getUIFormSelectBox(ROBOTS_INDEX)) != null) {
                if (this.index != null && this.index.length() > 0) {
                    robots_index.setValue(this.index);
                } else {
                    robots_index.setValue(ROBOTS_INDEX);
                }
            }
            ArrayList<SelectItemOption> robotFollowItemOptions = new ArrayList<SelectItemOption>();
            if (robotsfollowOptions != null && robotsfollowOptions.size() > 0) {
                for (int i = 0; i < robotsfollowOptions.size(); ++i) {
                    robotFollowItemOptions.add(new SelectItemOption((Object)((String)robotsfollowOptions.get(i)).toString()));
                }
            }
            if ((robots_follow = this.getUIFormSelectBox(ROBOTS_FOLLOW)) != null) {
                if (this.follow != null && this.follow.length() > 0) {
                    robots_follow.setValue(this.follow);
                } else {
                    robots_follow.setValue(ROBOTS_FOLLOW);
                }
            }
            if ((visibleSitemapCheckbox = this.getUICheckBoxInput(SITEMAP)) != null) {
                visibleSitemapCheckbox.setChecked(this.sitemap);
            }
            if ((uiPrority = this.getUIStringInput(PRIORITY)) != null) {
                if (!StringUtils.isEmpty((String)this.priority)) {
                    uiPrority.setValue((Object)this.priority);
                } else {
                    uiPrority.setValue((Object)"");
                }
            }
            ArrayList<SelectItemOption> frequencyItemOptions = new ArrayList<SelectItemOption>();
            if (frequencyOptions != null && frequencyOptions.size() > 0) {
                for (int i = 0; i < frequencyOptions.size(); ++i) {
                    frequencyItemOptions.add(new SelectItemOption(((String)frequencyOptions.get(i)).toString(), (Object)((String)frequencyOptions.get(i)).toString()));
                }
            }
            if ((frequencySelectbox = this.getUIFormSelectBox(FREQUENCY)) != null) {
                if (this.frequency != null && this.frequency.length() > 0) {
                    frequencySelectbox.setValue(this.frequency);
                } else {
                    frequencySelectbox.setValue(FREQUENCY_DEFAULT_VALUE);
                }
            }
        }
    }

    public List<SelectItemOption<String>> getLanguages() throws Exception {
        WebuiRequestContext rc = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale inLocale = WebuiRequestContext.getCurrentInstance().getLocale();
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale());
        LocaleConfigService localService = (LocaleConfigService)WCMCoreUtils.getService(LocaleConfigService.class);
        ArrayList<SelectItemOption<String>> languages = new ArrayList<SelectItemOption<String>>();
        Iterator iter = localService.getLocalConfigs().iterator();
        ResourceBundle resourceBundle = rc.getApplicationResourceBundle();
        while (iter.hasNext()) {
            LocaleConfig localConfig = (LocaleConfig)iter.next();
            Locale locale = localConfig.getLocale();
            StringBuffer sb = new StringBuffer();
            sb.append(locale.getLanguage());
            String country = locale.getCountry();
            if (StringUtils.isNotEmpty((String)country)) {
                sb.append("_").append(country);
            }
            String lang = sb.toString();
            if (seoLanguages != null && seoLanguages.contains(lang)) continue;
            try {
                languages.add((SelectItemOption<String>)new SelectItemOption(this.CapitalFirstLetters(locale.getDisplayName(inLocale)), (Object)lang));
            }
            catch (MissingResourceException mre) {
                languages.add((SelectItemOption<String>)new SelectItemOption(lang, (Object)lang));
            }
        }
        Locale.setDefault(defaultLocale);
        Collections.sort(languages, new ItemOptionComparator());
        languages.add(0, new SelectItemOption(this.getLabel(resourceBundle, "select-language"), (Object)LANGUAGE_TYPE));
        return languages;
    }

    public String CapitalFirstLetters(String str) {
        str = Character.toString(str.charAt(0)).toUpperCase() + str.substring(1);
        return str;
    }

    class SEOItemComparator
    implements Comparator<Locale> {
        SEOItemComparator() {
        }

        @Override
        public int compare(Locale locale1, Locale locale2) {
            return locale1.getDisplayLanguage().compareTo(locale2.getDisplayLanguage());
        }
    }

    class ItemOptionComparator
    implements Comparator<SelectItemOption<String>> {
        ItemOptionComparator() {
        }

        @Override
        public int compare(SelectItemOption<String> o1, SelectItemOption<String> o2) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
    }

    public static class RemoveActionListener
    extends EventListener<UISEOForm> {
        public void execute(Event<UISEOForm> event) throws Exception {
            UISEOForm uiForm = (UISEOForm)((Object)event.getSource());
            PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
            String lang = event.getRequestContext().getRequestParameter("objectId");
            SEOService seoService = (SEOService)uiForm.getApplicationComponent(SEOService.class);
            PageMetadataModel metaModel = new PageMetadataModel();
            String pageReference = Util.getUIPortal().getSelectedUserNode().getPageRef().format();
            metaModel.setPageReference(pageReference);
            if (uiForm.onContent) {
                String contentPath;
                Node contentNode = null;
                for (int i = 0; i < uiForm.paramsArray.size() && (contentNode = seoService.getContentNode(contentPath = ((String)uiForm.paramsArray.get(i)).toString())) == null; ++i) {
                }
                if (contentNode != null) {
                    metaModel.setUri(contentNode.getUUID());
                }
            }
            String portalName = portalRequestContext.getPortalOwner();
            seoService.removePageMetadata(metaModel, portalName, uiForm.onContent, lang);
            seoLocales = seoService.getSEOLanguages(portalRequestContext.getPortalOwner(), contentPath, uiForm.onContent);
            seoLanguages = new ArrayList<String>();
            for (Locale locale : seoLocales) {
                StringBuffer sb = new StringBuffer();
                sb.append(locale.getLanguage());
                String country = locale.getCountry();
                if (StringUtils.isNotEmpty((String)country)) {
                    sb.append("_").append(country);
                }
                seoLanguages.add(sb.toString());
            }
            String laguageFocus = uiForm.defaultLanguage;
            if (seoLanguages.size() > 0 && !seoLanguages.contains(uiForm.defaultLanguage)) {
                laguageFocus = seoLanguages.get(0);
            }
            if ((metaModel = seoService.getMetadata(uiForm.paramsArray, pageReference, laguageFocus)) != null) {
                uiForm.setSelectedLanguage(laguageFocus);
            } else {
                uiForm.getUIFormSelectBox(UISEOForm.LANGUAGE_TYPE).setValue(uiForm.defaultLanguage);
            }
            uiForm.initSEOForm(metaModel);
            if (uiForm.getAncestorOfType(UISEOToolbarPortlet.class) != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UISEOToolbarPortlet.class));
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                event.getRequestContext().addUIComponentToUpdateByAjax(((UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class)).getParent());
            }
        }
    }

    public static class UpdateActionListener
    extends EventListener<UISEOForm> {
        public void execute(Event<UISEOForm> event) throws Exception {
            UISEOForm uiForm = (UISEOForm)((Object)event.getSource());
            String lang = event.getRequestContext().getRequestParameter("objectId");
            uiForm.setSelectedLanguage(lang);
            SEOService seoService = (SEOService)uiForm.getApplicationComponent(SEOService.class);
            PageMetadataModel metaModel = new PageMetadataModel();
            String pageReference = Util.getUIPortal().getSelectedUserNode().getPageRef().format();
            metaModel = seoService.getMetadata(uiForm.paramsArray, pageReference, lang);
            if (metaModel == null || metaModel != null && metaModel.getFullStatus().equals("Empty")) {
                metaModel = seoService.getMetadata(uiForm.paramsArray, pageReference, uiForm.defaultLanguage);
            }
            uiForm.initSEOForm(metaModel);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    public static class RefreshActionListener
    extends EventListener<UISEOForm> {
        public void execute(Event<UISEOForm> event) throws Exception {
            PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
            UISEOForm uiForm = (UISEOForm)((Object)event.getSource());
            String portalName = portalRequestContext.getPortalOwner();
            String lang = (String)uiForm.getUIFormSelectBox(UISEOForm.LANGUAGE_TYPE).getValue();
            if (lang.equals(UISEOForm.LANGUAGE_TYPE)) {
                return;
            }
            uiForm.setSelectedLanguage(lang);
            String pageReference = Util.getUIPortal().getSelectedUserNode().getPageRef().format();
            SEOService seoService = (SEOService)uiForm.getApplicationComponent(SEOService.class);
            PageMetadataModel seoData = new PageMetadataModel();
            PageMetadataModel metaModel = seoService.getMetadata(uiForm.paramsArray, pageReference, uiForm.defaultLanguage);
            if (metaModel == null) {
                metaModel = new PageMetadataModel();
            }
            if (uiForm.onContent) {
                seoData.setUri(uiForm.getContentURI());
                metaModel.setUri(uiForm.getContentURI());
            } else {
                seoData.setPageReference(pageReference);
                seoData.setTitle(portalRequestContext.getTitle());
                metaModel.setTitle(portalRequestContext.getTitle());
            }
            seoData.setFullStatus("Empty");
            seoService.storeMetadata(seoData, portalName, uiForm.onContent, lang);
            uiForm.initSEOForm(metaModel);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    public static class CancelActionListener
    extends EventListener<UISEOForm> {
        public void execute(Event<UISEOForm> event) throws Exception {
            UISEOForm uiSEO = (UISEOForm)((Object)event.getSource());
            UIPopupContainer uiSEOToolbar = (UIPopupContainer)uiSEO.getAncestorOfType(UIPopupContainer.class);
            if (uiSEOToolbar != null) {
                uiSEOToolbar.removeChildById("UISEOPopupWindow");
            }
        }
    }

    public static class SaveActionListener
    extends EventListener<UISEOForm> {
        public void execute(Event<UISEOForm> event) throws Exception {
            UISEOForm uiForm = (UISEOForm)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String description = (String)uiForm.getUIFormTextAreaInput(UISEOForm.DESCRIPTION).getValue();
            String keywords = (String)uiForm.getUIFormTextAreaInput(UISEOForm.KEYWORDS).getValue();
            PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
            String lang = null;
            if (uiForm.getSelectedLanguage() != null) {
                lang = uiForm.getSelectedLanguage();
            } else {
                lang = (String)uiForm.getUIFormSelectBox(UISEOForm.LANGUAGE_TYPE).getValue();
                StringBuffer sb = new StringBuffer();
                if (lang == null || lang.equals(UISEOForm.LANGUAGE_TYPE)) {
                    lang = portalRequestContext.getLocale().getLanguage();
                    sb.append(portalRequestContext.getLocale().getLanguage());
                    if (StringUtils.isNotEmpty((String)portalRequestContext.getLocale().getCountry())) {
                        sb.append("_").append(portalRequestContext.getLocale().getCountry());
                    }
                    lang = sb.toString();
                }
            }
            uiForm.setSelectedLanguage(lang);
            String portalName = portalRequestContext.getPortalOwner();
            String uri = ((NodeURL)portalRequestContext.createURL(NodeURL.TYPE, (Object)new NavigationResource(Util.getUIPortal().getSelectedUserNode()))).toString();
            String fullStatus = null;
            String pageReference = Util.getUIPortal().getSelectedUserNode().getPageRef().format();
            if (!uiForm.onContent) {
                String title = (String)uiForm.getUIFormTextAreaInput(UISEOForm.TITLE).getValue();
                String robots_index = (String)uiForm.getUIFormSelectBox(UISEOForm.ROBOTS_INDEX).getValue();
                String robots_follow = (String)uiForm.getUIFormSelectBox(UISEOForm.ROBOTS_FOLLOW).getValue();
                String rebots_content = robots_index + ", " + robots_follow;
                boolean isVisibleSitemap = uiForm.getUICheckBoxInput(UISEOForm.SITEMAP).isChecked();
                float priority = -1.0f;
                if (uiForm.getUIStringInput(UISEOForm.PRIORITY).getValue() != null && ((String)uiForm.getUIStringInput(UISEOForm.PRIORITY).getValue()).length() > 0 && ((double)(priority = Float.parseFloat((String)uiForm.getUIStringInput(UISEOForm.PRIORITY).getValue())) < 0.0 || (double)priority > 1.0)) {
                    uiApp.addMessage(new ApplicationMessage("FloatNumberValidator.msg.Invalid-number", null, 1));
                    return;
                }
                String frequency = (String)uiForm.getUIFormSelectBox(UISEOForm.FREQUENCY).getValue();
                try {
                    PageMetadataModel metaModel = new PageMetadataModel();
                    metaModel.setTitle(title);
                    metaModel.setDescription(description);
                    metaModel.setFrequency(frequency);
                    metaModel.setKeywords(keywords);
                    metaModel.setPriority(priority);
                    metaModel.setRobotsContent(rebots_content);
                    metaModel.setSiteMap(isVisibleSitemap);
                    metaModel.setUri(uri);
                    metaModel.setPageReference(pageReference);
                    fullStatus = description != null && keywords != null && priority != -1.0f ? "Full" : "Partial";
                    metaModel.setFullStatus(fullStatus);
                    SEOService seoService = (SEOService)uiForm.getApplicationComponent(SEOService.class);
                    seoService.storeMetadata(metaModel, portalName, uiForm.onContent, uiForm.getSelectedLanguage());
                    uiForm.initSEOForm(metaModel);
                    if (uiForm.getAncestorOfType(UISEOToolbarPortlet.class) != null) {
                        event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UISEOToolbarPortlet.class));
                    }
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                    event.getRequestContext().addUIComponentToUpdateByAjax(((UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class)).getParent());
                }
                catch (Exception ex) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)"Unexpected error ", (Throwable)ex);
                    }
                    uiApp.addMessage(new ApplicationMessage("UISEOForm.msg.repository-exception", null, 0));
                    return;
                }
            } else {
                try {
                    String contentPath;
                    PageMetadataModel metaModel = new PageMetadataModel();
                    metaModel.setDescription(description);
                    metaModel.setKeywords(keywords);
                    metaModel.setUri(uri);
                    metaModel.setPageReference(pageReference);
                    fullStatus = description != null && keywords != null ? "Full" : "Partial";
                    metaModel.setFullStatus(fullStatus);
                    SEOService seoService = (SEOService)uiForm.getApplicationComponent(SEOService.class);
                    Node contentNode = null;
                    for (int i = 0; i < uiForm.paramsArray.size() && (contentNode = seoService.getContentNode(contentPath = ((String)uiForm.paramsArray.get(i)).toString())) == null; ++i) {
                    }
                    metaModel.setUri(contentNode.getUUID());
                    seoService.storeMetadata(metaModel, portalName, uiForm.onContent, uiForm.getSelectedLanguage());
                    uiForm.initSEOForm(metaModel);
                    if (uiForm.getAncestorOfType(UISEOToolbarPortlet.class) != null) {
                        event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UISEOToolbarPortlet.class));
                    } else {
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                        event.getRequestContext().addUIComponentToUpdateByAjax(((UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class)).getParent());
                    }
                }
                catch (RepositoryException ex) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)"Unexpected error ", (Throwable)ex);
                    }
                    uiApp.addMessage(new ApplicationMessage("UISEOForm.msg.repository-exception", null, 0));
                    return;
                }
            }
        }
    }
}

