/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.security.GroupSecurityReference;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.UserSecurityReference;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.RightMap;
import org.xwiki.security.authorization.RuleState;
import org.xwiki.security.authorization.SecurityRule;
import org.xwiki.security.authorization.SecurityRuleEntry;
import org.xwiki.security.authorization.internal.AbstractAuthorizationSettler;
import org.xwiki.security.authorization.internal.XWikiSecurityAccess;

@Component
@Named(value="priority")
@Singleton
public class PrioritizingAuthorizationSettler
extends AbstractAuthorizationSettler {
    private static final int USER_PRIORITY = Integer.MAX_VALUE;
    private static final int ALL_GROUP_PRIORITY = 0;

    @Override
    protected XWikiSecurityAccess settle(UserSecurityReference user, Collection<GroupSecurityReference> groups, SecurityRuleEntry entry, AbstractAuthorizationSettler.Policies policies) {
        XWikiSecurityAccess access = new XWikiSecurityAccess();
        RightMap<Integer> priorities = new RightMap<Integer>();
        SecurityReference reference = entry.getReference();
        Set<Right> enabledRights = Right.getEnabledRights(reference.getSecurityType());
        for (Right right : enabledRights) {
            for (SecurityRule obj : entry.getRules()) {
                if (!obj.match(right)) continue;
                this.resolveLevel(right, user, groups, obj, access, policies, priorities);
                if (access.get(right) != RuleState.ALLOW) continue;
                this.implyRights(right, access, reference, policies, priorities);
            }
        }
        return access;
    }

    private void implyRights(Right right, XWikiSecurityAccess access, SecurityReference reference, AbstractAuthorizationSettler.Policies policies, Map<Right, Integer> priorities) {
        Set<Right> impliedRights = right.getImpliedRights();
        if (impliedRights != null) {
            for (Right enabledRight : Right.getEnabledRights(reference.getSecurityType())) {
                if (!impliedRights.contains(enabledRight)) continue;
                policies.set(enabledRight, right);
                this.resolveConflict(RuleState.ALLOW, enabledRight, access, policies, priorities.get(right), priorities);
            }
        }
    }

    private void resolveLevel(Right right, UserSecurityReference user, Collection<GroupSecurityReference> groups, SecurityRule rule, XWikiSecurityAccess access, AbstractAuthorizationSettler.Policies policies, Map<Right, Integer> priorities) {
        RuleState state = rule.getState();
        if (state == RuleState.UNDETERMINED) {
            return;
        }
        if (rule.match(user)) {
            this.resolveConflict(state, right, access, policies, Integer.MAX_VALUE, priorities);
        } else {
            for (GroupSecurityReference group : groups) {
                if (!rule.match(group)) continue;
                this.resolveConflict(state, right, access, policies, this.getPriority(group), priorities);
                break;
            }
        }
    }

    private void resolveConflict(RuleState state, Right right, XWikiSecurityAccess access, AbstractAuthorizationSettler.Policies policies, int priority, Map<Right, Integer> priorities) {
        if (access.get(right) == RuleState.UNDETERMINED) {
            access.set(right, state);
            priorities.put(right, priority);
            return;
        }
        if (access.get(right) != state) {
            if (priority > priorities.get(right)) {
                access.set(right, state);
                priorities.put(right, priority);
            } else {
                access.set(right, policies.getTieResolutionPolicy(right));
            }
        }
    }

    private int getPriority(GroupSecurityReference group) {
        if (group.getName().equals("XWikiAllGroup")) {
            return 0;
        }
        return 1;
    }
}

