/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.util.Calendar;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.Cookie;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.RequestNavInfo;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIComponent;

public class Utils {
    public static final String ACTIVITY_STREAM_TAB_SELECTED_COOKIED = "exo_social_activity_stream_tab_selected_%s";
    public static final String ACTIVITY_STREAM_VISITED_PREFIX_COOKIED = "exo_social_activity_stream_%s_visited_%s_%s";
    public static final String LAST_UPDATED_ACTIVITIES_NUM = "exo_social_last_updated_activities_num_on_%s_of_%s";
    public static final String FROM = "from";
    public static final String OLD_FROM = "old_from";
    public static final String TO = "to";
    private static final String HOME = "home";
    public static final String NOT_SEEN_ACTIVITIES_COOKIES = "exo_social_not_seen_activities_%s";
    public static final String SEEN_ACTIVITIES_COOKIES = "exo_social_seen_activities_%s";
    private static RequestNavInfo lastRequestNavData = null;
    private static RequestNavInfo currentRequestNavData = null;
    private static Log LOG = ExoLogger.getLogger(Utils.class);

    public static String getOwnerRemoteId() {
        String currentUserName = URLUtils.getCurrentUser();
        if (currentUserName == null || currentUserName.equals("")) {
            return Utils.getViewerRemoteId();
        }
        return currentUserName;
    }

    public static String getViewerRemoteId() {
        return RequestContext.getCurrentInstance().getRemoteUser();
    }

    public static boolean isOwner() {
        return Utils.getViewerRemoteId().equals(Utils.getOwnerRemoteId());
    }

    public static Identity getOwnerIdentity(boolean loadProfile) {
        return Utils.getUserIdentity(Utils.getOwnerRemoteId(), loadProfile);
    }

    public static Identity getViewerIdentity(boolean loadProfile) {
        return Utils.getUserIdentity(Utils.getViewerRemoteId(), loadProfile);
    }

    public static Identity getOwnerIdentity() {
        return Utils.getUserIdentity(Utils.getOwnerRemoteId(), false);
    }

    public static Identity getViewerIdentity() {
        return Utils.getUserIdentity(Utils.getViewerRemoteId(), false);
    }

    public static Identity getUserIdentity(String userName, boolean loadProfile) {
        return Utils.getIdentityManager().getOrCreateIdentity("organization", userName, loadProfile);
    }

    public static Identity getOwnerSpaceIdentity() {
        return Utils.getIdentityManager().getOrCreateIdentity("space", Utils.getOwnerRemoteId(), true);
    }

    public static List<Identity> getOwnerFriends() throws Exception {
        return Utils.getIdentityManager().getConnections(Utils.getOwnerIdentity());
    }

    public static List<Identity> getViewerFriends() throws Exception {
        return Utils.getIdentityManager().getConnections(Utils.getViewerIdentity());
    }

    public static void updateWorkingWorkSpace() {
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)Util.getUIPortalApplication().getChildById("UIWorkingWorkspace");
        PortalRequestContext pContext = Util.getPortalRequestContext();
        pContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        pContext.setFullRender(true);
    }

    public static final ActivityManager getActivityManager() {
        return (ActivityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ActivityManager.class);
    }

    public static final IdentityManager getIdentityManager() {
        return (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
    }

    public static final RelationshipManager getRelationshipManager() {
        return (RelationshipManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RelationshipManager.class);
    }

    public static final Relationship getRelationship(Identity identity) throws Exception {
        if (identity.equals((Object)Utils.getViewerIdentity())) {
            return null;
        }
        return Utils.getRelationshipManager().get(identity, Utils.getViewerIdentity());
    }

    public static final SpaceService getSpaceService() {
        return (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
    }

    public static final ExoRouter getExoRouter() {
        return (ExoRouter)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ExoRouter.class);
    }

    public static String getActivityID() {
        if ("activity".equals(Utils.getSelectedNode())) {
            return Utils.getValueFromRequestParam("id");
        }
        return null;
    }

    public static boolean isFocusCommentBox() {
        return "1".equals(Utils.getValueFromRequestParam("comment"));
    }

    public static boolean isExpandLikers() {
        return "1".equals(Utils.getValueFromRequestParam("likes"));
    }

    public static String getValueFromRequestParam(String param) {
        PortalRequestContext request = Util.getPortalRequestContext();
        return request.getRequest().getParameter(param);
    }

    public static void displayFeedbackMessageInline(String parentId) {
        try {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            ResourceBundle res = context.getApplicationResourceBundle();
            PortletRequestContext pContext = (PortletRequestContext)context;
            JavascriptManager jm = pContext.getJavascriptManager();
            String feedbackMessageType = Utils.getValueFromRequestParam("feedbackMessage");
            if (feedbackMessageType != null) {
                String message = res.getString("Notification.feedback.message." + feedbackMessageType);
                String userName = Utils.getValueFromRequestParam("userName");
                String spaceId = Utils.getValueFromRequestParam("spaceId");
                if (userName != null) {
                    message = message.replace("{0}", Utils.getUserIdentity(userName, false).getProfile().getFullName());
                }
                if (spaceId != null) {
                    message = message.replace("{1}", Utils.getSpaceService().getSpaceById(spaceId).getDisplayName());
                }
                message = message.replace("'", "${simpleQuote}");
                jm.require("SHARED/socialUtil", "socialUtil").addScripts("socialUtil.feedbackMessageInline('" + parentId + "','" + message + "');");
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Failed to init the feedback message");
        }
    }

    public static String getURI(String url) {
        RequestContext ctx = RequestContext.getCurrentInstance();
        NodeURL nodeURL = (NodeURL)ctx.createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.PORTAL, Util.getPortalRequestContext().getPortalOwner(), url);
        return nodeURL.setResource(resource).toString();
    }

    public static String getSelectedNode() {
        PortalRequestContext request = Util.getPortalRequestContext();
        return request.getControllerContext().getParameter(QualifiedName.parse((String)"gtn:path"));
    }

    public static String getSpaceURL(UserNode node) {
        RequestContext ctx = RequestContext.getCurrentInstance();
        NodeURL nodeURL = (NodeURL)ctx.createURL(NodeURL.TYPE);
        return nodeURL.setNode(node).toString();
    }

    public static String getSpaceHomeURL(Space space) {
        String groupId = space.getGroupId();
        String permanentSpaceName = groupId.split("/")[2];
        RequestContext ctx = RequestContext.getCurrentInstance();
        NodeURL nodeURL = (NodeURL)ctx.createURL(NodeURL.TYPE);
        NavigationResource resource = null;
        resource = permanentSpaceName.equals(space.getPrettyName()) ? new NavigationResource(SiteType.GROUP, "/spaces/" + permanentSpaceName, permanentSpaceName) : new NavigationResource(SiteType.GROUP, "/spaces/" + permanentSpaceName, space.getPrettyName());
        return nodeURL.setResource(resource).toString();
    }

    public static void setCookies(String key, String value) {
        Utils.removeCookie(key);
        PortalRequestContext request = Util.getPortalRequestContext();
        Cookie cookie = new Cookie(key, value);
        cookie.setPath(request.getRequest().getContextPath());
        cookie.setMaxAge(Integer.MAX_VALUE);
        request.getResponse().addCookie(cookie);
    }

    private static Cookie[] removeCookie(String key) {
        PortalRequestContext request = Util.getPortalRequestContext();
        Object[] cookies = request.getRequest().getCookies();
        if (cookies != null) {
            int found = -1;
            for (int i = 0; i < cookies.length; ++i) {
                if (!key.equals(cookies[i].getName())) continue;
                found = i;
                break;
            }
            if (found > -1) {
                ArrayUtils.remove((Object[])cookies, (int)found);
            }
        }
        return cookies;
    }

    public static String getCookies(String key) {
        PortalRequestContext request = Util.getPortalRequestContext();
        Cookie[] cookies = request.getRequest().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!key.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static boolean hasCookies(String key) {
        return Utils.getCookies(key) != null;
    }

    public static long getLastVisited(String key, String mode) {
        long currentVisited = Calendar.getInstance().getTimeInMillis();
        String cookieKey = String.format(ACTIVITY_STREAM_VISITED_PREFIX_COOKIED, mode, Utils.getViewerRemoteId(), key);
        String strValue = Utils.getCookies(cookieKey);
        if (strValue == null) {
            return currentVisited;
        }
        return Long.parseLong(strValue);
    }

    private static String getCookieValue(String key, String mode) {
        long currentVisited = Calendar.getInstance().getTimeInMillis();
        String cookieKey = String.format(ACTIVITY_STREAM_VISITED_PREFIX_COOKIED, mode, Utils.getViewerRemoteId(), key);
        String strValue = Utils.getCookies(cookieKey);
        if (strValue == null) {
            return "" + currentVisited;
        }
        return strValue;
    }

    public static void setLastVisited(String mode) {
        String gotTo = Utils.getCookieValue(TO, mode);
        String gotFrom = Utils.getCookieValue(FROM, mode);
        Utils.setCookie(OLD_FROM, mode, gotFrom);
        Utils.setCookie(FROM, mode, gotTo);
        long nextTo = Calendar.getInstance().getTimeInMillis();
        Utils.setCookie(TO, mode, "" + nextTo);
    }

    private static void setCookie(String key, String mode, String value) {
        String cookieKey = String.format(ACTIVITY_STREAM_VISITED_PREFIX_COOKIED, mode, Utils.getViewerRemoteId(), key);
        Utils.setCookies(cookieKey, value);
    }

    public static String listToString(List<String> list, String separator) {
        StringBuilder sb = new StringBuilder();
        int lastIdx = 0;
        for (String s : list) {
            if (s == null || s.length() == 0) continue;
            sb.append(s);
            if (++lastIdx >= list.size()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static void setCurrentNavigationData(String siteType, String siteName, String path) {
        lastRequestNavData = currentRequestNavData;
        currentRequestNavData = new RequestNavInfo(siteType, siteName, path);
    }

    public static boolean isRefreshPage() {
        if (lastRequestNavData == null || currentRequestNavData == null) {
            return false;
        }
        return lastRequestNavData.equals(currentRequestNavData);
    }

    public static boolean isHomePage() {
        String selectedNode = Utils.getSelectedNode();
        return selectedNode == null || selectedNode.length() == 0 || HOME.equals(selectedNode);
    }

    public static final String centerTrunc(String str, int head, int tail) {
        StringBuffer buf = null;
        if (str.length() <= head + tail + 7 + str.length() / 10) {
            return str;
        }
        buf = new StringBuffer();
        buf.append(str.substring(0, head)).append("...");
        buf.append(str.substring(str.length() - tail));
        return buf.toString();
    }

    public static final String trunc(String str, int head) {
        StringBuffer buf = null;
        if (str.length() <= head + 7 + str.length() / 10) {
            return str;
        }
        buf = new StringBuffer();
        buf.append(str.substring(0, head)).append("...");
        return buf.toString();
    }

    public static String normalizeString(String str) {
        if (str != null) {
            return str.trim().replaceAll("(\\s){2,}", " ");
        }
        return null;
    }

    public static boolean isSpaceContext() {
        return Utils.getSpaceByContext() != null;
    }

    public static String getSpaceUrlByContext() {
        Space space = Utils.getSpaceByContext();
        return space != null ? space.getUrl() : null;
    }

    public static void resizeHomePage() {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        JavascriptManager jm = pContext.getJavascriptManager();
        StringBuilder script = new StringBuilder("setTimeout(function() {").append("jq('.LeftNavigationTDContainer:first').css('height', 'auto');").append("jq('#UIUserActivityStreamPortlet').css('height', 'auto');").append("jq('#UIProfile').css('height', 'auto');").append("platformLeftNavigation.resize();").append("}, 200);");
        jm.require("SHARED/jquery", "jq").require("SHARED/platform-left-navigation", "platformLeftNavigation").addScripts(script.toString());
    }

    public static void initUserProfilePopup(String uiActivityId) {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        JavascriptManager jm = pContext.getJavascriptManager();
        jm.require("SHARED/social-ui-profile", "profile").addScripts("profile.initUserProfilePopup('" + uiActivityId + "', null);");
    }

    public static void clearUserProfilePopup() {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        JavascriptManager jm = pContext.getJavascriptManager();
        jm.require("SHARED/social-ui-profile", "profile").addScripts("profile.clearUserProfilePopup();");
    }

    public static Space getSpaceByContext() {
        SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String requestPath = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        ExoRouter.Route route = ExoRouter.route((String)requestPath);
        if (route == null) {
            String groupId = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_SITE_NAME);
            return spaceService.getSpaceByGroupId(groupId);
        }
        String spacePrettyName = (String)route.localArgs.get("spacePrettyName");
        Space space = spaceService.getSpaceByPrettyName(spacePrettyName);
        if (space == null) {
            String groupId = String.format("%s/%s", "/spaces", spacePrettyName);
            space = spaceService.getSpaceByGroupId(groupId);
        }
        return space;
    }

    public static void clearCacheOnUserPopup() {
        WebuiRequestContext reqContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        JavascriptManager jm = reqContext.getJavascriptManager();
        jm.require("SHARED/jquery", "jq").addScripts("(function($) { $('#socialUsersData').data('CacheSearch', {}); })(jq);");
    }

    public static String appRes(String msgKey) {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        try {
            return context.getApplicationResourceBundle().getString(msgKey);
        }
        catch (MissingResourceException ex) {
            if (PropertyManager.isDevelopping()) {
                LOG.warn((Object)("Can not find resource bundle for key : " + msgKey));
            }
            return null;
        }
    }
}

