/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.activity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.processor.I18NActivityProcessor;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;
import org.exoplatform.social.webui.space.UISpaceActivitiesDisplay;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormTextAreaInput;

public class BaseUIActivity
extends UIForm {
    private static final Log LOG = ExoLogger.getLogger(BaseUIActivity.class);
    private static int LATEST_COMMENTS_SIZE = 2;
    private int commentMinCharactersAllowed = 0;
    private int commentMaxCharactersAllowed = 100;
    private static final int DEFAULT_LIMIT = 10;
    protected static final int LIKES_NUM_DEFAULT = 0;
    private int loadCapacity;
    private int currentLoadIndex = 0;
    private RealtimeListAccess<ExoSocialActivity> activityCommentsListAccess;
    private ExoSocialActivity activity;
    private List<ExoSocialActivity> comments;
    private Identity ownerIdentity;
    private String[] identityLikes;
    private boolean commentFormDisplayed = false;
    private boolean allLoaded = false;
    private CommentStatus commentListStatus = CommentStatus.LATEST;
    private boolean allCommentsHidden = false;
    private boolean commentFormFocused = false;
    private static final String HTML_ATTRIBUTE_TITLE = "title";

    public BaseUIActivity() {
        this.setSubmitAction("return false;");
        this.comments = new ArrayList<ExoSocialActivity>();
    }

    public RealtimeListAccess<ExoSocialActivity> getActivityCommentsListAccess() {
        return this.activityCommentsListAccess;
    }

    public void setActivityCommentsListAccess(RealtimeListAccess<ExoSocialActivity> activityCommentsListAccess) {
        this.activityCommentsListAccess = activityCommentsListAccess;
    }

    public int getCurrentLoadIndex() {
        return this.currentLoadIndex;
    }

    public int getLoadCapacity() {
        return this.loadCapacity;
    }

    public void setLoadCapacity(int loadCapacity) {
        this.loadCapacity = loadCapacity;
    }

    public void setActivity(ExoSocialActivity activity) {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle resourceBundle = requestContext.getApplicationResourceBundle();
        this.activity = activity;
        Identity identity = Utils.getIdentityManager().getIdentity(activity.getUserId(), true);
        this.setOwnerIdentity(identity);
        UIFormTextAreaInput commentTextArea = new UIFormTextAreaInput("CommentTextarea" + activity.getId(), "CommentTextarea", null);
        commentTextArea.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("BaseUIActivity.label.Add_your_comment"));
        this.addChild((UIComponent)commentTextArea);
        try {
            this.refresh();
        }
        catch (ActivityStorageException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public ExoSocialActivity getActivity() {
        return this.activity;
    }

    public void setCommentMinCharactersAllowed(int num) {
        this.commentMinCharactersAllowed = num;
    }

    public int getCommentMinCharactersAllowed() {
        return this.commentMinCharactersAllowed;
    }

    public void setCommentMaxCharactersAllowed(int num) {
        this.commentMaxCharactersAllowed = num;
    }

    public int getCommentMaxCharactersAllowed() {
        return this.commentMaxCharactersAllowed;
    }

    public void setCommentFormDisplayed(boolean commentFormDisplayed) {
        this.commentFormDisplayed = commentFormDisplayed;
    }

    public boolean isCommentFormDisplayed() {
        return this.commentFormDisplayed;
    }

    public boolean isAllLoaded() {
        return this.allLoaded;
    }

    public void setAllLoaded(boolean allLoaded) {
        this.allLoaded = allLoaded;
    }

    public void setAllCommentsHidden(boolean allCommentsHidden) {
        this.allCommentsHidden = allCommentsHidden;
    }

    public boolean isAllCommentsHidden() {
        return this.allCommentsHidden;
    }

    public void setCommentFormFocused(boolean commentFormFocused) {
        this.commentFormFocused = commentFormFocused;
    }

    public boolean isCommentFormFocused() {
        return this.commentFormFocused;
    }

    public void setCommentListStatus(CommentStatus status) {
        this.commentListStatus = status;
        if (status == CommentStatus.ALL) {
            this.commentFormDisplayed = true;
        }
    }

    public CommentStatus getCommentListStatus() {
        return this.commentListStatus;
    }

    public boolean commentListToggleable() {
        return this.comments.size() > LATEST_COMMENTS_SIZE;
    }

    public List<ExoSocialActivity> getComments() {
        int commentsSize = this.activityCommentsListAccess.getSize();
        List comments = new ArrayList();
        if (this.commentListStatus == CommentStatus.ALL) {
            if (this.currentLoadIndex == 0) {
                this.currentLoadIndex = commentsSize - 10 - LATEST_COMMENTS_SIZE;
                this.loadCapacity = 10 + LATEST_COMMENTS_SIZE;
            } else {
                this.currentLoadIndex -= 10;
            }
            if (this.currentLoadIndex < 0) {
                this.currentLoadIndex = 0;
            }
            comments = this.activityCommentsListAccess.loadAsList(this.currentLoadIndex, this.loadCapacity);
            if (this.currentLoadIndex > 0) {
                this.loadCapacity += this.currentLoadIndex;
            }
        } else {
            if (this.commentListStatus == CommentStatus.NONE) {
                return comments != null ? comments : new ArrayList();
            }
            comments = commentsSize > LATEST_COMMENTS_SIZE ? this.activityCommentsListAccess.loadAsList(commentsSize - LATEST_COMMENTS_SIZE, LATEST_COMMENTS_SIZE) : this.activityCommentsListAccess.loadAsList(0, commentsSize >= 10 ? 10 : commentsSize);
        }
        return this.getI18N(comments);
    }

    public List<ExoSocialActivity> getAllComments() {
        return this.activityCommentsListAccess.loadAsList(0, this.activityCommentsListAccess.getSize());
    }

    public String[] getIdentityLikes() {
        return this.identityLikes;
    }

    public String[] getDisplayedIdentityLikes() throws Exception {
        List<String> likes = Arrays.asList(this.identityLikes);
        Collections.reverse(likes);
        this.identityLikes = (String[])likes.toArray();
        return this.identityLikes;
    }

    public void setIdenityLikes(String[] identityLikes) {
        this.identityLikes = identityLikes;
    }

    public String event(String actionName, String callback, boolean updateForm) throws Exception {
        if (updateForm) {
            return super.url(actionName);
        }
        StringBuilder b = new StringBuilder();
        b.append("javascript:eXo.webui.UIForm.submitForm('").append(this.getFormId()).append("','");
        b.append(actionName).append("',");
        b.append("true").append(",");
        b.append(callback).append(")");
        return b.toString();
    }

    public String getPostedTimeString(WebuiBindingContext resourceBundle, long postedTime) throws Exception {
        long time = (new Date().getTime() - postedTime) / 1000L;
        if (time < 60L) {
            return resourceBundle.appRes("UIActivity.label.Less_Than_A_Minute");
        }
        if (time < 120L) {
            return resourceBundle.appRes("UIActivity.label.About_A_Minute");
        }
        if (time < 3600L) {
            long value = Math.round(time / 60L);
            return resourceBundle.appRes("UIActivity.label.About_?_Minutes").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 7200L) {
            return resourceBundle.appRes("UIActivity.label.About_An_Hour");
        }
        if (time < 86400L) {
            long value = Math.round(time / 3600L);
            return resourceBundle.appRes("UIActivity.label.About_?_Hours").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 172800L) {
            return resourceBundle.appRes("UIActivity.label.About_A_Day");
        }
        if (time < 2592000L) {
            long value = Math.round(time / 86400L);
            return resourceBundle.appRes("UIActivity.label.About_?_Days").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 5184000L) {
            return resourceBundle.appRes("UIActivity.label.About_A_Month");
        }
        long value = Math.round(time / 2592000L);
        return resourceBundle.appRes("UIActivity.label.About_?_Months").replaceFirst("\\{0\\}", String.valueOf(value));
    }

    public String getPostedTimeInSpaceString(WebuiBindingContext resourceBundle, long postedTime) throws Exception {
        long time = (new Date().getTime() - postedTime) / 1000L;
        if (time < 60L) {
            return resourceBundle.appRes("UIActivity.label.Less_Than_A_Minute_In_Space");
        }
        if (time < 120L) {
            return resourceBundle.appRes("UIActivity.label.About_A_Minute_In_Space");
        }
        if (time < 3600L) {
            long value = Math.round(time / 60L);
            return resourceBundle.appRes("UIActivity.label.About_?_Minutes_In_Space").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 7200L) {
            return resourceBundle.appRes("UIActivity.label.About_An_Hour_In_Space");
        }
        if (time < 86400L) {
            long value = Math.round(time / 3600L);
            return resourceBundle.appRes("UIActivity.label.About_?_Hours_In_Space").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 172800L) {
            return resourceBundle.appRes("UIActivity.label.About_A_Day_In_Space");
        }
        if (time < 2592000L) {
            long value = Math.round(time / 86400L);
            return resourceBundle.appRes("UIActivity.label.About_?_Days_In_Space").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 5184000L) {
            return resourceBundle.appRes("UIActivity.label.About_A_Month_In_Space");
        }
        long value = Math.round(time / 2592000L);
        return resourceBundle.appRes("UIActivity.label.About_?_Months_In_Space").replaceFirst("\\{0\\}", String.valueOf(value));
    }

    private String getFormId() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (context instanceof PortletRequestContext) {
            return ((PortletRequestContext)context).getWindowId() + "#" + this.getId();
        }
        return this.getId();
    }

    protected void saveComment(String remoteUser, String message) throws Exception {
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl(Utils.getViewerIdentity().getId(), "exosocial:spaces", message, null);
        Utils.getActivityManager().saveComment(this.getActivity(), (ExoSocialActivity)comment);
        this.activityCommentsListAccess = Utils.getActivityManager().getCommentsWithListAccess(this.getActivity());
        this.comments = this.activityCommentsListAccess.loadAsList(0, 10);
        this.currentLoadIndex = 0;
        this.setCommentListStatus(CommentStatus.ALL);
    }

    protected void setLike(boolean isLiked) throws Exception {
        Identity viewerIdentity = Utils.getViewerIdentity();
        this.activity.setBody(null);
        this.activity.setTitle(null);
        if (isLiked) {
            Utils.getActivityManager().saveLike(this.activity, viewerIdentity);
        } else {
            Utils.getActivityManager().deleteLike(this.activity, viewerIdentity);
        }
        this.activity = Utils.getActivityManager().getActivity(this.activity.getId());
        this.setIdenityLikes(this.activity.getLikeIdentityIds());
        this.activity = this.getI18N(this.activity);
    }

    public boolean isLiked() throws Exception {
        return ArrayUtils.contains((Object[])this.identityLikes, (Object)Utils.getViewerIdentity().getId());
    }

    protected void refresh() throws ActivityStorageException {
        this.activity = Utils.getActivityManager().getActivity(this.activity.getId());
        this.activity = this.getI18N(this.activity);
        if (this.activity == null) {
            LOG.info((Object)"activity is null, not found. It can be deleted!");
            return;
        }
        this.activityCommentsListAccess = Utils.getActivityManager().getCommentsWithListAccess(this.activity);
        this.comments = this.activityCommentsListAccess.loadAsList(0, 10);
        this.comments = this.getI18N(this.comments);
        this.identityLikes = this.activity.getLikeIdentityIds();
        this.initSingleActivity();
    }

    private void initSingleActivity() {
        UIActivitiesContainer uiActivitiesContainer = (UIActivitiesContainer)this.getAncestorOfType(UIActivitiesContainer.class);
        UIComposer.PostContext postContext = uiActivitiesContainer.getPostContext();
        if (postContext == UIComposer.PostContext.SINGLE) {
            if (!Utils.isExpandLikers() && !Utils.isFocusCommentBox()) {
                this.setCommentListStatus(CommentStatus.ALL);
            } else {
                this.setCommentListStatus(CommentStatus.LATEST);
            }
        }
    }

    public boolean isUserActivity() {
        boolean isUserActivity = false;
        if (this.getOwnerIdentity() != null) {
            isUserActivity = this.getOwnerIdentity().getProviderId().equals("organization");
        }
        return isUserActivity;
    }

    public boolean isSpaceActivity() {
        boolean isSpaceActivity = false;
        if (this.getOwnerIdentity() != null) {
            isSpaceActivity = this.getOwnerIdentity().getProviderId().equals("space");
        }
        return isSpaceActivity;
    }

    public boolean isActivityDeletable() throws SpaceException {
        UIActivitiesContainer uiActivitiesContainer = (UIActivitiesContainer)this.getAncestorOfType(UIActivitiesContainer.class);
        UIComposer.PostContext postContext = uiActivitiesContainer.getPostContext();
        SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        if (Utils.getViewerIdentity().equals((Object)this.getOwnerIdentity())) {
            return true;
        }
        Space space = null;
        if (postContext == UIComposer.PostContext.SPACE) {
            space = uiActivitiesContainer.getSpace();
        } else {
            Identity identityStreamOwner = Utils.getIdentityManager().getOrCreateIdentity("space", this.getActivity().getStreamOwner(), false);
            if (identityStreamOwner != null) {
                space = spaceService.getSpaceByPrettyName(identityStreamOwner.getRemoteId());
            }
        }
        if (space != null) {
            return spaceService.isManager(space, Utils.getOwnerRemoteId());
        }
        return false;
    }

    public boolean isActivityCommentAndLikable() throws Exception {
        UIActivitiesContainer uiActivitiesContainer = (UIActivitiesContainer)this.getAncestorOfType(UIActivitiesContainer.class);
        UIComposer.PostContext postContext = uiActivitiesContainer.getPostContext();
        if (postContext == UIComposer.PostContext.USER) {
            return true;
        }
        return true;
    }

    public boolean isActivityCommentable() throws Exception {
        UIUserActivitiesDisplay uiUserActivitiesDisplay;
        UIActivitiesContainer uiActivitiesContainer = (UIActivitiesContainer)this.getAncestorOfType(UIActivitiesContainer.class);
        UIComposer.PostContext postContext = uiActivitiesContainer.getPostContext();
        if (this.getActivity().isLocked()) {
            return false;
        }
        if (postContext == UIComposer.PostContext.USER && (uiUserActivitiesDisplay = (UIUserActivitiesDisplay)this.getAncestorOfType(UIUserActivitiesDisplay.class)) != null && !uiUserActivitiesDisplay.isActivityStreamOwner()) {
            String ownerName = uiUserActivitiesDisplay.getOwnerName();
            Identity ownerIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", ownerName, false);
            Relationship relationship = Utils.getRelationshipManager().get(ownerIdentity, Utils.getViewerIdentity());
            if (relationship == null) {
                return false;
            }
            if (relationship.getStatus() != Relationship.Type.CONFIRMED) {
                return false;
            }
        }
        return true;
    }

    public boolean isCommentDeletable(String activityUserId) throws SpaceException {
        UIActivitiesContainer uiActivitiesContainer = (UIActivitiesContainer)this.getAncestorOfType(UIActivitiesContainer.class);
        UIComposer.PostContext postContext = uiActivitiesContainer.getPostContext();
        try {
            if (Utils.getViewerIdentity().getId().equals(activityUserId)) {
                return true;
            }
            if (postContext == UIComposer.PostContext.SPACE) {
                Space space = uiActivitiesContainer.getSpace();
                SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
                return spaceService.isManager(space, Utils.getOwnerRemoteId());
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("can't not get remoteUserIdentity: remoteUser = " + Utils.getViewerRemoteId()));
        }
        return false;
    }

    public void setOwnerIdentity(Identity ownerIdentity) {
        this.ownerIdentity = ownerIdentity;
    }

    public Identity getOwnerIdentity() {
        return this.ownerIdentity;
    }

    public Identity getSpaceCreatorIdentity() {
        if ("space".equals(this.ownerIdentity.getProviderId())) {
            SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
            Space space = spaceService.getSpaceByPrettyName(this.ownerIdentity.getRemoteId());
            String[] managers = space.getManagers();
            return Utils.getIdentityManager().getOrCreateIdentity("organization", managers[0], false);
        }
        return null;
    }

    protected boolean isSpaceStreamOwner() {
        return this.getActivity().getActivityStream().getType().name().equalsIgnoreCase("space");
    }

    protected boolean isUISpaceActivitiesDisplay() {
        return this.getParent().getParent().getParent() instanceof UISpaceActivitiesDisplay;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        try {
            super.processRender(context);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected boolean isNoLongerExisting(String activityId, Event<BaseUIActivity> event) {
        ExoSocialActivity existingActivity = Utils.getActivityManager().getActivity(activityId);
        if (existingActivity == null) {
            UIApplication uiApplication = event.getRequestContext().getUIApplication();
            uiApplication.addMessage(new ApplicationMessage("BaseUIActivity.msg.info.Activity_No_Longer_Exist", null, 2));
            return true;
        }
        return false;
    }

    protected ExoSocialActivity getI18N(ExoSocialActivity activity) {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        I18NActivityProcessor i18NActivityProcessor = (I18NActivityProcessor)this.getApplicationComponent(I18NActivityProcessor.class);
        if (activity.getTitleId() != null) {
            Locale userLocale = requestContext.getLocale();
            activity = i18NActivityProcessor.process(activity, userLocale);
        }
        return activity;
    }

    private List<ExoSocialActivity> getI18N(List<ExoSocialActivity> comments) {
        ArrayList<ExoSocialActivity> cmts = new ArrayList<ExoSocialActivity>();
        for (ExoSocialActivity cmt : comments) {
            cmts.add(this.getI18N(cmt));
        }
        return cmts;
    }

    public static class DeleteCommentActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            String activityId = uiActivity.getActivity().getId();
            String commentId = event.getRequestContext().getRequestParameter("objectId");
            if (uiActivity.isNoLongerExisting(activityId, event) || uiActivity.isNoLongerExisting(commentId, event)) {
                return;
            }
            WebuiRequestContext requestContext = event.getRequestContext();
            Utils.getActivityManager().deleteComment(uiActivity.getActivity().getId(), requestContext.getRequestParameter("objectId"));
            uiActivity.refresh();
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            Utils.initUserProfilePopup(uiActivity.getId());
            Utils.resizeHomePage();
        }
    }

    public static class DeleteActivityActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            String activityId;
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            if (uiActivity.isNoLongerExisting(activityId = uiActivity.getActivity().getId(), event)) {
                return;
            }
            Utils.getActivityManager().deleteActivity(activityId);
            UIActivitiesContainer activitiesContainer = (UIActivitiesContainer)uiActivity.getParent();
            activitiesContainer.removeChildById(uiActivity.getId());
            activitiesContainer.removeActivity(uiActivity.getActivity());
            if (activitiesContainer.getActivityList().size() == 0) {
                event.getRequestContext().addUIComponentToUpdateByAjax(activitiesContainer.getParent().getParent());
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(activitiesContainer.getParent());
            }
            Utils.clearUserProfilePopup();
            Utils.resizeHomePage();
        }
    }

    public static class PostCommentActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            String activityId;
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            if (uiActivity.isNoLongerExisting(activityId = uiActivity.getActivity().getId(), event)) {
                return;
            }
            uiActivity.refresh();
            WebuiRequestContext requestContext = event.getRequestContext();
            UIFormTextAreaInput uiFormComment = (UIFormTextAreaInput)uiActivity.getChild(UIFormTextAreaInput.class);
            String message = (String)uiFormComment.getValue();
            if (message == null || message.equals("")) {
                UIApplication uiApplication = requestContext.getUIApplication();
                uiApplication.addMessage(new ApplicationMessage("UIComposer.msg.error.Empty_Message", null, 1));
                return;
            }
            uiFormComment.reset();
            uiActivity.saveComment(requestContext.getRemoteUser(), message);
            uiActivity.setCommentFormFocused(true);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            Utils.initUserProfilePopup(uiActivity.getId());
            Utils.resizeHomePage();
            uiActivity.getParent().broadcast(event, event.getExecutionPhase());
        }
    }

    public static class ToggleDisplayCommentFormActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            if (uiActivity.isCommentFormDisplayed()) {
                uiActivity.setCommentFormDisplayed(false);
            } else {
                uiActivity.setCommentFormDisplayed(true);
            }
            Utils.initUserProfilePopup(uiActivity.getId());
            Utils.resizeHomePage();
        }
    }

    public static class SetCommentListStatusActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            String activityId;
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            if (uiActivity.isNoLongerExisting(activityId = uiActivity.getActivity().getId(), event)) {
                return;
            }
            uiActivity.refresh();
            String status = event.getRequestContext().getRequestParameter("objectId");
            CommentStatus commentListStatus = null;
            if (status.equals(CommentStatus.LATEST.getStatus())) {
                commentListStatus = CommentStatus.LATEST;
            } else if (status.equals(CommentStatus.ALL.getStatus())) {
                commentListStatus = CommentStatus.ALL;
            } else if (status.equals(CommentStatus.NONE.getStatus())) {
                commentListStatus = CommentStatus.NONE;
            }
            if (commentListStatus != null) {
                uiActivity.setCommentListStatus(commentListStatus);
            }
            uiActivity.setCommentFormDisplayed(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            String inputContainerId = "InputContainer" + activityId;
            StringBuffer script = new StringBuffer("(function($) {");
            script.append("var inputContainer = $('#").append(inputContainerId).append("');");
            script.append("inputContainer.addClass('inputContainerShow').show();");
            script.append("})(jq);");
            JavascriptManager jm = event.getRequestContext().getJavascriptManager();
            Utils.initUserProfilePopup(uiActivity.getId());
            Utils.resizeHomePage();
            jm.require("SHARED/jquery", "jq").addScripts(script.toString());
        }
    }

    public static class LikeActivityActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            String activityId;
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            if (uiActivity.isNoLongerExisting(activityId = uiActivity.getActivity().getId(), event)) {
                return;
            }
            uiActivity.refresh();
            WebuiRequestContext requestContext = event.getRequestContext();
            String isLikedStr = requestContext.getRequestParameter("objectId");
            uiActivity.setLike(Boolean.parseBoolean(isLikedStr));
            JavascriptManager jm = requestContext.getJavascriptManager();
            jm.require("SHARED/social-ui-activity", "activity").addScripts("activity.displayLike('#ContextBox" + activityId + "');");
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            Utils.initUserProfilePopup(uiActivity.getId());
            Utils.resizeHomePage();
        }
    }

    public static class LoadLikesActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            String activityId;
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            if (uiActivity.isNoLongerExisting(activityId = uiActivity.getActivity().getId(), event)) {
                return;
            }
            uiActivity.setAllLoaded(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            JavascriptManager jm = event.getRequestContext().getJavascriptManager();
            jm.require("SHARED/social-ui-activity", "activity").addScripts("activity.loadLikes('#ContextBox" + activityId + "');");
            Utils.initUserProfilePopup(uiActivity.getId());
            Utils.resizeHomePage();
        }
    }

    public static enum CommentStatus {
        LATEST("latest"),
        ALL("all"),
        NONE("none");

        private String commentStatus;

        public String getStatus() {
            return this.commentStatus;
        }

        private CommentStatus(String status) {
            this.commentStatus = status;
        }
    }
}

