/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.i18n;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.portal.mop.i18n.I18Nized;
import org.exoplatform.portal.mop.i18n.Resolution;
import org.gatein.mop.api.workspace.WorkspaceObject;
import org.gatein.mop.spi.AdapterLifeCycle;

public class I18NAdapter {
    private final WorkspaceObject obj;

    private I18NAdapter(WorkspaceObject obj) {
        this.obj = obj;
    }

    public <M> M getMixin(Class<M> mixinType, boolean create) throws NullPointerException {
        if (mixinType == null) {
            throw new NullPointerException("No null mixin type accepted");
        }
        if (this.obj.isAdapted(mixinType) || create) {
            return (M)this.obj.adapt(mixinType);
        }
        return null;
    }

    public <M> void removeMixin(Class<M> mixinType) throws NullPointerException {
        if (mixinType == null) {
            throw new NullPointerException("No null mixin type accepted");
        }
        if (this.obj.isAdapted(mixinType)) {
            this.obj.removeAdapter(mixinType);
        }
    }

    public <M> Resolution<M> resolveI18NMixin(Class<M> mixinType, Locale locale) throws NullPointerException {
        if (mixinType == null) {
            throw new NullPointerException("No null mixin type accepted");
        }
        if (locale == null) {
            throw new NullPointerException("No null locale accepted");
        }
        if (locale.getLanguage().length() > 0 && this.obj.isAdapted(I18Nized.class)) {
            I18Nized ized = (I18Nized)this.obj.adapt(I18Nized.class);
            return ized.resolveMixin(mixinType, locale);
        }
        return null;
    }

    public <M> M getI18NMixin(Class<M> mixinType, Locale locale, boolean create) throws NullPointerException, IllegalArgumentException {
        if (mixinType == null) {
            throw new NullPointerException("No null mixin type accepted");
        }
        if (locale == null) {
            throw new NullPointerException("No null locale accepted");
        }
        if (this.obj.isAdapted(I18Nized.class)) {
            I18Nized ized = (I18Nized)this.obj.adapt(I18Nized.class);
            return ized.getMixin(mixinType, locale, create);
        }
        if (create) {
            I18Nized ized = (I18Nized)this.obj.adapt(I18Nized.class);
            return ized.getMixin(mixinType, locale, true);
        }
        return null;
    }

    public <M> Map<Locale, M> getI18NMixin(Class<M> mixinType) throws NullPointerException {
        if (mixinType == null) {
            throw new NullPointerException("No null mixin type accepted");
        }
        if (this.obj.isAdapted(I18Nized.class)) {
            I18Nized ized = (I18Nized)this.obj.adapt(I18Nized.class);
            return ized.getMixins(mixinType);
        }
        return null;
    }

    public <M> M addI18NMixin(Class<M> mixinType, Locale locale) throws NullPointerException, IllegalArgumentException {
        if (mixinType == null) {
            throw new NullPointerException("No null mixin type accepted");
        }
        if (locale == null) {
            throw new NullPointerException("No null locale accepted");
        }
        I18Nized ized = this.obj.isAdapted(I18Nized.class) ? (I18Nized)this.obj.adapt(I18Nized.class) : (I18Nized)this.obj.adapt(I18Nized.class);
        return ized.getMixin(mixinType, locale, true);
    }

    public <M> Collection<Locale> removeI18NMixin(Class<M> mixinType) {
        if (mixinType == null) {
            throw new NullPointerException("No null mixin type accepted");
        }
        if (this.obj.isAdapted(I18Nized.class)) {
            I18Nized ized = (I18Nized)this.obj.adapt(I18Nized.class);
            return ized.removeMixin(mixinType);
        }
        return Collections.emptyList();
    }

    public static class LifeCycle
    extends AdapterLifeCycle<WorkspaceObject, I18NAdapter> {
        public I18NAdapter create(WorkspaceObject adaptee, Class<I18NAdapter> adapterType) {
            return new I18NAdapter(adaptee);
        }

        public void destroy(I18NAdapter adapter, WorkspaceObject adaptee, Class<I18NAdapter> adapterType) {
        }
    }
}

