/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.operations;

import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Site;

public class Utils {
    private Utils() {
    }

    public static ObjectType<Site> getObjectType(SiteType siteType) {
        switch (siteType) {
            case PORTAL: {
                return ObjectType.PORTAL_SITE;
            }
            case GROUP: {
                return ObjectType.GROUP_SITE;
            }
            case USER: {
                return ObjectType.USER_SITE;
            }
        }
        return null;
    }

    public static SiteType getSiteType(ObjectType<? extends Site> objectType) {
        if (ObjectType.PORTAL_SITE == objectType) {
            return SiteType.PORTAL;
        }
        if (ObjectType.GROUP_SITE == objectType) {
            return SiteType.GROUP;
        }
        if (ObjectType.USER_SITE == objectType) {
            return SiteType.USER;
        }
        return null;
    }

    public static SiteType getSiteType(String siteType) {
        if (siteType == null) {
            return null;
        }
        return SiteType.valueOf(siteType.toUpperCase());
    }

    public static SiteKey siteKey(String siteType, String siteName) {
        SiteType st = Utils.getSiteType(siteType);
        return Utils.siteKey(st, siteName);
    }

    public static SiteKey siteKey(SiteType siteType, String siteName) {
        switch (siteType) {
            case PORTAL: {
                return SiteKey.portal(siteName);
            }
            case GROUP: {
                if (siteName.charAt(0) != '/') {
                    siteName = "/" + siteName;
                }
                return SiteKey.group(siteName);
            }
            case USER: {
                return SiteKey.user(siteName);
            }
        }
        return null;
    }

    public static SiteKey siteKey(Site site) {
        return Utils.siteKey(Utils.getSiteType((ObjectType<? extends Site>)site.getObjectType()), site.getName());
    }
}

