/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.cache.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.rendering.cache.AttachmentCountData;
import org.exoplatform.wiki.rendering.cache.MarkupData;
import org.exoplatform.wiki.rendering.cache.MarkupKey;
import org.exoplatform.wiki.rendering.cache.PageRenderingCacheService;
import org.exoplatform.wiki.rendering.cache.UnCachedMacroPlugin;
import org.exoplatform.wiki.service.PermissionType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.xwiki.rendering.syntax.Syntax;

public class PageRenderingCacheServiceImpl
implements PageRenderingCacheService {
    public static final String CACHE_NAME = "wiki.PageRenderingCache";
    public static final String ATT_CACHE_NAME = "wiki.PageRenderingCache.attachment";
    public static final String UUID_CACHE_NAME = "wiki.PageRenderingCache.pageUuid";
    private static final Log LOG = ExoLogger.getLogger(PageRenderingCacheService.class);
    private RenderingService renderingService;
    private WikiService wikiService;
    private ExoCache<Integer, MarkupData> renderingCache;
    private ExoCache<Integer, AttachmentCountData> attachmentCountCache;
    private ExoCache<Integer, String> uuidCache;
    private Map<WikiPageParams, List<WikiPageParams>> pageLinksMap = new ConcurrentHashMap<WikiPageParams, List<WikiPageParams>>();
    private Set<String> uncachedMacroes = new HashSet<String>();

    public PageRenderingCacheServiceImpl(RenderingService renderingService, WikiService wikiService, CacheService cacheService) {
        this.renderingService = renderingService;
        this.wikiService = wikiService;
        this.renderingCache = cacheService.getCacheInstance(CACHE_NAME);
        this.attachmentCountCache = cacheService.getCacheInstance(ATT_CACHE_NAME);
        this.uuidCache = cacheService.getCacheInstance(UUID_CACHE_NAME);
    }

    @Override
    public String getRenderedContent(WikiPageParams param, String targetSyntax) {
        String renderedContent = "";
        try {
            MarkupData cachedData;
            PageImpl page = (PageImpl)this.wikiService.getPageById(param.getType(), param.getOwner(), param.getPageId());
            boolean supportSectionEdit = page.hasPermission(PermissionType.EDITPAGE);
            MarkupKey key = new MarkupKey(new WikiPageParams(param.getType(), param.getOwner(), param.getPageId()), page.getSyntax(), targetSyntax, supportSectionEdit);
            if (page.getUncachedMixin() == null && (cachedData = (MarkupData)this.renderingCache.get((Serializable)new Integer(key.hashCode()))) != null) {
                return cachedData.build();
            }
            String markup = page.getContent().getText();
            renderedContent = this.renderingService.render(markup, page.getSyntax(), targetSyntax, supportSectionEdit);
            this.renderingCache.put((Serializable)new Integer(key.hashCode()), (Object)new MarkupData(renderedContent));
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Failed to get rendered content of page [%s:%s:%s] in syntax %s", param.getType(), param.getOwner(), param.getPageId(), targetSyntax), (Throwable)e);
        }
        return renderedContent;
    }

    @Override
    public Page getPageByParams(WikiPageParams param) {
        Page page = null;
        try {
            MarkupKey key = new MarkupKey(param, "", Syntax.XHTML_1_0.toIdString(), true);
            String uuid = (String)this.uuidCache.get((Serializable)new Integer(key.hashCode()));
            if (uuid != null && (page = this.wikiService.getPageByUUID(uuid)) != null) {
                return page;
            }
            page = this.wikiService.getPageByIdJCRQuery(param.getType(), param.getOwner(), param.getPageId());
            if (page != null) {
                uuid = page.getJCRPageNode().getUUID();
                this.uuidCache.put((Serializable)new Integer(key.hashCode()), (Object)uuid);
            }
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Failed to get page [%s:%s:%s]", param.getType(), param.getOwner(), param.getPageId()), (Throwable)e);
        }
        return page;
    }

    @Override
    public int getAttachmentCount(PageImpl page) {
        int attachmentCount = 0;
        Wiki wiki = page.getWiki();
        try {
            boolean supportSectionEdit = page.hasPermission(PermissionType.EDITPAGE);
            MarkupKey key = new MarkupKey(new WikiPageParams(wiki.getType(), wiki.getOwner(), page.getName()), page.getSyntax(), Syntax.XHTML_1_0.toIdString(), supportSectionEdit);
            AttachmentCountData cachedData = (AttachmentCountData)this.attachmentCountCache.get((Serializable)new Integer(key.hashCode()));
            if (cachedData != null) {
                return cachedData.build();
            }
            attachmentCount = page.getAttachmentsExcludeContent().size();
            this.attachmentCountCache.put((Serializable)new Integer(key.hashCode()), (Object)new AttachmentCountData(attachmentCount));
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Failed to get attachment count of page [%s:%s:%s]", wiki.getType(), wiki.getOwner(), page.getName()), (Throwable)e);
        }
        return attachmentCount;
    }

    @Override
    public final ExoCache<Integer, MarkupData> getRenderingCache() {
        return this.renderingCache;
    }

    @Override
    public Map<WikiPageParams, List<WikiPageParams>> getPageLinksMap() {
        return this.pageLinksMap;
    }

    @Override
    public void addPageLink(WikiPageParams param, WikiPageParams entity) {
        List<WikiPageParams> linkParams = this.pageLinksMap.get(entity);
        if (linkParams == null) {
            linkParams = new ArrayList<WikiPageParams>();
            this.pageLinksMap.put(entity, linkParams);
        }
        linkParams.add(param);
    }

    @Override
    public void invalidateCache(WikiPageParams param) {
        List<WikiPageParams> linkedPages = this.pageLinksMap.get(param);
        linkedPages = linkedPages == null ? new ArrayList<WikiPageParams>() : new ArrayList<WikiPageParams>(linkedPages);
        linkedPages.add(param);
        for (WikiPageParams wikiPageParams : linkedPages) {
            try {
                MarkupKey key = new MarkupKey(wikiPageParams, Syntax.XWIKI_2_0.toIdString(), Syntax.XHTML_1_0.toIdString(), false);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key = new MarkupKey(wikiPageParams, Syntax.XHTML_1_0.toIdString(), Syntax.XWIKI_2_0.toIdString(), false);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
            }
            catch (Exception e) {
                LOG.warn((Object)String.format("Failed to invalidate cache of page [%s:%s:%s]", wikiPageParams.getType(), wikiPageParams.getOwner(), wikiPageParams.getPageId()));
            }
        }
    }

    @Override
    public void addUnCachedMacro(UnCachedMacroPlugin plugin) {
        for (String name : plugin.getUncachedMacroes()) {
            this.uncachedMacroes.add(name);
        }
    }

    @Override
    public Set<String> getUncachedMacroes() {
        return new HashSet<String>(this.uncachedMacroes);
    }

    @Override
    public void invalidateUUIDCache(WikiPageParams param) {
        MarkupKey key = new MarkupKey(param, "", Syntax.XHTML_1_0.toIdString(), true);
        this.uuidCache.remove((Serializable)new Integer(key.hashCode()));
    }

    @Override
    public void invalidateAttachmentCache(WikiPageParams param) {
        List<WikiPageParams> linkedPages = this.pageLinksMap.get(param);
        linkedPages = linkedPages == null ? new ArrayList<WikiPageParams>() : new ArrayList<WikiPageParams>(linkedPages);
        linkedPages.add(param);
        for (WikiPageParams wikiPageParams : linkedPages) {
            try {
                MarkupKey key = new MarkupKey(wikiPageParams, Syntax.XWIKI_2_0.toIdString(), Syntax.XHTML_1_0.toIdString(), false);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
                key = new MarkupKey(wikiPageParams, Syntax.XHTML_1_0.toIdString(), Syntax.XWIKI_2_0.toIdString(), false);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
            }
            catch (Exception e) {
                LOG.warn((Object)String.format("Failed to invalidate cache of page [%s:%s:%s]", wikiPageParams.getType(), wikiPageParams.getOwner(), wikiPageParams.getPageId()));
            }
        }
    }
}

