/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.core.nodetype.ItemDefinitionData;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.SharedDataManager;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.core.version.ChildVersionRemoveVisitor;
import org.exoplatform.services.jcr.impl.core.version.VersionHistoryImpl;
import org.exoplatform.services.jcr.impl.core.version.VersionImpl;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataMoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LocalWorkspaceDataManagerStub;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableDataManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionDataManager
implements ItemDataConsumer {
    public static final int MERGE_NODES = 1;
    public static final int MERGE_PROPS = 2;
    public static final int MERGE_ITEMS = 3;
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.SessionDataManager");
    protected final SessionImpl session;
    protected final ItemReferencePool itemsPool;
    protected final List<ItemImpl> invalidated = new ArrayList<ItemImpl>();
    private final SessionChangesLog changesLog;
    protected final SessionItemFactory itemFactory;
    protected final AccessManager accessManager;
    protected final TransactionableDataManager transactionableManager;

    public SessionDataManager(SessionImpl session, LocalWorkspaceDataManagerStub dataManager) throws RepositoryException {
        this.session = session;
        this.changesLog = new SessionChangesLog(session);
        this.itemsPool = new ItemReferencePool();
        this.itemFactory = new SessionItemFactory();
        this.accessManager = session.getAccessManager();
        this.transactionableManager = new TransactionableDataManager(dataManager, session);
    }

    public SharedDataManager getWorkspaceDataManager() {
        return this.transactionableManager.getStorageDataManager();
    }

    public String dump() {
        StringBuilder d = new StringBuilder("\nChanges:");
        d.append(this.changesLog.dump()).append("\nCache:").append(this.itemsPool.dump());
        return d.toString();
    }

    public TransactionableDataManager getTransactManager() {
        return this.transactionableManager;
    }

    public ItemData getItemData(QPath path) throws RepositoryException {
        NodeData parent = (NodeData)this.getItemData("00exo0jcr0root0uuid0000000000000");
        if (path.equals(Constants.ROOT_PATH)) {
            return parent;
        }
        QPathEntry[] relPathEntries = path.getRelPath(path.getDepth());
        return this.getItemData(parent, relPathEntries, ItemType.UNKNOWN);
    }

    public ItemData getItemData(NodeData parent, QPathEntry[] relPathEntries, ItemType itemType) throws RepositoryException {
        ItemData item = parent;
        for (int i = 0; i < relPathEntries.length && (item = i == relPathEntries.length - 1 ? this.getItemData(parent, relPathEntries[i], itemType) : this.getItemData(parent, relPathEntries[i], ItemType.UNKNOWN)) != null; ++i) {
            if (item.isNode()) {
                parent = (NodeData)item;
                continue;
            }
            if (i >= relPathEntries.length - 1) continue;
            throw new IllegalPathException("Path can not contains a property as the intermediate element");
        }
        return item;
    }

    @Override
    public ItemData getItemData(NodeData parent, QPathEntry name, ItemType itemType) throws RepositoryException {
        return this.getItemData(parent, name, false, itemType, true);
    }

    @Override
    public ItemData getItemData(NodeData parent, QPathEntry name, ItemType itemType, boolean createNullItemData) throws RepositoryException {
        return this.getItemData(parent, name, false, itemType, createNullItemData);
    }

    private ItemData getItemData(NodeData parent, QPathEntry name, boolean skipCheckInPersistence, ItemType itemType, boolean createNullItemData) throws RepositoryException {
        if (name.getName().equals("..") && name.getNamespace().equals("")) {
            if (parent.getIdentifier().equals("00exo0jcr0root0uuid0000000000000")) {
                return null;
            }
            return this.getItemData(parent.getParentIdentifier());
        }
        ItemData data = null;
        ItemState state = this.changesLog.getItemState(parent, name, itemType);
        if (state == null) {
            if (this.isNew(parent.getIdentifier())) {
                return null;
            }
            if (!skipCheckInPersistence) {
                data = this.transactionableManager.getItemData(parent, name, itemType, createNullItemData);
                data = this.updatePathIfNeeded(data);
            }
        } else if (!state.isDeleted()) {
            data = state.getData();
        }
        return data;
    }

    @Override
    public boolean hasItemData(NodeData parent, QPathEntry name, ItemType itemType) throws RepositoryException {
        if (name.getName().equals("..") && name.getNamespace().equals("")) {
            return !parent.getIdentifier().equals("00exo0jcr0root0uuid0000000000000");
        }
        ItemState state = this.changesLog.getItemState(parent, name, itemType);
        if (state == null) {
            if (this.isNew(parent.getIdentifier())) {
                return false;
            }
            return this.transactionableManager.hasItemData(parent, name, itemType);
        }
        return !state.isDeleted();
    }

    @Override
    public ItemData getItemData(String identifier) throws RepositoryException {
        ItemData data = null;
        ItemState state = this.changesLog.getItemState(identifier);
        if (state == null) {
            data = this.transactionableManager.getItemData(identifier);
            data = this.updatePathIfNeeded(data);
        } else if (!state.isDeleted()) {
            data = state.getData();
        }
        return data;
    }

    public ItemImpl getItem(NodeData parent, QPathEntry name, boolean pool, ItemType itemType) throws RepositoryException {
        return this.getItem(parent, name, pool, itemType, true);
    }

    public ItemImpl getItem(NodeData parent, QPathEntry name, boolean pool, ItemType itemType, boolean apiRead) throws RepositoryException {
        return this.getItem(parent, name, pool, itemType, apiRead, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemImpl getItem(NodeData parent, QPathEntry name, boolean pool, ItemType itemType, boolean apiRead, boolean createNullItemData) throws RepositoryException {
        ItemImpl itemImpl;
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.currentTimeMillis();
            LOG.debug((Object)("getItem(" + parent.getQPath().getAsString() + " + " + name.getAsString() + " ) >>>>>"));
        }
        ItemImpl item = null;
        try {
            itemImpl = item = this.readItem(this.getItemData(parent, name, itemType, createNullItemData), parent, pool, apiRead);
        }
        catch (Throwable throwable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getItem(" + parent.getQPath().getAsString() + " + " + name.getAsString() + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getItem(" + parent.getQPath().getAsString() + " + " + name.getAsString() + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return itemImpl;
    }

    public ItemImpl getItem(NodeData parent, QPathEntry name, boolean pool, boolean skipCheckInPersistence, ItemType itemType) throws RepositoryException {
        return this.getItem(parent, name, pool, skipCheckInPersistence, itemType, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemImpl getItem(NodeData parent, QPathEntry name, boolean pool, boolean skipCheckInPersistence, ItemType itemType, boolean createNullItemData) throws RepositoryException {
        ItemImpl itemImpl;
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.currentTimeMillis();
            LOG.debug((Object)("getItem(" + parent.getQPath().getAsString() + " + " + name.getAsString() + " ) >>>>>"));
        }
        ItemImpl item = null;
        try {
            itemImpl = item = this.readItem(this.getItemData(parent, name, skipCheckInPersistence, itemType, createNullItemData), parent, pool, true);
        }
        catch (Throwable throwable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getItem(" + parent.getQPath().getAsString() + " + " + name.getAsString() + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getItem(" + parent.getQPath().getAsString() + " + " + name.getAsString() + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return itemImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemImpl getItem(NodeData parent, QPathEntry[] relPath, boolean pool, ItemType itemType) throws RepositoryException {
        ItemImpl itemImpl;
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.currentTimeMillis();
            StringBuilder debugPath = new StringBuilder();
            for (QPathEntry rp : relPath) {
                debugPath.append(rp.getAsString());
            }
            LOG.debug((Object)("getItem(" + parent.getQPath().getAsString() + " + " + debugPath + " ) >>>>>"));
        }
        ItemImpl item = null;
        try {
            itemImpl = item = this.readItem(this.getItemData(parent, relPath, itemType), pool);
            Object var13_11 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var13_12 = null;
                if (!LOG.isDebugEnabled()) break block7;
                StringBuilder debugPath = new StringBuilder();
                for (QPathEntry rp : relPath) {
                    debugPath.append(rp.getAsString());
                }
                LOG.debug((Object)("getItem(" + parent.getQPath().getAsString() + " + " + debugPath + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder debugPath = new StringBuilder();
            for (QPathEntry rp : relPath) {
                debugPath.append(rp.getAsString());
            }
            LOG.debug((Object)("getItem(" + parent.getQPath().getAsString() + " + " + debugPath + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return itemImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemImpl getItem(QPath path, boolean pool) throws RepositoryException {
        ItemImpl itemImpl;
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.currentTimeMillis();
            LOG.debug((Object)("getItem(" + path.getAsString() + " ) >>>>>"));
        }
        ItemImpl item = null;
        try {
            itemImpl = item = this.readItem(this.getItemData(path), pool);
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var8_7 = null;
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)("getItem(" + path.getAsString() + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getItem(" + path.getAsString() + ") --> " + (item != null ? item.getPath() : "null") + " <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return itemImpl;
    }

    protected ItemImpl readItem(ItemData itemData, boolean pool) throws RepositoryException {
        return this.readItem(itemData, null, pool, true);
    }

    protected ItemImpl readItem(ItemData itemData, NodeData parent, boolean pool, boolean apiRead) throws RepositoryException {
        SecurityManager security;
        if (!apiRead && (security = System.getSecurityManager()) != null) {
            security.checkPermission(JCRRuntimePermissions.INVOKE_INTERNAL_API_PERMISSION);
        }
        if (itemData != null) {
            ItemImpl pooledItem;
            ItemImpl item = pool && (pooledItem = this.itemsPool.get(itemData, parent)) != null ? pooledItem : this.itemFactory.createItem(itemData, parent);
            if (apiRead) {
                if (!item.hasPermission("read")) {
                    throw new AccessDeniedException("Access denied " + itemData.getQPath().getAsString() + " for " + this.session.getUserID());
                }
                this.session.getActionHandler().postRead(item);
            }
            return item;
        }
        return null;
    }

    public ItemImpl getItemByIdentifier(String identifier, boolean pool) throws RepositoryException {
        return this.getItemByIdentifier(identifier, pool, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemImpl getItemByIdentifier(String identifier, boolean pool, boolean apiRead) throws RepositoryException {
        ItemImpl itemImpl;
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.currentTimeMillis();
            LOG.debug((Object)("getItemByIdentifier(" + identifier + " ) >>>>>"));
        }
        ItemImpl item = null;
        try {
            itemImpl = item = this.readItem(this.getItemData(identifier), null, pool, apiRead);
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var9_8 = null;
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)("getItemByIdentifier(" + identifier + ") --> " + (item != null ? item.getPath() : "null") + "  <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getItemByIdentifier(" + identifier + ") --> " + (item != null ? item.getPath() : "null") + "  <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return itemImpl;
    }

    public boolean hasPendingChanges(QPath path) {
        return this.changesLog.getDescendantsChanges(path).size() > 0;
    }

    public boolean isNew(String identifier) {
        ItemState lastState = this.changesLog.getItemState(identifier);
        if (lastState == null || lastState.isDeleted()) {
            return false;
        }
        return this.changesLog.getItemState(identifier, 1) != null;
    }

    public boolean isDeleted(String identifier) {
        ItemState lastState = this.changesLog.getItemState(identifier);
        return lastState != null && lastState.isDeleted();
    }

    public boolean isDeleted(QPath itemPath) {
        ItemState lastState = this.changesLog.getItemState(itemPath);
        return lastState != null && lastState.isDeleted();
    }

    public boolean isModified(ItemData item) {
        if (item.isNode()) {
            Collection<ItemState> nodeChanges = this.changesLog.getLastModifyStates((NodeData)item);
            return nodeChanges.size() > 0;
        }
        ItemState state = this.changesLog.getLastState(item, false);
        if (state != null) {
            return !state.isAdded() && !state.isDeleted();
        }
        return false;
    }

    public List<PropertyImpl> getReferences(String identifier) throws RepositoryException {
        List<PropertyData> refDatas = this.transactionableManager.getReferencesData(identifier, true);
        ArrayList<PropertyImpl> refs = new ArrayList<PropertyImpl>(refDatas.size());
        int length = refDatas.size();
        for (int i = 0; i < length; ++i) {
            NodeData parent;
            PropertyData data = refDatas.get(i);
            ItemState state = this.changesLog.getItemState(data.getIdentifier());
            if (state != null) {
                if (state.isDeleted()) continue;
                data = (PropertyData)state.getData();
            }
            if ((parent = (NodeData)this.getItemData(data.getParentIdentifier())) == null || !this.accessManager.hasPermission(parent.getACL(), new String[]{"read"}, this.session.getUserState().getIdentity())) continue;
            PropertyImpl item = (PropertyImpl)this.readItem(data, parent, true, false);
            refs.add(item);
            this.session.getActionHandler().postRead(item);
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getChildNodesDataByPage(NodeData parent, int fromOrderNum, int toOrderNum, List<NodeData> childs) throws RepositoryException {
        boolean bl;
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.currentTimeMillis();
            LOG.debug((Object)("getChildNodesData(" + parent.getQPath().getAsString() + " , itemDataFilter) >>>>>"));
        }
        try {
            Collection<ItemState> transientDescendants;
            boolean hasNext = false;
            if (!this.isNew(parent.getIdentifier())) {
                hasNext = this.transactionableManager.getChildNodesDataByPage(parent, fromOrderNum, toOrderNum, childs);
            }
            if (!(transientDescendants = this.changesLog.getLastChildrenStates(parent, true)).isEmpty()) {
                LinkedHashMap<String, NodeData> descendants = new LinkedHashMap<String, NodeData>();
                int length = childs.size();
                for (int i = 0; i < length; ++i) {
                    NodeData childNode = childs.get(i);
                    descendants.put(childNode.getIdentifier(), childNode);
                }
                int minOrderNum = childs.size() != 0 ? childs.get(0).getOrderNumber() : -1;
                int maxOrderNum = childs.size() != 0 ? childs.get(childs.size() - 1).getOrderNumber() : -1;
                for (ItemState state : transientDescendants) {
                    NodeData data = (NodeData)state.getData();
                    descendants.remove(data.getIdentifier());
                    if ((state.isAdded() || state.isRenamed() || state.isPathChanged()) && !hasNext) {
                        descendants.put(data.getIdentifier(), data);
                        continue;
                    }
                    if (!state.isMixinChanged() && !state.isUpdated() || minOrderNum > data.getOrderNumber() || data.getOrderNumber() > maxOrderNum) continue;
                    descendants.put(data.getIdentifier(), data);
                }
                childs.clear();
                childs.addAll(descendants.values());
            }
            bl = hasNext;
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            block9: {
                Object var16_16 = null;
                if (!LOG.isDebugEnabled()) break block9;
                LOG.debug((Object)("getChildNodesData(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getChildNodesData(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException {
        List<? extends ItemData> list;
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.currentTimeMillis();
            LOG.debug((Object)("getChildNodesData(" + parent.getQPath().getAsString() + ") >>>>>"));
        }
        try {
            list = this.mergeNodes((ItemData)parent, this.transactionableManager);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_5 = null;
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)("getChildNodesData(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getChildNodesData(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeData> getChildNodesData(NodeData parent, List<QPathEntryFilter> patternFilters) throws RepositoryException {
        List<? extends ItemData> list;
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.currentTimeMillis();
            LOG.debug((Object)("getChildNodesData(" + parent.getQPath().getAsString() + " , itemDataFilter) >>>>>"));
        }
        try {
            ArrayList<NodeData> persistChildNodes = this.isNew(parent.getIdentifier()) ? new ArrayList<NodeData>() : this.transactionableManager.getChildNodesData(parent, patternFilters);
            list = this.mergeNodes((ItemData)parent, persistChildNodes);
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var8_7 = null;
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)("getChildNodesData(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getChildNodesData(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return list;
    }

    @Override
    public int getLastOrderNumber(NodeData parent) throws RepositoryException {
        int lastOrderNumber = this.changesLog.getLastChildOrderNumber(parent.getIdentifier());
        int lastPersistedNodeOrderNumber = this.isNew(parent.getIdentifier()) ? -1 : this.transactionableManager.getLastOrderNumber(parent);
        return Math.max(lastPersistedNodeOrderNumber, lastOrderNumber);
    }

    @Override
    public int getChildNodesCount(NodeData parent) throws RepositoryException {
        int childsCount = this.changesLog.getChildNodesCount(parent.getIdentifier()) + (this.isNew(parent.getIdentifier()) ? 0 : this.transactionableManager.getChildNodesCount(parent));
        if (childsCount < 0) {
            throw new InvalidItemStateException("Node's child nodes were changed in another Session " + parent.getQPath().getAsString());
        }
        return childsCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException {
        List<? extends ItemData> list;
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.currentTimeMillis();
            LOG.debug((Object)("getChildPropertiesData(" + parent.getQPath().getAsString() + ") >>>>>"));
        }
        try {
            list = this.mergeProps((ItemData)parent, false, (DataManager)this.transactionableManager);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_5 = null;
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)("getChildPropertiesData(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getChildPropertiesData(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent, List<QPathEntryFilter> itemDataFilters) throws RepositoryException {
        List<? extends ItemData> list;
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.currentTimeMillis();
            LOG.debug((Object)("getChildPropertiesData(" + parent.getQPath().getAsString() + ") >>>>>"));
        }
        try {
            ArrayList<PropertyData> childProperties = this.isNew(parent.getIdentifier()) ? new ArrayList<PropertyData>() : this.transactionableManager.getChildPropertiesData(parent, itemDataFilters);
            list = this.mergeProps((ItemData)parent, childProperties, (DataManager)this.transactionableManager);
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var8_7 = null;
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)("getChildPropertiesData(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getChildPropertiesData(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> listChildPropertiesData(NodeData parent) throws RepositoryException {
        List<? extends ItemData> list;
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.currentTimeMillis();
            LOG.debug((Object)("listChildPropertiesData(" + parent.getQPath().getAsString() + ") >>>>>"));
        }
        try {
            list = this.mergeProps((ItemData)parent, true, (DataManager)this.transactionableManager);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_5 = null;
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)("listChildPropertiesData(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("listChildPropertiesData(" + parent.getQPath().getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessControlList getACL(QPath path) throws RepositoryException {
        NodeData parent;
        long start;
        block11: {
            AccessControlList accessControlList;
            block10: {
                start = 0L;
                if (LOG.isDebugEnabled()) {
                    start = System.currentTimeMillis();
                    LOG.debug((Object)("getACL(" + path.getAsString() + " ) >>>>>"));
                }
                parent = (NodeData)this.getItemData("00exo0jcr0root0uuid0000000000000");
                if (!path.equals(Constants.ROOT_PATH)) break block10;
                AccessControlList accessControlList2 = parent.getACL();
                Object var9_6 = null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("getACL(" + path.getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
                }
                return accessControlList2;
            }
            try {
                ItemData item = null;
                QPathEntry[] relPathEntries = path.getRelPath(path.getDepth());
                for (int i = 0; i < relPathEntries.length && (item = i == relPathEntries.length - 1 ? this.getItemData(parent, relPathEntries[i], ItemType.NODE) : this.getItemData(parent, relPathEntries[i], ItemType.UNKNOWN)) != null; ++i) {
                    if (item.isNode()) {
                        parent = (NodeData)item;
                        continue;
                    }
                    if (i >= relPathEntries.length - 1) continue;
                    throw new IllegalPathException("Get ACL. Path can not contains a property as the intermediate element");
                }
                if (item == null || !item.isNode()) break block11;
                accessControlList = ((NodeData)item).getACL();
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                block12: {
                    Object var9_9 = null;
                    if (!LOG.isDebugEnabled()) break block12;
                    LOG.debug((Object)("getACL(" + path.getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
                }
                throw throwable;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getACL(" + path.getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            return accessControlList;
        }
        AccessControlList accessControlList = parent.getACL();
        Object var9_8 = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getACL(" + path.getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return accessControlList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessControlList getACL(NodeData parent, QPathEntry name) throws RepositoryException {
        long start;
        block6: {
            AccessControlList accessControlList;
            start = 0L;
            if (LOG.isDebugEnabled()) {
                start = System.currentTimeMillis();
                LOG.debug((Object)("getACL(" + parent.getQPath().getAsString() + " + " + name.getAsString() + " ) >>>>>"));
            }
            try {
                ItemData item = this.getItemData(parent, name, ItemType.NODE);
                if (item == null || !item.isNode()) break block6;
                accessControlList = ((NodeData)item).getACL();
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var8_9 = null;
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug((Object)("getACL(" + parent.getQPath().getAsString() + " + " + name.getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
                }
                throw throwable;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getACL(" + parent.getQPath().getAsString() + " + " + name.getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            return accessControlList;
        }
        AccessControlList accessControlList = parent.getACL();
        Object var8_8 = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getACL(" + parent.getQPath().getAsString() + " + " + name.getAsString() + ") <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return accessControlList;
    }

    ItemImpl reloadItem(ItemData data) throws RepositoryException {
        return this.itemsPool.reload(data);
    }

    public void move(NodeData srcData, ItemDataMoveVisitor initializer) throws RepositoryException {
        srcData.accept(initializer);
        this.changesLog.addAll(initializer.getAllStates());
        this.reloadItems(initializer);
    }

    public void reloadItems(ItemDataMoveVisitor initializer) throws RepositoryException {
        List<ItemState> states = initializer.getItemAddStates();
        int length = states.size();
        for (int i = 0; i < length; ++i) {
            ItemState state = states.get(i);
            if (state.isUpdated() || state.isRenamed()) {
                ItemImpl item = this.reloadItem(state.getData());
                if (item == null) continue;
                this.invalidated.add(item);
                continue;
            }
            if (!state.isPathChanged()) continue;
            this.reloadDescendants(state.getOldPath(), state.getData().getQPath());
        }
    }

    public void delete(ItemData itemData) throws RepositoryException {
        this.delete(itemData, itemData.getQPath(), false);
    }

    public void delete(ItemData itemData, QPath ancestorToSave) throws RepositoryException {
        this.delete(itemData, ancestorToSave, false);
    }

    protected void delete(ItemData itemData, QPath ancestorToSave, boolean isInternall) throws RepositoryException {
        List<? extends ItemData> list = this.mergeList(itemData, this.transactionableManager, true, 3);
        ArrayList<ItemState> deletes = new ArrayList<ItemState>();
        boolean fireEvent = !this.isNew(itemData.getIdentifier());
        boolean checkRemoveChildVersionStorages = false;
        if (itemData.isNode()) {
            checkRemoveChildVersionStorages = !this.session.getWorkspace().getNodeTypesHolder().isNodeType(Constants.NT_VERSIONHISTORY, ((NodeData)itemData).getPrimaryTypeName());
        }
        boolean rootAdded = false;
        for (ItemData itemData2 : list) {
            ItemImpl pooled;
            if (itemData2.equals(itemData)) {
                rootAdded = true;
            }
            deletes.add(new ItemState(itemData2, 4, fireEvent, ancestorToSave, isInternall));
            if (checkRemoveChildVersionStorages && !itemData2.isNode() && Constants.JCR_VERSIONHISTORY.equals((Object)itemData2.getQPath().getName())) {
                try {
                    PropertyData vhPropertyData = (PropertyData)this.getItemData(itemData2.getIdentifier());
                    this.removeVersionHistory(ValueDataUtil.getString(vhPropertyData.getValues().get(0)), null, ancestorToSave);
                }
                catch (IllegalStateException e) {
                    throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if ((pooled = this.itemsPool.remove(itemData2.getIdentifier())) == null) continue;
            pooled.invalidate();
            this.invalidated.add(pooled);
        }
        if (!rootAdded) {
            deletes.add(new ItemState(itemData, 4, fireEvent, ancestorToSave, isInternall));
            ItemImpl pooled = this.itemsPool.remove(itemData.getIdentifier());
            if (pooled != null) {
                pooled.invalidate();
                this.invalidated.add(pooled);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("deleted top item: " + itemData.getQPath().getAsString()));
            }
        }
        Collections.sort(deletes, new PathSorter());
        if (!fireEvent) {
            this.changesLog.eraseEventFire(itemData.getIdentifier());
        }
        this.changesLog.addAll(deletes);
        if (itemData.isNode()) {
            this.changesLog.addAll(this.reindexSameNameSiblings((NodeData)itemData, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeVersionHistory(String vhID, QPath containingHistory, QPath ancestorToSave) throws RepositoryException, ConstraintViolationException, VersionException {
        NodeData vhnode = (NodeData)this.getItemData(vhID);
        if (vhnode == null) {
            ItemState vhState = this.changesLog.getItemState(vhID);
            if (vhState != null && vhState.isDeleted()) {
                return;
            }
            LOG.debug((Object)("Version history is not found. UUID: " + vhID + ". Context item (ancestor to save) " + ancestorToSave.getAsString()));
            return;
        }
        RepositoryImpl rep = (RepositoryImpl)this.session.getRepository();
        for (String wsName : rep.getWorkspaceNames()) {
            Object var14_14;
            SessionImpl wsSession = this.session.getWorkspace().getName().equals(wsName) ? this.session : rep.getSystemSession(wsName);
            try {
                for (PropertyData sref : wsSession.getTransientNodesManager().getReferencesData(vhID, false)) {
                    if (sref.getQPath().isDescendantOf(Constants.JCR_VERSION_STORAGE_PATH)) {
                        if (sref.getQPath().isDescendantOf(vhnode.getQPath())) continue;
                        if (containingHistory != null) {
                            if (sref.getQPath().isDescendantOf(containingHistory)) continue;
                        }
                        var14_14 = null;
                        if (wsSession == this.session) return;
                        wsSession.logout();
                        return;
                    }
                    if (wsSession == this.session) continue;
                }
            }
            catch (Throwable throwable) {
                var14_14 = null;
                if (wsSession == this.session) throw throwable;
                wsSession.logout();
                throw throwable;
            }
            {
                var14_14 = null;
                if (wsSession == this.session) return;
                wsSession.logout();
                return;
            }
            var14_14 = null;
            if (wsSession == this.session) continue;
            wsSession.logout();
            {
            }
        }
        ChildVersionRemoveVisitor cvremover = new ChildVersionRemoveVisitor(this.session.getTransientNodesManager(), this.session.getWorkspace().getNodeTypesHolder(), vhnode.getQPath(), ancestorToSave);
        vhnode.accept(cvremover);
        this.delete(vhnode, ancestorToSave, true);
    }

    protected List<ItemState> reindexSameNameSiblings(NodeData cause, ItemDataConsumer dataManager) throws RepositoryException {
        ArrayList<ItemState> changes = new ArrayList<ItemState>();
        NodeData parentNodeData = (NodeData)dataManager.getItemData(cause.getParentIdentifier());
        NodeData nextSibling = (NodeData)dataManager.getItemData(parentNodeData, new QPathEntry(cause.getQPath().getName(), cause.getQPath().getIndex() + 1), ItemType.NODE);
        String reindexedId = null;
        while (nextSibling != null && !nextSibling.getIdentifier().equals(cause.getIdentifier()) && !nextSibling.getIdentifier().equals(reindexedId)) {
            QPath siblingOldPath = QPath.makeChildPath(nextSibling.getQPath().makeParentPath(), nextSibling.getQPath().getName(), nextSibling.getQPath().getIndex());
            QPath siblingPath = QPath.makeChildPath(nextSibling.getQPath().makeParentPath(), nextSibling.getQPath().getName(), nextSibling.getQPath().getIndex() - 1);
            TransientNodeData reindexed = new TransientNodeData(siblingPath, nextSibling.getIdentifier(), nextSibling.getPersistedVersion(), nextSibling.getPrimaryTypeName(), nextSibling.getMixinTypeNames(), nextSibling.getOrderNumber(), nextSibling.getParentIdentifier(), nextSibling.getACL());
            reindexedId = reindexed.getIdentifier();
            ItemState reindexedState = ItemState.createUpdatedState(reindexed);
            changes.add(reindexedState);
            this.itemsPool.reload(reindexed);
            this.reloadDescendants(siblingOldPath, siblingPath);
            nextSibling = (NodeData)dataManager.getItemData(parentNodeData, new QPathEntry(nextSibling.getQPath().getName(), nextSibling.getQPath().getIndex() + 1), ItemType.NODE);
        }
        return changes;
    }

    public ItemImpl update(ItemState itemState, boolean pool) throws RepositoryException {
        if (itemState.isDeleted()) {
            throw new RepositoryException("Illegal state DELETED. Use delete(...) method");
        }
        this.changesLog.add(itemState);
        return this.readItem(itemState.getData(), null, pool, false);
    }

    public void updateItemState(ItemState itemState) throws RepositoryException {
        if (itemState.isDeleted()) {
            throw new RepositoryException("Illegal state DELETED. Use delete(...) method");
        }
        this.changesLog.add(itemState);
    }

    public void commit(QPath path) throws RepositoryException, AccessDeniedException, ReferentialIntegrityException, InvalidItemStateException, ItemExistsException {
        this.validate(path);
        PlainChangesLog cLog = this.changesLog.pushLog(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(" ----- commit -------- \n" + cLog.dump()));
        }
        try {
            this.transactionableManager.save(cLog);
            this.invalidated.clear();
        }
        catch (AccessDeniedException e) {
            this.remainChangesBack(cLog);
            throw new AccessDeniedException((Throwable)e);
        }
        catch (InvalidItemStateException e) {
            this.remainChangesBack(cLog);
            throw new InvalidItemStateException((Throwable)e);
        }
        catch (ItemExistsException e) {
            this.remainChangesBack(cLog);
            throw new ItemExistsException((Throwable)e);
        }
        catch (ReferentialIntegrityException e) {
            this.remainChangesBack(cLog);
            throw new ReferentialIntegrityException((Throwable)e);
        }
        catch (RepositoryException e) {
            this.remainChangesBack(cLog);
            throw new RepositoryException((Throwable)e);
        }
    }

    private void remainChangesBack(PlainChangesLog cLog) {
        this.changesLog.addAll(cLog.getAllStates());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(" ----- rollback ----- \n" + cLog.dump()));
        }
    }

    @Override
    public List<PropertyData> getReferencesData(String identifier, boolean skipVersionStorage) throws RepositoryException {
        List<PropertyData> persisted = this.transactionableManager.getReferencesData(identifier, skipVersionStorage);
        ArrayList<PropertyData> sessionTransient = new ArrayList<PropertyData>();
        for (PropertyData p : persisted) {
            sessionTransient.add(p);
        }
        return sessionTransient;
    }

    private void validate(QPath path) throws RepositoryException, AccessDeniedException, ReferentialIntegrityException {
        List<ItemState> changes = this.changesLog.getAllStates();
        for (ItemState itemState : changes) {
            if (itemState.isInternallyCreated()) {
                if (!itemState.isMixinChanged()) continue;
                if (itemState.isDescendantOf(path) && ((NodeData)itemState.getData()).getACL().getPermissionsSize() < 1) {
                    throw new RepositoryException("Node " + itemState.getData().getQPath().getAsString() + " has wrong formed ACL.");
                }
                this.validateMandatoryItem(itemState);
                continue;
            }
            if (itemState.isDescendantOf(path)) {
                this.validateAccessPermissions(itemState);
                this.validateMandatoryItem(itemState);
            }
            if (!path.isDescendantOf(itemState.getAncestorToSave())) continue;
            throw new ConstraintViolationException(path.getAsString() + " is the same or descendant of either Session.move()'s destination or source node only " + path.getAsString());
        }
    }

    private void validateAccessPermissions(ItemState changedItem) throws RepositoryException, AccessDeniedException {
        if (changedItem.isAddedAutoCreatedNodes()) {
            this.validateAddNodePermission(changedItem);
        } else if (changedItem.isDeleted()) {
            this.validateRemoveAccessPermission(changedItem);
        } else if (changedItem.isMixinChanged()) {
            this.validateMixinChangedPermission(changedItem);
        } else {
            NodeData parent = (NodeData)this.getItemData(changedItem.getData().getParentIdentifier());
            if (parent != null) {
                if (changedItem.getData().isNode()) {
                    if (changedItem.isAdded() && !this.accessManager.hasPermission(parent.getACL(), new String[]{"add_node"}, this.session.getUserState().getIdentity())) {
                        throw new AccessDeniedException("Access denied: ADD_NODE " + changedItem.getData().getQPath().getAsString() + " for: " + this.session.getUserID() + " item owner " + parent.getACL().getOwner());
                    }
                } else if ((changedItem.isAdded() || changedItem.isUpdated()) && !this.accessManager.hasPermission(parent.getACL(), new String[]{"set_property"}, this.session.getUserState().getIdentity())) {
                    throw new AccessDeniedException("Access denied: SET_PROPERTY " + changedItem.getData().getQPath().getAsString() + " for: " + this.session.getUserID() + " item owner " + parent.getACL().getOwner());
                }
            }
        }
    }

    private void validateRemoveAccessPermission(ItemState changedItem) throws RepositoryException, AccessDeniedException {
        NodeData nodeData = null;
        if (changedItem.isNode()) {
            nodeData = (NodeData)changedItem.getData();
        } else {
            nodeData = (NodeData)this.getItemData(changedItem.getData().getParentIdentifier());
            if (nodeData == null) {
                return;
            }
        }
        if (!this.accessManager.hasPermission(nodeData.getACL(), new String[]{"remove"}, this.session.getUserState().getIdentity())) {
            throw new AccessDeniedException("Access denied: REMOVE " + changedItem.getData().getQPath().getAsString() + " for: " + this.session.getUserID() + " item owner " + nodeData.getACL().getOwner());
        }
    }

    private void validateAddNodePermission(ItemState changedItem) throws AccessDeniedException {
        if (!this.accessManager.hasPermission(((NodeData)changedItem.getData()).getACL(), new String[]{"add_node"}, this.session.getUserState().getIdentity())) {
            throw new AccessDeniedException("Access denied: ADD_NODE" + changedItem.getData().getQPath().getAsString() + " for: " + this.session.getUserID() + " item owner " + ((NodeData)changedItem.getData()).getACL().getOwner());
        }
    }

    private void validateMixinChangedPermission(ItemState changedItem) throws AccessDeniedException {
        if (!this.accessManager.hasPermission(((NodeData)changedItem.getData()).getACL(), new String[]{"set_property"}, this.session.getUserState().getIdentity())) {
            throw new AccessDeniedException("Access denied: SET_PROPERTY" + changedItem.getData().getQPath().getAsString() + " for: " + this.session.getUserID() + " item owner " + ((NodeData)changedItem.getData()).getACL().getOwner());
        }
    }

    private void validateMandatoryItem(ItemState changedItem) throws ConstraintViolationException, AccessDeniedException {
        if (changedItem.getData().isNode() && (changedItem.isAdded() || changedItem.isMixinChanged()) && !this.changesLog.getItemState(changedItem.getData().getQPath()).isDeleted() && !this.changesLog.getItemState(changedItem.getData().getIdentifier()).isDeleted()) {
            NodeData nData = (NodeData)changedItem.getData();
            try {
                this.validateMandatoryChildren(nData);
            }
            catch (ConstraintViolationException e) {
                throw e;
            }
            catch (AccessDeniedException e) {
                throw e;
            }
            catch (RepositoryException e) {
                LOG.warn((Object)("Unexpected exception. Probable wrong data. Exception message:" + e.getLocalizedMessage()));
            }
        }
    }

    public void validateMandatoryChildren(NodeData nData) throws ConstraintViolationException, AccessDeniedException, RepositoryException {
        List<ItemDefinitionData> mandatoryItemDefs = this.session.getWorkspace().getNodeTypesHolder().getManadatoryItemDefs(nData.getPrimaryTypeName(), nData.getMixinTypeNames());
        for (ItemDefinitionData itemDefinitionData : mandatoryItemDefs) {
            if (this.getItemData(nData, new QPathEntry(itemDefinitionData.getName(), 0), ItemType.UNKNOWN) != null) continue;
            throw new ConstraintViolationException("Mandatory item " + (Object)((Object)itemDefinitionData.getName()) + " not found. Node [" + nData.getQPath().getAsString() + " primary type: " + nData.getPrimaryTypeName().getAsString() + "]");
        }
    }

    void rollback(ItemData item) throws InvalidItemStateException, RepositoryException {
        PlainChangesLog slog = this.changesLog.pushLog(item.getQPath());
        SessionChangesLog changes = new SessionChangesLog(slog.getAllStates(), this.session);
        Iterator<ItemImpl> removedIter = this.invalidated.iterator();
        while (removedIter.hasNext()) {
            ItemImpl removed = removedIter.next();
            QPath removedPath = removed.getLocation().getInternalPath();
            ItemState rstate = changes.getItemState(removedPath);
            if (rstate != null) {
                ItemData persisted;
                if ((rstate.isRenamed() || rstate.isPathChanged()) && (rstate = changes.findItemState(rstate.getData().getIdentifier(), false, 4)) == null) continue;
                NodeData parent = (NodeData)this.transactionableManager.getItemData(rstate.getData().getParentIdentifier());
                if (parent != null && (persisted = this.transactionableManager.getItemData(parent, rstate.getData().getQPath().getEntries()[rstate.getData().getQPath().getEntries().length - 1], ItemType.getItemType(rstate.getData()))) != null) {
                    removed.loadData(persisted);
                }
            } else {
                ItemData persisted = this.transactionableManager.getItemData(removed.getData().getIdentifier());
                if (persisted != null) {
                    removed.loadData(persisted);
                }
            }
            removedIter.remove();
        }
    }

    void refresh(ItemData item) throws InvalidItemStateException, RepositoryException {
        if (!this.isModified(item) && this.itemsPool.contains(item.getIdentifier())) {
            NodeData parent;
            ItemData persisted = this.transactionableManager.getItemData(item.getIdentifier());
            if (persisted == null && (parent = (NodeData)this.transactionableManager.getItemData(item.getParentIdentifier())) != null) {
                QPathEntry[] path = item.getQPath().getEntries();
                persisted = this.transactionableManager.getItemData(parent, path[path.length - 1], ItemType.getItemType(item));
            }
            if (persisted != null) {
                this.itemsPool.reload(item.getIdentifier(), persisted);
                for (ItemImpl pooled : this.itemsPool.getDescendats(persisted.getQPath())) {
                    NodeData parent2;
                    persisted = this.transactionableManager.getItemData(pooled.getInternalIdentifier());
                    if (persisted == null && (parent2 = (NodeData)this.transactionableManager.getItemData(pooled.getParentIdentifier())) != null) {
                        QPathEntry[] path = pooled.getData().getQPath().getEntries();
                        persisted = this.transactionableManager.getItemData(parent2, path[path.length - 1], ItemType.getItemType(pooled.getData()));
                    }
                    if (persisted == null) continue;
                    this.itemsPool.reload(pooled.getInternalIdentifier(), persisted);
                }
            } else {
                throw new InvalidItemStateException("An item is transient only or removed (either by this session or another) " + this.session.getLocationFactory().createJCRPath(item.getQPath()).getAsString(false));
            }
        }
    }

    protected ItemReferencePool getItemsPool() {
        return this.itemsPool;
    }

    protected SessionChangesLog getChangesLog() {
        return this.changesLog;
    }

    protected List<? extends ItemData> mergeNodes(ItemData rootData, List<NodeData> persistChildNodes) throws RepositoryException {
        Collection<ItemState> transientDescendants = this.changesLog.getLastChildrenStates(rootData, true);
        if (!transientDescendants.isEmpty()) {
            LinkedHashMap<String, ItemData> descendants = new LinkedHashMap<String, ItemData>();
            int length = persistChildNodes.size();
            for (int i = 0; i < length; ++i) {
                NodeData childNode = persistChildNodes.get(i);
                descendants.put(childNode.getIdentifier(), childNode);
            }
            for (ItemState state : transientDescendants) {
                ItemData data = state.getData();
                if (!state.isDeleted()) {
                    descendants.put(data.getIdentifier(), data);
                    continue;
                }
                descendants.remove(data.getIdentifier());
            }
            Collection desc = descendants.values();
            return new ArrayList(desc);
        }
        return persistChildNodes;
    }

    protected List<? extends ItemData> mergeNodes(ItemData rootData, DataManager dataManager) throws RepositoryException {
        Collection<ItemState> transientDescendants = this.changesLog.getLastChildrenStates(rootData, true);
        if (!transientDescendants.isEmpty()) {
            LinkedHashMap<String, ItemData> descendants = new LinkedHashMap<String, ItemData>();
            this.traverseStoredDescendants(rootData, dataManager, 1, descendants, false, transientDescendants);
            for (ItemState state : transientDescendants) {
                ItemData data = state.getData();
                if (!state.isDeleted()) {
                    descendants.put(data.getIdentifier(), data);
                    continue;
                }
                descendants.remove(data.getIdentifier());
            }
            Collection desc = descendants.values();
            return new ArrayList(desc);
        }
        if (this.isNew(rootData.getIdentifier())) {
            return Collections.emptyList();
        }
        return dataManager.getChildNodesData((NodeData)rootData);
    }

    protected List<? extends ItemData> mergeProps(ItemData rootData, List<PropertyData> childProperties, DataManager dataManager) throws RepositoryException {
        Collection<ItemState> transientDescendants = this.changesLog.getLastChildrenStates(rootData, false);
        if (!transientDescendants.isEmpty()) {
            LinkedHashMap<String, ItemData> descendants = new LinkedHashMap<String, ItemData>();
            int length = childProperties.size();
            block0: for (int i = 0; i < length; ++i) {
                ItemData childProp = childProperties.get(i);
                for (ItemState transientState : transientDescendants) {
                    if (transientState.isNode() || transientState.isDeleted() || transientState.getData().getQPath().getDepth() != childProp.getQPath().getDepth() || !transientState.getData().getQPath().getName().equals((Object)childProp.getQPath().getName())) continue;
                    continue block0;
                }
                descendants.put(childProp.getIdentifier(), childProp);
            }
            for (ItemState state : transientDescendants) {
                ItemData data = state.getData();
                if (!state.isDeleted()) {
                    descendants.put(data.getIdentifier(), data);
                    continue;
                }
                descendants.remove(data.getIdentifier());
            }
            Collection desc = descendants.values();
            return new ArrayList(desc);
        }
        return childProperties;
    }

    protected List<? extends ItemData> mergeProps(ItemData rootData, boolean listOnly, DataManager dataManager) throws RepositoryException {
        Collection<ItemState> transientDescendants = this.changesLog.getLastChildrenStates(rootData, false);
        if (!transientDescendants.isEmpty()) {
            LinkedHashMap<String, ItemData> descendants = new LinkedHashMap<String, ItemData>();
            this.traverseStoredDescendants(rootData, dataManager, 2, descendants, listOnly, transientDescendants);
            for (ItemState state : transientDescendants) {
                ItemData data = state.getData();
                if (!state.isDeleted()) {
                    descendants.put(data.getIdentifier(), data);
                    continue;
                }
                descendants.remove(data.getIdentifier());
            }
            Collection desc = descendants.values();
            return new ArrayList(desc);
        }
        return dataManager.getChildPropertiesData((NodeData)rootData);
    }

    protected List<? extends ItemData> mergeList(ItemData rootData, DataManager dataManager, boolean deep, int action) throws RepositoryException {
        ArrayList<ItemState> transientDescendants = new ArrayList<ItemState>();
        this.traverseTransientDescendants(rootData, action, transientDescendants);
        if (deep || !transientDescendants.isEmpty()) {
            ArrayList<Object> retval;
            LinkedHashMap<String, ItemData> descendants = new LinkedHashMap<String, ItemData>();
            this.traverseStoredDescendants(rootData, dataManager, action, descendants, true, transientDescendants);
            for (ItemState state : transientDescendants) {
                ItemData data = state.getData();
                if (!state.isDeleted()) {
                    descendants.put(data.getIdentifier(), data);
                    continue;
                }
                descendants.remove(data.getIdentifier());
            }
            Collection desc = descendants.values();
            if (deep) {
                int size = desc.size();
                retval = new ArrayList(size < 10 ? 10 : size);
                for (ItemData itemData : desc) {
                    retval.add(itemData);
                    if (!deep || !itemData.isNode()) continue;
                    retval.addAll(this.mergeList(itemData, dataManager, true, action));
                }
            } else {
                retval = new ArrayList(desc);
            }
            return retval;
        }
        return this.getStoredDescendants(rootData, dataManager, action);
    }

    private void traverseStoredDescendants(ItemData parent, DataManager dataManager, int action, Map<String, ItemData> ret, boolean listOnly, Collection<ItemState> transientDescendants) throws RepositoryException {
        if (parent.isNode() && !this.isNew(parent.getIdentifier())) {
            int i;
            int length;
            if (action != 2) {
                List<NodeData> childNodes = dataManager.getChildNodesData((NodeData)parent);
                length = childNodes.size();
                for (i = 0; i < length; ++i) {
                    NodeData childNode = childNodes.get(i);
                    ret.put(childNode.getIdentifier(), childNode);
                }
            }
            if (action != 1) {
                List<PropertyData> childProps = listOnly ? dataManager.listChildPropertiesData((NodeData)parent) : dataManager.getChildPropertiesData((NodeData)parent);
                length = childProps.size();
                block1: for (i = 0; i < length; ++i) {
                    PropertyData childProp = childProps.get(i);
                    for (ItemState transientState : transientDescendants) {
                        if (transientState.isNode() || transientState.isDeleted() || transientState.getData().getQPath().getDepth() != childProp.getQPath().getDepth() || !transientState.getData().getQPath().getName().equals((Object)childProp.getQPath().getName())) continue;
                        continue block1;
                    }
                    if (!childProp.getQPath().isDescendantOf(parent.getQPath(), true)) {
                        QPath qpath = QPath.makeChildPath(parent.getQPath(), childProp.getQPath().getName());
                        childProp = new PersistedPropertyData(childProp.getIdentifier(), qpath, childProp.getParentIdentifier(), childProp.getPersistedVersion(), childProp.getType(), childProp.isMultiValued(), childProp.getValues());
                    }
                    ret.put(childProp.getIdentifier(), childProp);
                }
            }
        }
    }

    private List<? extends ItemData> getStoredDescendants(ItemData parent, DataManager dataManager, int action) throws RepositoryException {
        if (parent.isNode()) {
            ArrayList<NodeData> childItems = null;
            List<NodeData> childNodes = dataManager.getChildNodesData((NodeData)parent);
            if (action == 1) {
                return childNodes;
            }
            childItems = new ArrayList<NodeData>(childNodes);
            List<PropertyData> childProps = dataManager.getChildPropertiesData((NodeData)parent);
            if (action == 2) {
                return childProps;
            }
            childItems.addAll(childProps);
            return childItems;
        }
        return null;
    }

    private void traverseTransientDescendants(ItemData parent, int action, List<ItemState> ret) throws RepositoryException {
        if (parent.isNode()) {
            if (action != 2) {
                Collection<ItemState> childNodes = this.changesLog.getLastChildrenStates(parent, true);
                for (ItemState childNode : childNodes) {
                    ret.add(childNode);
                }
            }
            if (action != 1) {
                Collection<ItemState> childProps = this.changesLog.getLastChildrenStates(parent, false);
                for (ItemState childProp : childProps) {
                    ret.add(childProp);
                }
            }
        }
    }

    private void reloadDescendants(QPath parentOld, QPath parent) throws RepositoryException {
        List<ItemImpl> items = this.itemsPool.getDescendats(parentOld);
        for (ItemImpl item : items) {
            ItemData oldItemData = item.getData();
            ItemData newItemData = this.updatePath(parentOld, parent, oldItemData);
            ItemImpl reloadedItem = this.reloadItem(newItemData);
            if (reloadedItem == null) continue;
            this.invalidated.add(reloadedItem);
        }
    }

    private ItemData updatePathIfNeeded(ItemData data) throws IllegalPathException {
        if (data == null || this.changesLog.getAllPathsChanged() == null) {
            return data;
        }
        List<ItemState> states = this.changesLog.getAllPathsChanged();
        int length = states.size();
        for (int i = 0; i < length; ++i) {
            ItemState state = states.get(i);
            if (!data.getQPath().isDescendantOf(state.getOldPath())) continue;
            data = this.updatePath(state.getOldPath(), state.getData().getQPath(), data);
        }
        return data;
    }

    private ItemData updatePath(QPath parentOld, QPath parent, ItemData oldItemData) throws IllegalPathException {
        TransientItemData newItemData;
        int relativeDegree = oldItemData.getQPath().getDepth() - parentOld.getDepth();
        QPath newQPath = QPath.makeChildPath(parent, oldItemData.getQPath().getRelPath(relativeDegree));
        if (oldItemData.isNode()) {
            NodeData oldNodeData = (NodeData)oldItemData;
            newItemData = new TransientNodeData(newQPath, oldNodeData.getIdentifier(), oldNodeData.getPersistedVersion(), oldNodeData.getPrimaryTypeName(), oldNodeData.getMixinTypeNames(), oldNodeData.getOrderNumber(), oldNodeData.getParentIdentifier(), oldNodeData.getACL());
        } else {
            PropertyData oldPropertyData = (PropertyData)oldItemData;
            newItemData = new TransientPropertyData(newQPath, oldPropertyData.getIdentifier(), oldPropertyData.getPersistedVersion(), oldPropertyData.getType(), oldPropertyData.getParentIdentifier(), oldPropertyData.isMultiValued(), oldPropertyData.getValues());
        }
        return newItemData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathSorter
    implements Comparator<ItemState> {
        private PathSorter() {
        }

        @Override
        public int compare(ItemState i1, ItemState i2) {
            return -i1.getData().getQPath().compareTo(i2.getData().getQPath());
        }
    }

    private class SessionItemFactory {
        private SessionItemFactory() {
        }

        private ItemImpl createItem(ItemData data, NodeData parent) throws RepositoryException {
            if (data.isNode()) {
                return this.createNode((NodeData)data, parent);
            }
            return this.createProperty(data, parent);
        }

        private NodeImpl createNode(NodeData data, NodeData parent) throws RepositoryException {
            NodeImpl node = new NodeImpl(data, parent, SessionDataManager.this.session);
            if (data.getPrimaryTypeName().equals((Object)Constants.NT_VERSION)) {
                return new VersionImpl(data, SessionDataManager.this.session);
            }
            if (data.getPrimaryTypeName().equals((Object)Constants.NT_VERSIONHISTORY)) {
                return new VersionHistoryImpl(data, SessionDataManager.this.session);
            }
            return node;
        }

        private PropertyImpl createProperty(ItemData data, NodeData parent) throws RepositoryException {
            return new PropertyImpl(data, parent, SessionDataManager.this.session);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ItemReferencePool {
        private WeakHashMap<String, WeakReference<ItemImpl>> items = new WeakHashMap();

        ItemReferencePool() {
        }

        ItemImpl remove(String identifier) {
            WeakReference<ItemImpl> weakItem = this.items.remove(identifier);
            return weakItem != null ? (ItemImpl)weakItem.get() : null;
        }

        Collection<ItemImpl> getAll() {
            ArrayList<ItemImpl> list = new ArrayList<ItemImpl>();
            for (WeakReference<ItemImpl> weakItem : this.items.values()) {
                if (weakItem == null) continue;
                list.add((ItemImpl)weakItem.get());
            }
            return list;
        }

        int size() {
            return this.items.size();
        }

        boolean contains(String identifier) {
            return this.items.containsKey(identifier);
        }

        ItemImpl get(ItemData newData) throws RepositoryException {
            return this.get(newData, null);
        }

        ItemImpl get(ItemData newData, NodeData parent) throws RepositoryException {
            ItemImpl item;
            String identifier = newData.getIdentifier();
            WeakReference<ItemImpl> weakItem = this.items.get(identifier);
            ItemImpl itemImpl = item = weakItem != null ? (ItemImpl)weakItem.get() : null;
            if (item != null) {
                item.loadData(newData, parent);
            } else {
                item = SessionDataManager.this.itemFactory.createItem(newData, parent);
                this.items.put(item.getInternalIdentifier(), new WeakReference<ItemImpl>(item));
            }
            return item;
        }

        ItemImpl reload(ItemData itemData) throws RepositoryException {
            return this.reload(itemData.getIdentifier(), itemData);
        }

        ItemImpl reload(String identifier, ItemData newItemData) throws RepositoryException {
            ItemImpl item;
            WeakReference<ItemImpl> weakItem = this.items.get(identifier);
            ItemImpl itemImpl = item = weakItem != null ? (ItemImpl)weakItem.get() : null;
            if (item != null) {
                item.loadData(newItemData);
                return item;
            }
            return null;
        }

        List<ItemImpl> getDescendats(QPath parentPath) {
            ArrayList<ItemImpl> desc = new ArrayList<ItemImpl>();
            Collection<ItemImpl> snapshort = this.getAll();
            for (ItemImpl pitem : snapshort) {
                if (pitem == null || !pitem.getData().getQPath().isDescendantOf(parentPath)) continue;
                desc.add(pitem);
            }
            return desc;
        }

        String dump() {
            StringBuilder str = new StringBuilder("Items Pool: \n");
            try {
                for (ItemImpl item : this.getAll()) {
                    if (item == null) continue;
                    str.append(item.isNode() ? "Node\t\t" : "Property\t");
                    str.append("\t").append(item.isValid());
                    str.append("\t").append(item.isNew());
                    str.append("\t").append(item.getInternalIdentifier());
                    str.append("\t").append(item.getPath()).append("\n");
                }
            }
            catch (RepositoryException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return str.toString();
        }
    }
}

