/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.version;

import java.util.Stack;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataTraversingVisitor;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ChildVersionRemoveVisitor
extends ItemDataTraversingVisitor {
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.ChildVersionRemoveVisitor");
    protected final Stack<NodeData> parents = new Stack();
    protected final NodeTypeDataManager nodeTypeDataManager;
    protected final QPath ancestorToSave;
    protected final QPath containingHistory;

    public ChildVersionRemoveVisitor(ItemDataConsumer dataManager, NodeTypeDataManager nodeTypeDataManager, QPath containingHistory, QPath ancestorToSave) {
        super(dataManager);
        this.ancestorToSave = ancestorToSave;
        this.containingHistory = containingHistory;
        this.nodeTypeDataManager = nodeTypeDataManager;
    }

    protected SessionDataManager dataManager() {
        return (SessionDataManager)this.dataManager;
    }

    protected void entering(PropertyData property, int level) throws RepositoryException {
        if (property.getQPath().getName().equals((Object)Constants.JCR_CHILDVERSIONHISTORY) && this.nodeTypeDataManager.isNodeType(Constants.NT_VERSIONEDCHILD, this.parents.peek().getPrimaryTypeName(), this.parents.peek().getMixinTypeNames())) {
            String vhID = ValueDataUtil.getString(property.getValues().get(0));
            this.dataManager().removeVersionHistory(vhID, this.containingHistory, this.ancestorToSave);
        }
    }

    protected void entering(NodeData node, int level) throws RepositoryException {
        this.parents.push(node);
    }

    protected void leaving(PropertyData property, int level) throws RepositoryException {
    }

    protected void leaving(NodeData node, int level) throws RepositoryException {
        this.parents.pop();
    }
}

