/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIFormInputBase;

public class UIFormRichtextInput
extends UIFormInputBase<String> {
    public static final String FULL_TOOLBAR = "CompleteWCM";
    public static final String BASIC_TOOLBAR = "Basic";
    public static final String SUPER_BASIC_TOOLBAR = "SuperBasicWCM";
    public static final String INLINE_TOOLBAR = "InlineEdit";
    public static final String FORUM_TOOLBAR = "Forum";
    public static final String FAQ_TOOLBAR = "FAQ";
    public static final String ENTER_P = "1";
    public static final String ENTER_BR = "2";
    public static final String ENTER_DIV = "3";
    private String width;
    private String height;
    private String toolbar;
    private String enterMode;
    private String css;
    private boolean isPasteAsPlainText = false;

    public UIFormRichtextInput(String name, String bindingField, String value) {
        super(name, bindingField, String.class);
        this.value_ = value;
    }

    public UIFormRichtextInput(String name, String bindingField, String value, String enterMode) {
        super(name, bindingField, String.class);
        this.value_ = value;
        this.enterMode = enterMode;
    }

    public UIFormRichtextInput(String name, String bindingField, String value, String enterMode, String toolbar) {
        super(name, bindingField, String.class);
        this.value_ = value;
        this.enterMode = enterMode;
        this.toolbar = toolbar;
    }

    public UIFormRichtextInput(String name, String bindingField, String value, String enterMode, String toolbar, String css) {
        super(name, bindingField, String.class);
        this.value_ = value;
        this.enterMode = enterMode;
        this.toolbar = toolbar;
        this.css = css;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getToolbar() {
        return this.toolbar;
    }

    public String getEnterMode() {
        return this.enterMode;
    }

    public void setToolbar(String toolbar) {
        this.toolbar = toolbar;
    }

    public void setEnterMode(String enterMode) {
        this.enterMode = enterMode;
    }

    public void setIsPasteAsPlainText(boolean isPasteAsPlainText) {
        this.isPasteAsPlainText = isPasteAsPlainText;
    }

    public boolean getIsPasteAsPlainText() {
        return this.isPasteAsPlainText;
    }

    public void setCss(String css) {
        this.css = css;
    }

    public String getCss() {
        return this.css;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.toolbar == null) {
            this.toolbar = BASIC_TOOLBAR;
        }
        if (this.width == null) {
            this.width = "98%";
        }
        if (this.height == null) {
            this.height = "'200px'";
        }
        if (this.enterMode == null) {
            this.enterMode = ENTER_P;
        }
        if (this.css == null) {
            this.css = "'/CommonsResources/ckeditor/contents.css'";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<div>");
        buffer.append("<span style='float:left; width:" + this.width + ";'>");
        if (this.value_ != null) {
            buffer.append("<textarea id='" + this.name + "' name='" + this.name + "'>" + (String)this.value_ + "</textarea>\n");
        } else {
            buffer.append("<textarea id='" + this.name + "' name='" + this.name + "'></textarea>\n");
        }
        buffer.append("<script type='text/javascript'>\n");
        buffer.append("    require(['/CommonsResources/ckeditor/ckeditor.js'], function() {");
        buffer.append("  //<![CDATA[\n");
        buffer.append("    var instance = CKEDITOR.instances['" + this.name + "']; if (instance) { CKEDITOR.remove(instance); instance = null;}\n");
        if (this.isPasteAsPlainText) {
            buffer.append("    CKEDITOR.replace('" + this.name + "', {toolbar:'" + this.toolbar + "', height:" + this.height + ", forcePasteAsPlainText: true, contentsCss:" + this.css + ", enterMode:" + this.enterMode + ", shiftEnterMode:" + this.enterMode + "});\n");
        } else {
            buffer.append("    CKEDITOR.replace('" + this.name + "', {toolbar:'" + this.toolbar + "', height:" + this.height + ", contentsCss:" + this.css + ", enterMode:" + this.enterMode + ", shiftEnterMode:" + this.enterMode + "});\n");
        }
        buffer.append("    instance = CKEDITOR.instances['" + this.name + "']; instance.on( 'change', function(e) { document.getElementById('" + this.name + "').value = instance.getData(); }); \n");
        buffer.append("       });");
        buffer.append("  //]]>\n");
        buffer.append("</script>\n");
        buffer.append("</span>");
        if (this.isMandatory()) {
            buffer.append("<span style='float:left'> &nbsp;*</span>");
        }
        buffer.append("</div>");
        context.getWriter().write(buffer.toString());
    }

    public void decode(Object input, WebuiRequestContext context) {
        this.value_ = (String)input;
        if (this.value_ != null && ((String)this.value_).length() == 0) {
            this.value_ = null;
        }
    }
}

