/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.jcr.Node;
import javax.jcr.Session;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.NumberList;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.UtcOffset;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.WeekDayList;
import net.fortuna.ical4j.model.component.Daylight;
import net.fortuna.ical4j.model.component.Standard;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.TzId;
import net.fortuna.ical4j.model.property.TzName;
import net.fortuna.ical4j.model.property.TzOffsetFrom;
import net.fortuna.ical4j.model.property.TzOffsetTo;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.impl.NewUserListener;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.quartz.JobExecutionContext;
import org.quartz.impl.JobDetailImpl;

public class Utils {
    public static final String EXO_ID = "exo:id";
    public static final String EXO_LABEL = "exo:label";
    public static final String EXO_NAME = "exo:name";
    public static final String EXO_DESCRIPTION = "exo:description";
    public static final String EXO_EVENT_ID = "exo:eventId";
    public static final String EXO_EVENT_CATEGORYID = "exo:eventCategoryId";
    public static final String EXO_EVENT_CATEGORY_NAME = "exo:eventCategoryName";
    public static final String EXO_TASK_DELEGATOR = "exo:taskDelegator";
    public static final String EXO_REPEAT = "exo:repeat";
    public static final String EXO_EVENT_TYPE = "exo:eventType";
    public static final String EXO_PRIORITY = "exo:priority";
    public static final String EXO_IS_PRIVATE = "exo:isPrivate";
    public static final String EXO_EVENT_STATE = "exo:eventState";
    public static final String EXO_INVITATION = "exo:invitation";
    public static final String EXO_CALENDAR_EVENT = "exo:calendarEvent";
    public static final String EXO_REMINDER_TYPE = "exo:reminderType";
    public static final String EXO_ALARM_BEFORE = "exo:alarmBefore";
    public static final String EXO_EMAIL = "exo:email";
    public static final String EXO_OWNER = "exo:creator";
    public static final String EXO_REMINDER = "exo:reminder";
    public static final String EXO_FROM_DATE_TIME = "exo:fromDateTime";
    public static final String EXO_TO_DATE_TIME = "exo:toDateTime";
    public static final String EXO_SUMMARY = "exo:summary";
    public static final String EXO_IS_REPEAT = "exo:isRepeat";
    public static final String EXO_IS_OVER = "exo:isOver";
    public static final String EXO_CALENDAR_PUBLIC_EVENT = "exo:calendarPublicEvent";
    public static final String EXO_EVENT_CATEGORY = "exo:eventCategory";
    public static final String EXO_PUBLIC_URL = "exo:publicUrl";
    public static final String EXO_PRIVATE_URL = "exo:privateUrl";
    public static final String EXO_DATA = "exo:data";
    public static final String EXO_ICAL_DATA = "exo:iCalData";
    public static final String EXO_TITLE = "exo:title";
    public static final String EXO_CONTENT = "exo:content";
    public static final String EXO_CALENDAR_SETTING = "exo:calendarSetting";
    public static final String EXO_IS_SHOW_WORKING_TIME = "exo:showWorkingTime";
    public static final String EXO_WORKING_BEGIN = "exo:workingTimeBegin";
    public static final String EXO_WORKING_END = "exo:workingTimeEnd";
    public static final String EXO_PRIVATE_CALENDARS = "exo:defaultPrivateCalendars";
    public static final String EXO_PUBLIC_CALENDARS = "exo:defaultPublicCalendars";
    public static final String EXO_SHARED_CALENDARS = "exo:defaultSharedCalendars";
    public static final String EXO_SHARED_CALENDAR_COLORS = "exo:sharedCalendarsColors";
    public static final String EXO_EVEN_TATTACHMENT = "exo:eventAttachment";
    public static final String EXO_FILE_NAME = "exo:fileName";
    public static final String EXO_CATEGORY_ID = "exo:categoryId";
    public static final String EXO_VIEW_PERMISSIONS = "exo:viewPermissions";
    public static final String EXO_EDIT_PERMISSIONS = "exo:editPermissions";
    public static final String EXO_GROUPS = "exo:groups";
    public static final String EXO_LOCALE = "exo:locale";
    public static final String EXO_TIMEZONE = "exo:timeZone";
    public static final String EXO_CALENDAR_ID = "exo:calendarId";
    public static final String EXO_SHARED_MIXIN = "exo:calendarShared";
    public static final String EXO_SHARED_ID = "exo:sharedId";
    public static final String EXO_PARTICIPANT = "exo:participant";
    public static final String EXO_CALENDAR = "exo:calendar";
    public static final String EXO_CALENDAR_COLOR = "exo:calendarColor";
    public static final String EXO_CALENDAR_CATEGORY = "exo:calendarCategory";
    public static final String EXO_CALENDAR_OWNER = "exo:calendarOwner";
    public static final String EXO_SHARED_COLOR = "exo:sharedColor";
    public static final String EXO_VIEW_TYPE = "exo:viewType";
    public static final String EXO_TIME_INTERVAL = "exo:timeInterval";
    public static final String EXO_WEEK_START_ON = "exo:weekStartOn";
    public static final String EXO_DATE_FORMAT = "exo:dateFormat";
    public static final String EXO_TIME_FORMAT = "exo:timeFormat";
    public static final String EXO_LOCATION = "exo:location";
    public static final String EXO_REMINDER_DATE = "exo:remindDateTime";
    public static final String EXO_ROOT_EVENT_ID = "exo:rootEventId";
    public static final String EXO_RSS_DATA = "exo:rssData";
    public static final String EXO_BASE_URL = "exo:baseUrl";
    public static final String EXO_SEND_OPTION = "exo:sendOption";
    public static final String EXO_MESSAGE = "exo:message";
    public static final String EXO_PARTICIPANT_STATUS = "exo:participantStatus";
    public static final String EXO_DATE_MODIFIED = "exo:dateModified";
    public static final String EXO_REMOTE_MIXIN = "exo:remoteCalendar";
    public static final String EXO_REMOTE_URL = "exo:remoteUrl";
    public static final String EXO_REMOTE_TYPE = "exo:remoteType";
    public static final String EXO_REMOTE_USERNAME = "exo:username";
    public static final String EXO_REMOTE_PASSWORD = "exo:password";
    public static final String EXO_REMOTE_SYNC_PERIOD = "exo:syncPeriod";
    public static final String EXO_REMOTE_LAST_UPDATED = "exo:lastUpdated";
    public static final String EXO_REMOTE_BEFORE_DATE = "exo:beforeDate";
    public static final String EXO_REMOTE_AFTER_DATE = "exo:afterDate";
    public static final String EXO_REMOTE_EVENT_MIXIN = "exo:caldavCalendarEvent";
    public static final String EXO_CALDAV_HREF = "exo:caldavHref";
    public static final String EXO_CALDAV_ETAG = "exo:caldavEtag";
    public static final String EXO_REPEAT_CALENDAR_EVENT = "exo:repeatCalendarEvent";
    public static final String EXO_REPEAT_COUNT = "exo:repeatCount";
    public static final String EXO_REPEAT_UNTIL = "exo:repeatUntil";
    public static final String EXO_RECURRENCE_ID = "exo:recurrenceId";
    public static final String EXO_IS_EXCEPTION = "exo:isException";
    public static final String EXO_EXCLUDE_ID = "exo:excludeId";
    public static final String EXO_ORIGINAL_REFERENCE = "exo:originalReference";
    public static final String EXO_REPEAT_INTERVAL = "exo:repeatInterval";
    public static final String EXO_REPEAT_BYDAY = "exo:repeatByDay";
    public static final String EXO_REPEAT_BYMONTHDAY = "exo:repeatByMonthDay";
    public static final String EXO_REPEAT_FINISH_DATE = "exo:repeatFinishDate";
    public static final String EXO_DATE_CREATED = "exo:dateCreated";
    public static final String X_STATUS = "X-STATUS";
    public static final String ATTACHMENT_NODE = "attachment";
    public static final String REMINDERS_NODE = "reminders";
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String NT_FILE = "nt:file";
    public static final String NT_RESOURCE = "nt:resource";
    public static final String MIX_REFERENCEABLE = "mix:referenceable";
    public static final String JCR_LASTMODIFIED = "jcr:lastModified";
    public static final String JCR_CONTENT = "jcr:content";
    public static final String JCR_MIMETYPE = "jcr:mimeType";
    public static final String JCR_DATA = "jcr:data";
    public static final String JCR_SCORE = "jcr:score";
    public static final String MIMETYPE_TEXTPLAIN = "text/plain";
    public static final String MIMETYPE_ICALENDAR = "TEXT/CALENDAR";
    public static final String ATTACHMENT = "ATTACHMENT";
    public static final String INLINE = "INLINE";
    public static final String COMMA = ",";
    public static final String COLON = ":";
    public static final String SLASH = "/";
    public static final String UNDERSCORE = "_";
    public static final String SLASH_COLON = "/:";
    public static final String COLON_SLASH = ":/";
    public static final String ANY = "*.*";
    public static final String ANY_OF = "*.";
    public static final String SLASH_AST = "/*";
    public static final String MINUS = "-";
    public static final String CALENDAR_REMINDER = "reminders";
    public static final String CALENDAR_APP = "CalendarApplication";
    public static final int DENY = 0;
    public static final int ACCEPT = 1;
    public static final int NOTSURE = 2;
    public static final int ACCEPT_IMPORT = 3;
    public static final int JUMP_TO_CALENDAR = 4;
    public static final String RSS_NODE = "iCalendars";
    public static final String CALDAV_NODE = "WebDavCalendars";
    public static final String ICS_EXT = ".ics";
    public static final String RSS_EXT = ".rss";
    public static final String EMPTY_STR = "";
    public static final String STATUS_PENDING = "pending";
    public static final String STATUS_YES = "yes";
    public static final String STATUS_NO = "no";
    public static final int INVALID_TYPE = -1;
    public static final int PRIVATE_TYPE = 0;
    public static final int SHARED_TYPE = 1;
    public static final int PUBLIC_TYPE = 2;
    public static final String SPLITTER = "splitter";
    public static final String ASCENDING = "ascending";
    public static final String DESCENDING = "descending";
    public static final String SPACE = " ";
    public static final String RESOURCEBUNDLE_NAME = "locale.portlet.calendar.CalendarPortlet";
    public static int EVENT_NUMBER = -1;
    public static final String SYNC_AUTO = "auto";
    public static final String SYNC_5MINS = "5mins";
    public static final String SYNC_10MINS = "10mins";
    public static final String SYNC_15MINS = "15mins";
    public static final String SYNC_1HOUR = "1hour";
    public static final String SYNC_1DAY = "1day";
    public static final String SYNC_1WEEK = "1week";
    public static final String SYNC_1YEAR = "1year";
    public static final String MIMETYPE_TEXTHTML = "text/html";
    public static String[] SYNC_PERIOD = new String[]{"auto", "5mins", "10mins", "15mins", "1hour", "1day", "1week", "1year"};
    public static final String SHARE_CALENDAR_GROUP = "CS-ShareCalenar";
    public static final String DELETE_SHARED_GROUP = "CS-DeleteShare";
    public static final String SHARED_GROUPS = "sharedGroups";
    public static final String USER_NAME = "userName";
    public static final String CALENDAR_ID = "calendarId";
    public static final String JCR_DATA_STORAGE = "JCRDataStorage";
    public static final String SHARE_CAL_CHANEL = "/eXo/Application/Calendar/notifyShareCalendar";
    public static final String REMOVED_USERS = "removedUsers";
    public static final String START_SHARE = "startShare";
    public static final String FINISH_SHARE = "finishShare";
    public static final String START_UN_SHARE = "startUnShare";
    public static final String FINISH_UN_SHARE = "finishUnShare";
    public static final String ERROR_SHARE = "errorShare";
    public static final String ERROR_UN_SHARE = "errorUnShare";
    public static final String DETAIL_PATH = "details";
    public static final String DUE_FOR = "Due for: ";
    public static final String ORDER_TYPE_ASCENDING = "ASC";
    public static final String ORDER_TYPE_DESCENDING = "DESC";
    public static final String DOT = ".";
    public static String ORDERBY_RELEVANCY = "relevancy";
    public static String ORDERBY_DATE = "date";
    public static String ORDERBY_TITLE = "title";
    public static String DATE_TIME_FORMAT = "EEEEE, MMMMMMMM d, yyyy K:mm a";
    public static String JCR_EXCERPT = "excerpt(.)";
    public static String JCR_EXCERPT_ROW = "rep:excerpt(.)";
    public static String DATE_FORMAT_RECUR_ID = "yyyyMMdd'T'HHmmss'Z'";
    public static final Map<String, String> SORT_FIELD_MAP = new LinkedHashMap<String, String>(){
        {
            this.put(ORDERBY_RELEVANCY, Utils.JCR_SCORE);
            this.put(ORDERBY_DATE, Utils.EXO_DATE_CREATED);
            this.put(ORDERBY_TITLE, Utils.EXO_SUMMARY);
        }
    };
    public static final String[] SELECT_FIELDS = new String[]{JCR_EXCERPT, "exo:summary", "exo:description", "exo:location", "exo:fromDateTime", "exo:toDateTime", "exo:eventState", "exo:isPrivate", "exo:dateCreated", "jcr:score", "exo:id", "exo:calendarId", "exo:eventType"};
    public static String[] SEARCH_FIELDS = new String[]{"exo:summary", "exo:description", "exo:location"};
    public static String EVENT_ICON_URL = null;
    public static String TASK_ICON_URL = "/social-resources/skin/images/Activity/status-task.png";
    public static final String DEFAULT_SITENAME = "intranet";
    public static final String PAGE_NAGVIGATION = "calendar";
    public static final String NONE_NAGVIGATION = "#";
    public static final String PORTLET_NAME = "CalendarPortlet";
    public static final String SPACES_GROUP = "spaces";
    public static final String SPACES_GROUP_ID_PREFIX = "/spaces/";
    public static final String SPACE_CALENDAR_ID_SUFFIX = "_space_calendar";

    public static GregorianCalendar getInstanceTempCalendar() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        return calendar;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean canEdit(OrganizationService oService, String[] savePerms, String username) throws Exception {
        StringBuffer sb = new StringBuffer(username);
        if (oService != null) {
            Collection groups = oService.getGroupHandler().findGroupsOfUser(username);
            for (Group g : groups) {
                sb.append(COMMA).append(g.getId()).append(SLASH_COLON).append(ANY);
                sb.append(COMMA).append(g.getId()).append(SLASH_COLON).append(username);
                Collection memberShipsType = oService.getMembershipHandler().findMembershipsByUserAndGroup(username, g.getId());
                for (Membership mp : memberShipsType) {
                    sb.append(COMMA).append(g.getId()).append(SLASH_COLON).append(ANY_OF + mp.getMembershipType());
                }
            }
        }
        return Utils.hasEditPermission(savePerms, sb.toString().split(COMMA));
    }

    public static boolean isMemberShipType(Collection<Membership> mbsh, String value) {
        if (!Utils.isEmpty(value)) {
            for (String check : value.split(COMMA)) {
                if ((check = check.trim()).lastIndexOf(ANY_OF) <= -1) continue;
                if (ANY.equals(check)) {
                    return true;
                }
                value = check.substring(check.lastIndexOf(ANY_OF) + ANY_OF.length());
                if (mbsh == null || mbsh.isEmpty()) continue;
                for (Membership mb : mbsh) {
                    if (!mb.getMembershipType().equals(value)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasEditPermission(String[] savePerms, String[] checkPerms) {
        if (savePerms != null) {
            for (String sp : savePerms) {
                for (String cp : checkPerms) {
                    if (!sp.equals(cp)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getDefaultCalendarId(String username) {
        return username + MINUS + NewUserListener.defaultCalendarId;
    }

    public static PortalContainer getPortalContainer(JobExecutionContext context) {
        if (context == null) {
            return null;
        }
        String portalName = ((JobDetailImpl)context.getJobDetail()).getGroup();
        if (portalName == null) {
            return null;
        }
        if (portalName.indexOf(COLON) > 0) {
            portalName = portalName.substring(0, portalName.indexOf(COLON));
        }
        return RootContainer.getInstance().getPortalContainer(portalName);
    }

    public static String getDisplaySharedCalendar(String sharedUserId, String calName) {
        return sharedUserId + MINUS + SPACE + calName;
    }

    public static String getDisplayGroupCalendar(String groupId, String calName) {
        return groupId.substring(groupId.lastIndexOf(SLASH) + 1) + MINUS + calName;
    }

    public static String[] getEditPerUsers(Calendar calendar) throws Exception {
        ArrayList<String> sharedUsers = new ArrayList<String>();
        OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        if (calendar.getEditPermission() != null) {
            for (String editPer : calendar.getEditPermission()) {
                if (editPer.contains(SLASH)) {
                    sharedUsers.addAll(Utils.getUsersCanEdit(editPer));
                    continue;
                }
                sharedUsers.add(editPer);
            }
        }
        return sharedUsers.toArray(new String[sharedUsers.size()]);
    }

    public static java.util.Calendar getGreenwichMeanTime() {
        java.util.Calendar calendar = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() - (long)gmtoffset);
        return calendar;
    }

    public static boolean isSameDate(java.util.Date value1, java.util.Date value2) {
        GregorianCalendar date1 = Utils.getInstanceTempCalendar();
        date1.setTime(value1);
        GregorianCalendar date2 = Utils.getInstanceTempCalendar();
        date2.setTime(value2);
        return date1.get(5) == date2.get(5) && date1.get(2) == date2.get(2) && date1.get(1) == date2.get(1);
    }

    public static boolean isRepeatEvent(CalendarEvent event) throws Exception {
        return event.getRepeatType() != null && !CalendarEvent.RP_NOREPEAT.equals(event.getRepeatType());
    }

    public static boolean isExceptionOccurrence(CalendarEvent event) throws Exception {
        return event.getIsExceptionOccurrence() != null && event.getIsExceptionOccurrence() == true;
    }

    public static boolean isOccurrence(CalendarEvent event) {
        return event.getRepeatType() != null && !CalendarEvent.RP_NOREPEAT.equals(event.getRepeatType()) && (event.getIsExceptionOccurrence() == null || event.getIsExceptionOccurrence() == false);
    }

    public static Node getPublicServiceHome(SessionProvider provider) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)container.getComponentInstanceOfType(NodeHierarchyCreator.class);
        Node publicApp = nodeHierarchyCreator.getPublicApplicationNode(provider);
        if (publicApp != null && publicApp.hasNode(CALENDAR_APP)) {
            return publicApp.getNode(CALENDAR_APP);
        }
        return null;
    }

    public static Session getSession(SessionProvider sprovider) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository currentRepo = repositoryService.getCurrentRepository();
        return sprovider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
    }

    public static SessionProvider createSystemProvider() {
        SessionProviderService sessionProviderService = (SessionProviderService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SessionProviderService.class);
        return sessionProviderService.getSystemSessionProvider(null);
    }

    public static String buildMessageToSend(String type, String calendarName, List<String> groups, OrganizationService oService) throws Exception {
        StringBuilder sb = new StringBuilder(EMPTY_STR);
        sb.append(type);
        sb.append(COMMA);
        sb.append(calendarName);
        Iterator<String> it = groups.iterator();
        while (it.hasNext()) {
            sb.append(COMMA);
            String groupId = it.next();
            Group group = oService.getGroupHandler().findGroupById(groupId);
            sb.append(group.getGroupName());
        }
        return sb.toString();
    }

    public static java.util.Calendar getBeginDay(java.util.Calendar cal) {
        java.util.Calendar newCal = (java.util.Calendar)cal.clone();
        newCal.set(11, 0);
        newCal.set(12, 0);
        newCal.set(13, 0);
        newCal.set(14, 0);
        return newCal;
    }

    public static java.util.Calendar getEndDay(java.util.Calendar cal) {
        java.util.Calendar newCal = (java.util.Calendar)cal.clone();
        newCal.set(11, 0);
        newCal.set(12, 0);
        newCal.set(13, 0);
        newCal.set(14, 0);
        newCal.add(11, 24);
        return newCal;
    }

    public static Set<String> getUserByMembershipId(String membershipId, String groupId) throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getInstance().getComponentInstance(OrganizationService.class);
        List usersInGroup = organizationService.getUserHandler().findUsersByGroup(groupId).getAll();
        HashSet<String> userIds = new HashSet<String>();
        if (usersInGroup == null) {
            return userIds;
        }
        if ("*".equals(membershipId)) {
            for (User user : usersInGroup.toArray(new User[0])) {
                userIds.add(user.getUserName());
            }
            return userIds;
        }
        for (User user : usersInGroup.toArray(new User[0])) {
            Membership membership = organizationService.getMembershipHandler().findMembershipByUserGroupAndType(user.getUserName(), groupId, membershipId);
            if (membership == null) continue;
            userIds.add(user.getUserName());
        }
        return userIds;
    }

    public static List<String> getUsersCanEdit(String editPer) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        String[] perArr = editPer.split(COLON);
        String membershipId = perArr[1].substring(2);
        String groupId = perArr[0].substring(0, perArr[0].length() - 1);
        Set<String> usersCanEdit = Utils.getUserByMembershipId(membershipId, groupId);
        result.addAll(usersCanEdit);
        return result;
    }

    public static String getCalendarIdFromSpace(String spaceGroupId) {
        StringBuilder sb = new StringBuilder(spaceGroupId.substring(SPACES_GROUP_ID_PREFIX.length()));
        sb.append(SPACE_CALENDAR_ID_SUFFIX);
        return sb.toString();
    }

    public static String getSpaceGroupIdFromCalendarId(String calendarId) {
        StringBuilder sb = new StringBuilder(SPACES_GROUP_ID_PREFIX);
        sb.append(calendarId.split(SPACE_CALENDAR_ID_SUFFIX)[0]);
        return sb.toString();
    }

    public static net.fortuna.ical4j.model.TimeZone getICalTimeZone(TimeZone jTz) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        String dtStartValue = dateFormat.format(calendar.getTime());
        PropertyList standardTzProps = new PropertyList();
        TzName standardTzName = new TzName(new ParameterList(), jTz.getDisplayName(false, 0));
        DtStart standardTzStart = new DtStart();
        standardTzStart.setValue(dtStartValue);
        TzOffsetTo standardTzOffsetTo = new TzOffsetTo();
        standardTzOffsetTo.setOffset(new UtcOffset((long)jTz.getRawOffset()));
        TzOffsetFrom standardTzOffsetFrom = new TzOffsetFrom();
        standardTzOffsetFrom.setOffset(new UtcOffset((long)(jTz.getRawOffset() + jTz.getDSTSavings())));
        standardTzProps.add((Property)standardTzName);
        standardTzProps.add((Property)standardTzStart);
        standardTzProps.add((Property)standardTzOffsetTo);
        standardTzProps.add((Property)standardTzOffsetFrom);
        Standard standardTz = new Standard(standardTzProps);
        ComponentList tzComponents = new ComponentList();
        tzComponents.add((Component)standardTz);
        if (jTz.useDaylightTime()) {
            PropertyList daylightTzProps = new PropertyList();
            TzName daylightTzName = new TzName(jTz.getDisplayName(true, 0));
            DtStart daylightDtStart = new DtStart();
            daylightDtStart.setValue(dtStartValue);
            TzOffsetTo daylightTzOffsetTo = new TzOffsetTo();
            daylightTzOffsetTo.setOffset(new UtcOffset((long)(jTz.getRawOffset() + jTz.getDSTSavings())));
            TzOffsetFrom daylightTzOffsetFrom = new TzOffsetFrom();
            daylightTzOffsetFrom.setOffset(new UtcOffset((long)jTz.getRawOffset()));
            daylightTzProps.add((Property)daylightTzOffsetFrom);
            daylightTzProps.add((Property)daylightTzOffsetTo);
            daylightTzProps.add((Property)daylightDtStart);
            daylightTzProps.add((Property)daylightTzName);
            Daylight daylightTz = new Daylight(daylightTzProps);
            tzComponents.add((Component)daylightTz);
        }
        PropertyList tzProps = new PropertyList();
        TzId tzId = new TzId(null, jTz.getID());
        tzProps.add((Property)tzId);
        VTimeZone vTz = new VTimeZone(tzProps, tzComponents);
        try {
            vTz.validate();
            return new net.fortuna.ical4j.model.TimeZone(vTz);
        }
        catch (ValidationException e) {
            return null;
        }
    }

    public static void adaptRepeatRule(Recur recur, DateTime firstOccurDate, TimeZone tz) {
        int delta;
        WeekDay[] weekdays = new WeekDay[]{WeekDay.SU, WeekDay.MO, WeekDay.TU, WeekDay.WE, WeekDay.TH, WeekDay.FR, WeekDay.SA};
        WeekDayList weekdayList = recur.getDayList();
        NumberList numberList = recur.getMonthDayList();
        java.util.Calendar calendar = java.util.Calendar.getInstance(tz);
        calendar.setTimeInMillis(firstOccurDate.getTime());
        if (weekdayList != null && weekdayList.size() > 0) {
            WeekDay expectedFirstWeekday = WeekDay.getWeekDay((java.util.Calendar)calendar);
            WeekDay firstWeekDayOfRule = (WeekDay)weekdayList.get(0);
            delta = WeekDay.getCalendarDay((WeekDay)expectedFirstWeekday) - WeekDay.getCalendarDay((WeekDay)firstWeekDayOfRule);
            if (delta != 0) {
                WeekDayList newWeekDayList = new WeekDayList();
                for (int i = 0; i < weekdayList.size(); ++i) {
                    WeekDay weekdayI = (WeekDay)weekdayList.get(i);
                    int index = (WeekDay.getCalendarDay((WeekDay)weekdayI) - 1 + delta) % 7;
                    newWeekDayList.add(weekdays[index]);
                }
                recur.getDayList().removeAll((Collection)weekdayList);
                recur.getDayList().addAll((Collection)newWeekDayList);
            }
        }
        if (numberList != null && numberList.size() > 0) {
            Integer firstDayOfRule = (Integer)numberList.get(0);
            int expectedFirstDay = calendar.get(5);
            delta = expectedFirstDay - firstDayOfRule;
            if (delta != 0) {
                NumberList newNumberList = new NumberList();
                for (int j = 0; j < numberList.size(); ++j) {
                    Integer numberI = (Integer)numberList.get(j);
                    newNumberList.add(new Integer(numberI + delta));
                }
                recur.getMonthDayList().removeAll((Collection)numberList);
                recur.getMonthDayList().addAll((Collection)newNumberList);
            }
        }
    }

    public static java.util.Date getPreviousOccurrenceDate(CalendarEvent recurEvent, java.util.Date aDate, TimeZone tz) throws Exception {
        DateTime ical4jEventFrom = new DateTime(recurEvent.getFromDateTime());
        VEvent vevent = new VEvent((Date)ical4jEventFrom, EMPTY_STR);
        Recur recur = Utils.getICalendarRecur(recurEvent);
        vevent.getProperties().add((Property)new RRule(recur));
        GregorianCalendar calendar = new GregorianCalendar();
        ((java.util.Calendar)calendar).setTimeZone(tz);
        calendar.set(1, ((java.util.Calendar)calendar).getMinimum(1));
        DateTime ical4jFrom = new DateTime(calendar.getTime());
        calendar.setTime(aDate);
        int delta = aDate.getDate() - calendar.get(5);
        ((java.util.Calendar)calendar).add(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        DateTime ical4jTo = new DateTime(calendar.getTime());
        Period period = new Period(ical4jFrom, ical4jTo);
        PeriodList list = vevent.calculateRecurrenceSet(period);
        if (list == null || list.size() == 0 || list.size() == 1) {
            return null;
        }
        Period last = (Period)list.last();
        list.remove(last);
        last = (Period)list.last();
        calendar.setTimeInMillis(last.getStart().getTime());
        ((java.util.Calendar)calendar).add(5, delta);
        return calendar.getTime();
    }

    public static Recur getICalendarRecur(CalendarEvent recurEvent) throws Exception {
        int interval;
        String repeatType = recurEvent.getRepeatType();
        int count = (int)recurEvent.getRepeatCount();
        GregorianCalendar until = null;
        if (recurEvent.getRepeatUntilDate() != null) {
            until = Utils.getInstanceTempCalendar();
            until.setTimeInMillis(recurEvent.getRepeatUntilDate().getTime() + 86400000L - 1L);
        }
        if ((interval = (int)recurEvent.getRepeatInterval()) <= 1) {
            interval = 1;
        }
        Recur recur = null;
        if (repeatType.equals(CalendarEvent.RP_DAILY)) {
            recur = until != null ? new Recur("DAILY", new Date(until.getTime())) : (count > 0 ? new Recur("DAILY", count) : new Recur("FREQ=DAILY"));
            recur.setInterval(interval);
            return recur;
        }
        if (repeatType.equals(CalendarEvent.RP_WEEKLY)) {
            recur = until != null ? new Recur("WEEKLY", new Date(until.getTime())) : (count > 0 ? new Recur("WEEKLY", count) : new Recur("FREQ=WEEKLY"));
            recur.setInterval(interval);
            String[] repeatByDay = recurEvent.getRepeatByDay();
            if (repeatByDay == null || repeatByDay.length == 0) {
                return null;
            }
            WeekDayList weekDayList = new WeekDayList();
            for (String s : repeatByDay) {
                weekDayList.add(new WeekDay(s));
            }
            recur.getDayList().addAll((Collection)weekDayList);
            return recur;
        }
        if (repeatType.equals(CalendarEvent.RP_MONTHLY)) {
            recur = until != null ? new Recur("MONTHLY", new Date(until.getTime())) : (count > 0 ? new Recur("MONTHLY", count) : new Recur("FREQ=MONTHLY"));
            recur.setInterval(interval);
            long[] repeatByMonthDay = recurEvent.getRepeatByMonthDay();
            if (repeatByMonthDay != null && repeatByMonthDay.length > 0) {
                NumberList numberList = new NumberList();
                for (long monthDay : repeatByMonthDay) {
                    numberList.add(new Integer((int)monthDay));
                }
                recur.getMonthDayList().addAll((Collection)numberList);
            } else {
                String[] repeatByDay = recurEvent.getRepeatByDay();
                if (repeatByDay != null && repeatByDay.length > 0) {
                    WeekDayList weekDayList = new WeekDayList();
                    for (String s : repeatByDay) {
                        weekDayList.add(new WeekDay(s));
                    }
                    recur.getDayList().addAll((Collection)weekDayList);
                }
            }
            return recur;
        }
        if (repeatType.equals(CalendarEvent.RP_YEARLY)) {
            recur = until != null ? new Recur("YEARLY", new Date(until.getTime())) : (count > 0 ? new Recur("YEARLY", count) : new Recur("FREQ=YEARLY"));
            recur.setInterval(interval);
            return recur;
        }
        return recur;
    }
}

