/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.identity.plugins;

import java.lang.reflect.Constructor;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.plugins.SecurityActions;

public class IdentityFactory {
    public static final String IDENTITY_CLASS = "org.jboss.security.identity.plugins.SimpleIdentity";
    public static final String PRINCIPAL_CLASS = "org.jboss.security.SimplePrincipal";
    public static final String GROUP_CLASS = "org.jboss.security.SimpleGroup";
    private static Map<String, Class<?>> clazzMap = new WeakHashMap();

    public static Principal createPrincipal(String name) throws Exception {
        return (Principal)IdentityFactory.loadClass(PRINCIPAL_CLASS, name);
    }

    public static Group createGroup(String name) throws Exception {
        return (Group)IdentityFactory.loadClass(GROUP_CLASS, name);
    }

    public static Identity createIdentity(String name) throws Exception {
        return (Identity)IdentityFactory.loadClass(IDENTITY_CLASS, name);
    }

    public static Identity createIdentity(String identityClass, String name) throws Exception {
        return (Identity)IdentityFactory.loadClass(identityClass, name);
    }

    public static Identity createIdentityWithRole(String name, String roleName) throws Exception {
        return (Identity)IdentityFactory.loadClass(IDENTITY_CLASS, name, roleName);
    }

    public static Identity createIdentityWithRole(String identityClass, String name, String roleName) throws Exception {
        return (Identity)IdentityFactory.loadClass(identityClass, name, roleName);
    }

    public static Identity createIdentityWithRole(String name, Role role) throws Exception {
        return (Identity)IdentityFactory.loadClass(IDENTITY_CLASS, name, role);
    }

    public static Identity createIdentityWithRole(String identityClass, String name, Role role) throws Exception {
        return (Identity)IdentityFactory.loadClass(identityClass, name, role);
    }

    private static Object loadClass(String className, String ctorArg) throws Exception {
        Class<?> clazz = clazzMap.get(className);
        if (clazz == null) {
            clazz = SecurityActions.getClass(className);
            clazzMap.put(className, clazz);
        }
        Constructor<?> ctr = clazz.getConstructor(String.class);
        return ctr.newInstance(ctorArg);
    }

    private static Object loadClass(String className, String ctorArg1, String ctorArg2) throws Exception {
        Class<?> clazz = clazzMap.get(className);
        if (clazz == null) {
            clazz = SecurityActions.getClass(className);
            clazzMap.put(className, clazz);
        }
        Constructor<?> ctr = clazz.getConstructor(String.class, String.class);
        return ctr.newInstance(ctorArg1, ctorArg2);
    }

    private static Object loadClass(String className, String ctorArg1, Role ctorArg2) throws Exception {
        Class<?> clazz = clazzMap.get(className);
        if (clazz == null) {
            clazz = SecurityActions.getClass(className);
            clazzMap.put(className, clazz);
        }
        Constructor<?> ctr = clazz.getConstructor(String.class, Role.class);
        return ctr.newInstance(ctorArg1, ctorArg2);
    }
}

