/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.ext.impl;

import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ActivityTypeUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.SpaceStorageException;
import org.exoplatform.wiki.ext.impl.WikiUIActivity;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.listener.PageWikiListener;
import org.exoplatform.wiki.utils.Utils;
import org.xwiki.rendering.syntax.Syntax;

public class WikiSpaceActivityPublisher
extends PageWikiListener {
    public static final String WIKI_APP_ID = "ks-wiki:spaces";
    public static final String ACTIVITY_TYPE_KEY = "act_key";
    public static final String PAGE_ID_KEY = "page_id";
    public static final String PAGE_TYPE_KEY = "page_type";
    public static final String PAGE_OWNER_KEY = "page_owner";
    public static final String PAGE_TITLE_KEY = "page_name";
    public static final String URL_KEY = "page_url";
    public static final String PAGE_EXCERPT = "page_exceprt";
    public static final String VIEW_CHANGE_URL_KEY = "view_change_url";
    public static final String VIEW_CHANGE_ANCHOR = "#CompareRevision/changes";
    public static final String WIKI_PAGE_NAME = "wiki";
    public static final String WIKI_PAGE_VERSION = "version";
    private static final int EXCERPT_LENGTH = 140;
    private static final Log LOG = ExoLogger.getExoLogger(WikiSpaceActivityPublisher.class);

    private ExoSocialActivityImpl createNewActivity(String ownerId) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setUserId(ownerId);
        activity.setBody("body");
        activity.setType(WIKI_APP_ID);
        return activity;
    }

    private ExoSocialActivity generateActivity(Identity ownerStream, Identity ownerIdentity, String wikiType, String wikiOwner, String pageId, Page page, String spaceUrl, String spaceName, String activityType) throws Exception {
        Node node = page.getJCRPageNode();
        ExoSocialActivity activity = null;
        boolean isNewActivity = false;
        ActivityManager activityManager = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
        if (node.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)) {
            try {
                String nodeActivityID = node.getProperty(ActivityTypeUtils.EXO_ACTIVITY_ID).getString();
                activity = activityManager.getActivity(nodeActivityID);
                isNewActivity = false;
            }
            catch (Exception e) {
                LOG.info((Object)"cannot get activity");
            }
        }
        if (activity == null) {
            if (page.isMinorEdit()) {
                return null;
            }
            activity = this.createNewActivity(ownerIdentity.getId());
            isNewActivity = true;
        }
        activity.setTitle(page.getTitle());
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put(PAGE_ID_KEY, pageId);
        templateParams.put(ACTIVITY_TYPE_KEY, activityType);
        templateParams.put(PAGE_OWNER_KEY, wikiOwner);
        templateParams.put(PAGE_TYPE_KEY, wikiType);
        templateParams.put(PAGE_TITLE_KEY, page.getTitle());
        String pageURL = page.getURL() == null ? (spaceUrl != null ? spaceUrl + "/" + WIKI_PAGE_NAME : "") : page.getURL();
        templateParams.put(URL_KEY, pageURL);
        int versionsTotal = page.getVersionableMixin().getVersionHistory().getChildren().size() - 1;
        templateParams.put(WIKI_PAGE_VERSION, String.valueOf(versionsTotal));
        StringBuffer excerpt = new StringBuffer();
        RenderingService renderingService = (RenderingService)PortalContainer.getInstance().getComponentInstanceOfType(RenderingService.class);
        excerpt.append(renderingService.render(page.getContent().getText(), page.getSyntax(), Syntax.PLAIN_1_0.toIdString(), false));
        if (excerpt.length() > 140) {
            excerpt.replace(140, excerpt.length(), "...");
        }
        templateParams.put(PAGE_EXCERPT, this.validateExcerpt(excerpt.toString()));
        templateParams.put("registeredKeysForProcessor", PAGE_EXCERPT);
        if (!"add_page".equals(activityType)) {
            String verName = ((PageImpl)page).getVersionableMixin().getBaseVersion().getName();
            templateParams.put(VIEW_CHANGE_URL_KEY, Utils.getURL((String)page.getURL(), (String)verName));
        }
        activity.setTemplateParams(templateParams);
        if (isNewActivity) {
            activityManager.saveActivityNoReturn(ownerStream, activity);
        } else {
            if ("movePage".equals(activityType)) {
                activity.setStreamOwner(ownerStream.getRemoteId());
            }
            activityManager.updateActivity(activity);
        }
        if (!"add_page".equals(activityType)) {
            String comment;
            if ("editPageTitle".equals(activityType) && !page.isMinorEdit()) {
                this.createAndSaveSystemComment(activity, ownerIdentity.getId(), "WikiUIActivity.msg.update-page-title", page.getTitle());
            } else if ("editPageContent".equals(activityType) && !page.isMinorEdit()) {
                comment = page.getComment();
                if (StringUtils.isEmpty((String)comment)) {
                    this.createAndSaveSystemComment(activity, ownerIdentity.getId(), "WikiUIActivity.msg.update-page-content", new String[0]);
                } else {
                    this.createAndSaveUserComment(activity, ownerIdentity.getId(), comment);
                }
            } else if ("editPageContentAndTitle".equals(activityType) && !page.isMinorEdit()) {
                comment = page.getComment();
                if (StringUtils.isEmpty((String)comment)) {
                    this.createAndSaveComment(activity, WikiUIActivity.CommentType.SYSTEM_GROUP, ownerIdentity.getId(), null, "WikiUIActivity.msg.update-page-title", new String[]{page.getTitle()}, "WikiUIActivity.msg.update-page-content", null);
                } else {
                    this.createAndSaveComment(activity, WikiUIActivity.CommentType.SYSTEM_GROUP, ownerIdentity.getId(), null, "WikiUIActivity.msg.update-page-title", new String[]{page.getTitle()}, comment, null);
                }
            } else if ("movePage".equals(activityType)) {
                WikiService wikiService = (WikiService)PortalContainer.getInstance().getComponentInstanceOfType(WikiService.class);
                List breadcrumbDatas = wikiService.getBreadcumb(wikiType, wikiOwner, pageId);
                StringBuffer breadcrumText = new StringBuffer();
                breadcrumText.append(StringUtils.isEmpty((String)spaceName) ? wikiOwner : spaceName).append(" > ");
                for (int i = 0; i < breadcrumbDatas.size(); ++i) {
                    breadcrumText.append(((BreadcrumbData)breadcrumbDatas.get(i)).getTitle());
                    if (i >= breadcrumbDatas.size() - 1) continue;
                    breadcrumText.append(" > ");
                }
                this.createAndSaveSystemComment(activity, ownerIdentity.getId(), "WikiUIActivity.msg.move-page", breadcrumText.toString());
            }
        }
        return activity;
    }

    private String validateExcerpt(String excerpt) {
        String[] lines = excerpt.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() <= 140) continue;
            lines[i] = lines[i].substring(0, 140) + "...";
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < Math.min(lines.length, 4); ++i) {
            result.append(lines[i]);
            result.append("\n");
        }
        if (lines.length > 4) {
            result.append("...");
        }
        return result.toString();
    }

    private void createAndSaveSystemComment(ExoSocialActivity activity, String userId, String commentMsgKey, String ... args) {
        this.createAndSaveComment(activity, WikiUIActivity.CommentType.SYSTEM, userId, null, commentMsgKey, args, null, null);
    }

    private void createAndSaveUserComment(ExoSocialActivity activity, String userId, String comment) {
        this.createAndSaveComment(activity, WikiUIActivity.CommentType.USER, userId, comment, null, null, null, null);
    }

    private void createAndSaveComment(ExoSocialActivity activity, WikiUIActivity.CommentType commentType, String userId, String userComment, String commentMsgKey1, String[] args1, String commentMsgKey2, String[] args2) {
        ActivityManager activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
        ExoSocialActivityImpl newComment = new ExoSocialActivityImpl();
        newComment.setUserId(userId);
        HashMap<String, String> activityParams = new HashMap<String, String>();
        activityParams.put("commentType", commentType.name());
        switch (commentType) {
            case USER: {
                newComment.setTitle(userComment);
                break;
            }
            case SYSTEM: {
                activityParams.put("commentMessageKey", commentMsgKey1);
                activityParams.put("messageArgs", StringUtils.join((Object[])args1, (String)"\n"));
                break;
            }
            case SYSTEM_GROUP: {
                activityParams.put("commentMessageKey1", commentMsgKey1);
                activityParams.put("messageArgs1", StringUtils.join((Object[])args1, (String)"\n"));
                activityParams.put("commentMessageKey2", commentMsgKey2);
                activityParams.put("messageArgs2", StringUtils.join((Object[])args2, (String)"\n"));
            }
        }
        newComment.setTemplateParams(activityParams);
        activityM.saveComment(activity, (ExoSocialActivity)newComment);
    }

    private boolean isPublic(Page page) throws Exception {
        HashMap permissions = page.getPermission();
        return permissions != null && permissions.containsKey(IdentityConstants.ANY) && ArrayUtils.contains((Object[])((Object[])permissions.get(IdentityConstants.ANY)), (Object)"read");
    }

    private boolean isPublicInSpace(Page page, Space space) throws Exception {
        String groupMemberShip;
        HashMap pagePermissions = page.getPermission();
        return pagePermissions.containsKey(groupMemberShip = "*:" + space.getGroupId()) && ArrayUtils.contains((Object[])((Object[])pagePermissions.get(groupMemberShip)), (Object)"read");
    }

    private void saveActivity(String wikiType, String wikiOwner, String pageId, Page page, String activityType) throws Exception {
        String spaceName;
        String spaceUrl;
        ExoSocialActivity activity;
        Identity authorActivity;
        Identity ownerStream;
        Identity userIdentity;
        block13: {
            try {
                Class.forName("org.exoplatform.social.core.space.spi.SpaceService");
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"eXo Social components not found!", (Throwable)e);
                }
                return;
            }
            if (PortalConfig.USER_TYPE.equals(wikiType) || !this.isPublic(page)) {
                return;
            }
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            IdentityManager identityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
            userIdentity = identityM.getOrCreateIdentity("organization", username, false);
            ownerStream = null;
            authorActivity = userIdentity;
            activity = null;
            spaceUrl = null;
            spaceName = null;
            if (PortalConfig.GROUP_TYPE.equals(wikiType)) {
                SpaceService spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
                Space space = null;
                try {
                    space = spaceService.getSpaceByGroupId(wikiOwner);
                    if (space != null) {
                        if (!this.isPublicInSpace(page, space)) {
                            return;
                        }
                        ownerStream = identityM.getOrCreateIdentity("space", space.getPrettyName(), false);
                        spaceUrl = space.getUrl();
                        spaceName = space.getDisplayName();
                    }
                }
                catch (SpaceStorageException e) {
                    if (!LOG.isDebugEnabled()) break block13;
                    LOG.debug((Object)String.format("Space %s not existed", wikiOwner), (Throwable)e);
                }
            }
        }
        if (ownerStream == null) {
            ownerStream = userIdentity;
        }
        if (ownerStream != null) {
            activity = this.generateActivity(ownerStream, authorActivity, wikiType, wikiOwner, pageId, page, spaceUrl, spaceName, activityType);
            if (activity == null) {
                return;
            }
            Node node = page.getJCRPageNode();
            String activityId = activity.getId();
            if (!StringUtils.isEmpty((String)activityId)) {
                ActivityTypeUtils.attachActivityId((Node)node, (String)activityId);
            }
        }
    }

    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws Exception {
        if ("WikiHome".equals(pageId)) {
            return;
        }
        this.saveActivity(wikiType, wikiOwner, pageId, page, "add_page");
    }

    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws Exception {
        Node node = page.getJCRPageNode();
        ActivityManager activityManager = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
        if (node.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)) {
            String nodeActivityID = node.getProperty(ActivityTypeUtils.EXO_ACTIVITY_ID).getString();
            activityManager.deleteActivity(nodeActivityID);
        }
    }

    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, String wikiUpdateType) throws Exception {
        if (page != null) {
            this.saveActivity(wikiType, wikiOwner, pageId, page, wikiUpdateType);
        }
    }
}

