/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.chart.source.table;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.xwiki.rendering.internal.macro.chart.source.LocaleConfiguration;
import org.xwiki.rendering.internal.macro.chart.source.table.TableDatasetBuilder;
import org.xwiki.rendering.macro.MacroExecutionException;

public class TableCategoryDatasetBuilder
implements TableDatasetBuilder {
    private final DefaultCategoryDataset dataset = new DefaultCategoryDataset();
    private String[] rowKeys;
    private String[] columnKeys;
    private boolean transpose;
    private final Set<String> rowKeySet = new HashSet<String>();
    private final Set<String> columnKeySet = new HashSet<String>();

    @Override
    public void setNumberOfRows(int numberOfRows) {
        this.rowKeys = new String[numberOfRows];
    }

    @Override
    public void setNumberOfColumns(int numberOfColumns) {
        this.columnKeys = new String[numberOfColumns];
    }

    @Override
    public void setTranspose(boolean transpose) {
        this.transpose = transpose;
    }

    @Override
    public void setColumnHeading(int columnIndex, String heading) throws MacroExecutionException {
        if (this.columnKeySet.contains(heading)) {
            throw new MacroExecutionException(String.format("Duplicate column keys in table: [%s]", heading));
        }
        this.columnKeySet.add(heading);
        this.columnKeys[columnIndex] = heading;
    }

    @Override
    public void setRowHeading(int rowIndex, String heading) throws MacroExecutionException {
        if (this.rowKeySet.contains(heading)) {
            throw new MacroExecutionException(String.format("Duplicate row keys in table: [%s]", heading));
        }
        this.rowKeySet.add(heading);
        this.rowKeys[rowIndex] = heading;
    }

    @Override
    public void setValue(int rowIndex, int columnIndex, Number value) {
        if (this.transpose) {
            this.dataset.addValue(value, (Comparable)((Object)this.columnKeys[columnIndex]), (Comparable)((Object)this.rowKeys[rowIndex]));
        } else {
            this.dataset.addValue(value, (Comparable)((Object)this.rowKeys[rowIndex]), (Comparable)((Object)this.columnKeys[columnIndex]));
        }
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
    }

    @Override
    public boolean forceColumnHeadings() {
        return false;
    }

    @Override
    public boolean forceRowHeadings() {
        return false;
    }

    @Override
    public void setLocaleConfiguration(LocaleConfiguration localeConfiguration) {
    }
}

