/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.api.notification.service.storage.NotificationDataStorage;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class Utils {
    private static final Pattern MENTION_PATTERN = Pattern.compile("<a href=\"([\\w|/]+|)/profile/([\\w]+)\">([\\w|\\s]+|)</a>");
    private static final Pattern LINK_PATTERN = Pattern.compile("<a ([^>]+)>([^<]+)</a>");
    private static final String styleCSS = " style=\"color: #2f5e92; text-decoration: none;\"";

    public static <T> T getService(Class<T> clazz) {
        return (T)PortalContainer.getInstance().getComponentInstanceOfType(clazz);
    }

    public static NotificationDataStorage getSocialEmailStorage() {
        return Utils.getService(NotificationDataStorage.class);
    }

    public static String getUserId(String identityId) {
        return Utils.getIdentityManager().getIdentity(identityId, false).getRemoteId();
    }

    public static List<String> toListUserIds(String ... userIds) {
        ArrayList<String> ids = new ArrayList<String>();
        for (String userId : userIds) {
            ids.add(userId);
        }
        return ids;
    }

    public static boolean isSpaceActivity(ExoSocialActivity activity) {
        Identity id = Utils.getIdentityManager().getOrCreateIdentity("space", activity.getStreamOwner(), false);
        return id != null;
    }

    public static void sendToCommeters(Set<String> receivers, String[] commenters, String poster) {
        receivers.addAll(Utils.getDestinataires(commenters, poster));
    }

    public static void sendToStreamOwner(Set<String> receivers, String streamOwner, String posteId) {
        Identity id = Utils.getIdentityManager().getOrCreateIdentity("space", streamOwner, false);
        if (id != null) {
            return;
        }
        String postRemoteId = Utils.getUserId(posteId);
        if (!streamOwner.equals(postRemoteId)) {
            receivers.add(streamOwner);
        }
    }

    public static void sendToActivityPoster(Set<String> receivers, String activityPosterId, String posteId) {
        String activityPosterRemoteId = Utils.getUserId(activityPosterId);
        if (!activityPosterId.equals(posteId)) {
            receivers.add(activityPosterRemoteId);
        }
    }

    public static void sendToMentioners(Set<String> receivers, String[] mentioners, String poster) {
        receivers.addAll(Utils.getDestinataires(mentioners, poster));
    }

    private static Set<String> getDestinataires(String[] users, String poster) {
        HashSet<String> destinataires = new HashSet<String>();
        for (String user : users) {
            user = user.split("@")[0];
            String userName = Utils.getUserId(user);
            if (user.equals(poster)) continue;
            destinataires.add(userName);
        }
        return destinataires;
    }

    public static String processMentions(String title) {
        Matcher matcher = MENTION_PATTERN.matcher(title);
        String domain = System.getProperty("gatein.email.domain.url", "http://localhost:8080");
        while (matcher.find()) {
            String remoteId = matcher.group(2);
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", remoteId, false);
            if (identity == null) continue;
            String result = matcher.group();
            String host = matcher.group(1);
            title = title.replace(result, result.replace(host, domain + host));
        }
        return title;
    }

    public static String processLinkTitle(String title) {
        Matcher matcher = LINK_PATTERN.matcher(title);
        while (matcher.find()) {
            String result = matcher.group(1);
            title = title.replace(result, result + styleCSS);
        }
        return title;
    }

    public static List<String> getDestinataires(ExoSocialActivity activity, Space space) {
        ArrayList<String> destinataires = new ArrayList<String>();
        String poster = Utils.getUserId(activity.getPosterId());
        for (String member : space.getMembers()) {
            if (member.equals(poster)) continue;
            destinataires.add(member);
        }
        return destinataires;
    }

    public static IdentityManager getIdentityManager() {
        return Utils.getService(IdentityManager.class);
    }

    public static SpaceService getSpaceService() {
        return Utils.getService(SpaceService.class);
    }

    public static ActivityManager getActivityManager() {
        return Utils.getService(ActivityManager.class);
    }
}

