/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationPlugin;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class ActivityMentionPlugin
extends AbstractNotificationPlugin {
    public static final String ID = "ActivityMentionPlugin";

    public ActivityMentionPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        HashSet<String> receivers = new HashSet<String>();
        Utils.sendToMentioners(receivers, activity.getMentionedIds(), activity.getPosterId());
        return NotificationInfo.instance().key(this.getKey()).to(new ArrayList<String>(receivers)).with("poster", Utils.getUserId(activity.getPosterId())).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), activity.getId()).end();
    }

    public MessageInfo makeMessage(NotificationContext ctx) {
        MessageInfo messageInfo = new MessageInfo();
        NotificationInfo notification = ctx.getNotificationInfo();
        String language = this.getLanguage(notification);
        TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
        SocialNotificationUtils.addFooterAndFirstName(notification.getTo(), templateContext);
        String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
        ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
        Identity identity = Utils.getIdentityManager().getIdentity(activity.getPosterId(), true);
        templateContext.put((Object)"USER", (Object)identity.getProfile().getFullName());
        String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
        if (activity.isComment()) {
            ExoSocialActivity parentActivity = Utils.getActivityManager().getParentActivity(activity);
            activityId = parentActivity.getId();
            templateContext.put((Object)"REPLY_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("reply_activity_highlight_comment", activityId + "-" + activity.getId()));
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("view_full_activity_highlight_comment", activityId + "-" + activity.getId()));
        } else {
            templateContext.put((Object)"REPLY_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("reply_activity", activityId));
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("view_full_activity", activityId));
        }
        templateContext.put((Object)"AVATAR", (Object)LinkProviderUtils.getUserAvatarUrl(identity.getProfile()));
        templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl("user", identity.getRemoteId()));
        templateContext.put((Object)"ACTIVITY", (Object)Utils.processMentions(activity.getTitle()));
        String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
        return messageInfo.subject(subject).body(body).end();
    }

    public boolean makeDigest(NotificationContext ctx, Writer writer) {
        List notifications = ctx.getNotificationInfos();
        NotificationInfo first = (NotificationInfo)notifications.get(0);
        String language = this.getLanguage(first);
        TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
        LinkedHashMap<String, List<String>> receiverMap = new LinkedHashMap<String, List<String>>();
        try {
            for (NotificationInfo notification : notifications) {
                String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
                ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
                Identity identity = Utils.getIdentityManager().getIdentity(activity.getPosterId(), true);
                if (activity.isComment()) {
                    activity = Utils.getActivityManager().getParentActivity(activity);
                }
                SocialNotificationUtils.processInforSendTo(receiverMap, activity.getId(), identity.getRemoteId());
            }
            writer.append(SocialNotificationUtils.getMessageByIds(receiverMap, templateContext));
        }
        catch (IOException e) {
            ctx.setException((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isValid(NotificationContext ctx) {
        ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        return activity.getMentionedIds().length > 0;
    }
}

